(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   3233652,      56882]
NotebookOptionsPosition[   3228238,      56751]
NotebookOutlinePosition[   3228941,      56775]
CellTagsIndexPosition[   3228898,      56772]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}],
   FontSize->12], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Interpolacione", " ", "funkcije"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N9Ja", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Xi]", "2"]}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Eta]", "2"]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N5Ja", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Xi]", "2"]}], ")"}], "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "-", "\[Eta]"}], "2"], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N6Ja", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Eta]", "2"]}], ")"}], "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "+", "\[Xi]"}], "2"], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N7Ja", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Xi]", "2"]}], ")"}], "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "+", "\[Eta]"}], "2"], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N8Ja", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[Eta]", "2"]}], ")"}], "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"1", "-", "\[Xi]"}], "2"], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1Ja", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Xi]"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Eta]"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", 
     RowBox[{"(", 
      RowBox[{"N5Ja", "+", "N8Ja"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N2Ja", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Xi]"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Eta]"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", 
     RowBox[{"(", 
      RowBox[{"N5Ja", "+", "N6Ja"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N3Ja", "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "4"], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Xi]"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Eta]"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], "*", 
     RowBox[{"(", 
      RowBox[{"N6Ja", "+", "N7Ja"}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "4"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N4Ja", "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Xi]"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Eta]"}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", "2"], "*", 
      RowBox[{"(", 
       RowBox[{"N7Ja", "+", "N8Ja"}], ")"}]}], "-", 
     RowBox[{
      FractionBox["1", "4"], "*", "N9Ja"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Pujevic", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NiPujke", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "*", "\[Xi]", "*", "\[Xi]i", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[Xi]", "*", "\[Xi]i"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Xi]", "2"]}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Xi]i", "2"]}], ")"}]}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "*", "\[Eta]", "*", "\[Eta]i", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[Eta]", "*", "\[Eta]i"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Eta]", "2"]}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["\[Eta]i", "2"]}], ")"}]}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stil1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.3", ",", 
        RowBox[{"-", "2.4"}], ",", "2"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Opacity", "[", "0.3", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"Mesh", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     "             ", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", "\[Eta]", ",", "z"}], "}"}], ",", 
        RowBox[{"GrayLevel", "[", "0.8", "]"}]}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gOsnova", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"0", "*", "\[Xi]", "*", "\[Eta]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil1", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stil2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.3", ",", 
        RowBox[{"-", "2.4"}], ",", "2"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Opacity", "[", "0.3", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "             ", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", "\[Eta]", ",", "z"}], "}"}], ",", 
        RowBox[{"GrayLevel", "[", 
         RowBox[{"0.8", "*", "z"}], "]"}]}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stil3", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1.3", ",", 
         RowBox[{"-", "2.4"}], ",", "2"}], "}"}]}], ",", 
      RowBox[{"Background", "\[Rule]", "White"}], ",", "\[IndentingNewLine]", 
      "           ", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"600", ",", "Automatic"}], "}"}]}], ",", 
      "\[IndentingNewLine]", "           ", 
      RowBox[{"Axes", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", " ", "False", ",", " ", "False"}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", "Black", "]"}]}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
      "\[IndentingNewLine]", "           ", 
      RowBox[{"Boxed", "\[Rule]", "True"}], ",", 
      RowBox[{"BoxStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.003", "]"}]}], "}"}], "]"}]}], ",", 
      "\[IndentingNewLine]", "           ", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "\[Rule]", "\"\<Calibri\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "30"}], ",", 
         RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "}"}]}]}], "}"}]}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N1", "]"}]}], "]"}], ";", 
  RowBox[{"gN1", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N1", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN1", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N2", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", "1"}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N2", "]"}]}], "]"}], ";", 
  RowBox[{"gN2", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N2", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN2", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N3", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", "1"}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", "1"}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N3", "]"}]}], "]"}], ";", 
  RowBox[{"gN3", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N3", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN3", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N4", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", "1"}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N4", "]"}]}], "]"}], ";", 
  RowBox[{"gN4", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N4", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN4", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N5", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N5", "]"}]}], "]"}], ";", 
  RowBox[{"gN5", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N5", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN5", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N6", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", "1"}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", "0"}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N6", "]"}]}], "]"}], ";", 
  RowBox[{"gN6", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N6", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN6", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N7", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", "0"}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", "1"}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N7", "]"}]}], "]"}], ";", 
  RowBox[{"gN7", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N7", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN7", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N8", "=", 
   RowBox[{"NiPujke", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]i", "\[Rule]", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"\[Eta]i", "\[Rule]", "0"}]}], "}"}]}]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8 = \>\"", ",", 
    RowBox[{"Simplify", "[", "N8", "]"}]}], "]"}], ";", 
  RowBox[{"gN8", "=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{"N8", ",", 
     RowBox[{"{", 
      RowBox[{"\[Xi]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Eta]", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
  RowBox[{"Show", "[", 
   RowBox[{"gOsnova", ",", "gN8", ",", 
    RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"N9", "=", 
    RowBox[{"NiPujke", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Xi]i", "\[Rule]", "0"}], ",", 
       RowBox[{"\[Eta]i", "\[Rule]", "0"}]}], "}"}]}]}], ";", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<N9 = \>\"", ",", 
     RowBox[{"Simplify", "[", "N9", "]"}]}], "]"}], ";", 
   RowBox[{"gN9", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{"N9", ",", 
      RowBox[{"{", 
       RowBox[{"\[Xi]", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Eta]", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Evaluate", "[", "stil2", "]"}]}], "]"}]}], ";", 
   RowBox[{"Show", "[", 
    RowBox[{"gOsnova", ",", "gN9", ",", 
     RowBox[{"Evaluate", "[", "stil3", "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ni", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "N1", ",", "0", ",", "N2", ",", "0", ",", "N3", ",", "0", ",", "N4", 
       ",", "0", ",", "N5", ",", "0", ",", "N6", ",", "0", ",", "N7", ",", 
       "0", ",", "N8", ",", "0", ",", "N9", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "N1", ",", "0", ",", "N2", ",", "0", ",", "N3", ",", "0", ",",
        "N4", ",", "0", ",", "N5", ",", "0", ",", "N6", ",", "0", ",", "N7", 
       ",", "0", ",", "N8", ",", "0", ",", "N9"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<N = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", "Ni", "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "Kontrola", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1Ja - N1Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N1Ja", "-", "N1"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N2Ja - N2Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N2Ja", "-", "N2"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N3Ja - N3Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N3Ja", "-", "N3"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N4Ja - N4Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N4Ja", "-", "N4"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N5Ja - N5Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N5Ja", "-", "N5"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N6Ja - N6Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N6Ja", "-", "N6"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N7Ja - N7Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N7Ja", "-", "N7"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N8Ja - N8Pujke = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"N8Ja", "-", "N8"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<N9Ja - N9Pujke = \>\"", ",", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"N9Ja", "-", "N9"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Geometrija", " ", "-", " ", 
    RowBox[{"izoparametarski", " ", "element"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"x1", "*", "N1"}], "+", 
    RowBox[{"x2", "*", "N2"}], "+", 
    RowBox[{"x3", "*", "N3"}], "+", 
    RowBox[{"x4", "*", "N4"}], "+", 
    RowBox[{"x5", "*", "N5"}], "+", 
    RowBox[{"x6", "*", "N6"}], "+", 
    RowBox[{"x7", "*", "N7"}], "+", 
    RowBox[{"x8", "*", "N8"}], "+", 
    RowBox[{"x9", "*", "N9"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"y1", "*", "N1"}], "+", 
     RowBox[{"y2", "*", "N2"}], "+", 
     RowBox[{"y3", "*", "N3"}], "+", 
     RowBox[{"y4", "*", "N4"}], "+", 
     RowBox[{"y5", "*", "N5"}], "+", 
     RowBox[{"y6", "*", "N6"}], "+", 
     RowBox[{"y7", "*", "N7"}], "+", 
     RowBox[{"y8", "*", "N8"}], "+", 
     RowBox[{"y9", "*", "N9"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Jakobijeva", " ", "matrica", " ", "i", " ", "njena", " ", 
    "determinanta"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J11", "=", 
   RowBox[{"D", "[", 
    RowBox[{"x", ",", "\[Xi]"}], "]"}]}], ";", 
  RowBox[{"J12", "=", 
   RowBox[{"D", "[", 
    RowBox[{"y", ",", "\[Xi]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"J21", "=", 
   RowBox[{"D", "[", 
    RowBox[{"x", ",", "\[Eta]"}], "]"}]}], ";", 
  RowBox[{"J22", "=", 
   RowBox[{"D", "[", 
    RowBox[{"y", ",", "\[Eta]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Jakobi", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"J11", ",", "J12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"J21", ",", "J22"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "Jakobi", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J11 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Jakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J12 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Jakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J21 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Jakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J22 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{"Jakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Opsti oblik determinante Jakobijeve matrice = \>\"", ",", 
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"JJ11", ",", "JJ12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"JJ21", ",", "JJ22"}], "}"}]}], "}"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobi", "=", 
   RowBox[{
    RowBox[{"J11", "*", "J22"}], "-", 
    RowBox[{"J12", "*", "J21"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<detJakobi = \>\"", ",", 
    RowBox[{"Simplify", "[", "detJakobi", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Kontrola: Det[Jakobi] - J11*J22-J12*J21 = \>\"", ",", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"Det", "[", "Jakobi", "]"}], " ", "-", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"J11", "*", "J22"}], "-", 
        RowBox[{"J12", "*", "J21"}]}], ")"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Opsti oblik inverzne Jakobijeve matrice = \!\(\*FractionBox[\(1\), \
\(detJakobi\)]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{
      RowBox[{"Det", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"JJ11", ",", "JJ12"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"JJ21", ",", "JJ22"}], "}"}]}], "}"}], "]"}], "*", 
      RowBox[{"Inverse", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"JJ11", ",", "JJ12"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"JJ21", ",", "JJ22"}], "}"}]}], "}"}], "]"}]}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inverznaJakobi", "=", 
   RowBox[{
    FractionBox["1", "detJakobi"], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"J22", ",", 
        RowBox[{"-", "J12"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "J21"}], ",", "J11"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<inverznaJakobi = \!\(\*FractionBox[\(1\), \(detJakobi\)]\)\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"inverznaJakobi", "*", "detJakobi"}], "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Kontrola: Inverse[Jakobi] - \!\(\*FractionBox[\(1\), \
\(detJakobi\)]\)*{{J22,-J12},{-J21,J11}} = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Inverse", "[", "Jakobi", "]"}], " ", "-", " ", 
        RowBox[{
         FractionBox["1", "detJakobi"], "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"J22", ",", 
             RowBox[{"-", "J12"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "J21"}], ",", "J11"}], "}"}]}], "}"}]}]}], "]"}], 
      "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "B", " ", "za", " ", "savijanje"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN1podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN2podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N2", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N2", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN3podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N3", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N3", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN4podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N4", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N4", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN5podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N5", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N5", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN6podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N6", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N6", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN7podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N7", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N7", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN8podx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N8", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N8", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN9podx", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"inverznaJakobi", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{"N9", ",", "\[Xi]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"inverznaJakobi", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{"N9", ",", "\[Eta]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN1pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N1", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN2pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N2", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N2", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN3pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N3", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N3", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN4pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N4", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N4", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN5pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N5", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N5", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN6pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N6", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N6", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN7pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N7", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N7", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dN8pody", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N8", ",", "\[Xi]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"inverznaJakobi", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{"N8", ",", "\[Eta]"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dN9pody", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"inverznaJakobi", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{"N9", ",", "\[Xi]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"inverznaJakobi", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{"N9", ",", "\[Eta]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "dN1podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN2podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN3podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN4podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN5podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN6podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN7podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN8podx"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN9podx"}], ",", "0"}], "}"}], ",", 
     "\[IndentingNewLine]", "         ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "dN1pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN2pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN3pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN4pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN5pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN6pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN7pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN8pody"}], ",", "0", ",", "0", ",", 
       RowBox[{"-", "dN9pody"}]}], "}"}], ",", "\[IndentingNewLine]", 
     "         ", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "dN1pody"}], ",", 
       RowBox[{"-", "dN1podx"}], ",", "0", ",", 
       RowBox[{"-", "dN2pody"}], ",", 
       RowBox[{"-", "dN2podx"}], ",", "0", ",", 
       RowBox[{"-", "dN3pody"}], ",", 
       RowBox[{"-", "dN3podx"}], ",", "0", ",", 
       RowBox[{"-", "dN4pody"}], ",", 
       RowBox[{"-", "dN4podx"}], ",", "0", ",", 
       RowBox[{"-", "dN5pody"}], ",", 
       RowBox[{"-", "dN5podx"}], ",", "0", ",", 
       RowBox[{"-", "dN6pody"}], ",", 
       RowBox[{"-", "dN6podx"}], ",", "0", ",", 
       RowBox[{"-", "dN7pody"}], ",", 
       RowBox[{"-", "dN7podx"}], ",", "0", ",", 
       RowBox[{"-", "dN8pody"}], ",", 
       RowBox[{"-", "dN8podx"}], ",", "0", ",", 
       RowBox[{"-", "dN9pody"}], ",", 
       RowBox[{"-", "dN9podx"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Bsav = \!\(\*FractionBox[\(1\), \(detJakobi\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Bsav", "*", "detJakobi"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "B", " ", "za", " ", "smicanje"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsmic", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dN1podx", ",", 
       RowBox[{"-", "N1"}], ",", "0", ",", "dN2podx", ",", 
       RowBox[{"-", "N2"}], ",", "0", ",", "dN3podx", ",", 
       RowBox[{"-", "N3"}], ",", "0", ",", "dN4podx", ",", 
       RowBox[{"-", "N4"}], ",", "0", ",", "dN5podx", ",", 
       RowBox[{"-", "N5"}], ",", "0", ",", "dN6podx", ",", 
       RowBox[{"-", "N6"}], ",", "0", ",", "dN7podx", ",", 
       RowBox[{"-", "N7"}], ",", "0", ",", "dN8podx", ",", 
       RowBox[{"-", "N8"}], ",", "0", ",", "dN9podx", ",", 
       RowBox[{"-", "N9"}], ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
     "           ", 
     RowBox[{"{", 
      RowBox[{"dN1pody", ",", "0", ",", 
       RowBox[{"-", "N1"}], ",", "dN2pody", ",", "0", ",", 
       RowBox[{"-", "N2"}], ",", "dN3pody", ",", "0", ",", 
       RowBox[{"-", "N3"}], ",", "dN4pody", ",", "0", ",", 
       RowBox[{"-", "N4"}], ",", "dN5pody", ",", "0", ",", 
       RowBox[{"-", "N5"}], ",", "dN6pody", ",", "0", ",", 
       RowBox[{"-", "N6"}], ",", "dN7pody", ",", "0", ",", 
       RowBox[{"-", "N7"}], ",", "dN8pody", ",", "0", ",", 
       RowBox[{"-", "N8"}], ",", "dN9pody", ",", "0", ",", 
       RowBox[{"-", "N9"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Bsmic = \!\(\*FractionBox[\(1\), \(detJakobi\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Bsmic", "*", "detJakobi"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "elasticnosti", " ", "za", " ", "savijanje"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dsav", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Em", "*", 
      SuperscriptBox["hp", "3"]}], 
     RowBox[{"12", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Nu]", "2"]}], ")"}]}]], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "\[Nu]", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Nu]", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        FractionBox[
         RowBox[{"1", "-", "\[Nu]"}], "2"]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Dsav = \!\(\*FractionBox[\(Em*\*SuperscriptBox[\(hp\), \(3\)]\), \
\(12*\((1 - \*SuperscriptBox[\(\[Nu]\), \(2\)])\)\)]\)\>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"12", "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Nu]", "2"]}], ")"}]}], 
         RowBox[{"Em", "*", 
          SuperscriptBox["hp", "3"]}]], "*", "Dsav"}], "]"}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrica", " ", "elasticnosti", " ", "za", " ", "smicanje"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dsmic", "=", 
   RowBox[{
    FractionBox[
     RowBox[{"Em", "*", "hp"}], 
     RowBox[{"2", "*", "k", "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Nu]"}], ")"}]}]], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Dsmic = \!\(\*FractionBox[\(Em*hp\), \(2*k*\((1 + \[Nu])\)\)]\)\>\"",
      ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"2", "*", "k", "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Nu]"}], ")"}]}], 
         RowBox[{"Em", "*", "hp"}]], "*", "Dsmic"}], "]"}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**"}], "*****)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "Numerika", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x11", "=", "0"}], ";", 
  RowBox[{"y11", "=", "0"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 1 = (\>\"", ",", "x11", ",", "\"\<,\>\"", ",", "y11", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x22", "=", "0.5"}], ";", 
  RowBox[{"y22", "=", "0"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 2 = (\>\"", ",", "x22", ",", "\"\<,\>\"", ",", "y22", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x33", "=", "0.5"}], ";", 
  RowBox[{"y33", "=", "0.5"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 3 = (\>\"", ",", "x33", ",", "\"\<,\>\"", ",", "y33", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x44", "=", "0"}], ";", 
  RowBox[{"y44", "=", "0.5"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 4 = (\>\"", ",", "x44", ",", "\"\<,\>\"", ",", "y44", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x55", "=", 
   FractionBox[
    RowBox[{"x11", "+", "x22"}], "2"]}], ";", 
  RowBox[{"y55", "=", 
   FractionBox[
    RowBox[{"y11", "+", "y22"}], "2"]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 5 = (\>\"", ",", "x55", ",", "\"\<,\>\"", ",", "y55", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x66", "=", 
   FractionBox[
    RowBox[{"x22", "+", "x33"}], "2"]}], ";", 
  RowBox[{"y66", "=", 
   FractionBox[
    RowBox[{"y22", "+", "y33"}], "2"]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 6 = (\>\"", ",", "x66", ",", "\"\<,\>\"", ",", "y66", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x77", "=", 
   FractionBox[
    RowBox[{"x33", "+", "x44"}], "2"]}], ";", 
  RowBox[{"y77", "=", 
   FractionBox[
    RowBox[{"y33", "+", "y44"}], "2"]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 7 = (\>\"", ",", "x77", ",", "\"\<,\>\"", ",", "y77", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x88", "=", 
   FractionBox[
    RowBox[{"x11", "+", "x44"}], "2"]}], ";", 
  RowBox[{"y88", "=", 
   FractionBox[
    RowBox[{"y11", "+", "y44"}], "2"]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 8 = (\>\"", ",", "x88", ",", "\"\<,\>\"", ",", "y88", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x99", "=", 
   FractionBox[
    RowBox[{"x66", "+", "x88"}], "2"]}], ";", 
  RowBox[{"y99", "=", 
   FractionBox[
    RowBox[{"y55", "+", "y77"}], "2"]}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Cvor 9 = (\>\"", ",", "x99", ",", "\"\<,\>\"", ",", "y99", ",", 
    "\"\<)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x11", ",", "y11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x55", ",", "y55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x22", ",", "y22"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x66", ",", "y66"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x33", ",", "y33"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x77", ",", "y77"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x44", ",", "y44"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x88", ",", "y88"}], "}"}]}], "}"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Emm", "=", 
   RowBox[{"210", "*", 
    SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LL", "=", "1.0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hpp", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Nu]\[Nu]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kk", "=", "1.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qz", "=", "10.0"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Matrice", " ", "elasticnosti"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DsavNum", "=", 
   RowBox[{"Dsav", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Em", "\[Rule]", "Emm"}], ",", 
      RowBox[{"hp", "\[Rule]", "hpp"}], ",", 
      RowBox[{"\[Nu]", "\[Rule]", "\[Nu]\[Nu]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<DsavNum\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"DsavNum", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "3"}]]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(3\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DsmicNum", "=", 
   RowBox[{"Dsmic", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Em", "\[Rule]", "Emm"}], ",", 
      RowBox[{"hp", "\[Rule]", "hpp"}], ",", 
      RowBox[{"\[Nu]", "\[Rule]", "\[Nu]\[Nu]"}], ",", 
      RowBox[{"k", "\[Rule]", "kk"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<DsmicNum\>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"DsmicNum", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "3"}]]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(3\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Kploce", "=", 
    FractionBox[
     RowBox[{"Emm", "*", 
      SuperscriptBox["hpp", "3"]}], 
     RowBox[{"12", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[Nu]\[Nu]", "2"]}], ")"}]}]]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Savijanje", " ", "-", " ", 
    RowBox[{"tacna", " ", "3", "x3"}], " ", "-", " ", 
    RowBox[{
    "tacke", " ", "integracije", " ", "i", " ", "tezinski", " ", 
     "koeficijenti"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]1sav", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}]}], ";", 
  RowBox[{"\[Eta]1sav", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}]}], ";", 
  RowBox[{"w1sav", "=", 
   RowBox[{
    FractionBox["5", "9"], "*", 
    FractionBox["5", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]2sav", "=", "0"}], ";", 
  RowBox[{"\[Eta]2sav", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}]}], ";", 
  RowBox[{"w2sav", "=", 
   RowBox[{
    FractionBox["8", "9"], "*", 
    FractionBox["5", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]3sav", "=", 
   RowBox[{"Sqrt", "[", "0.6", "]"}]}], ";", 
  RowBox[{"\[Eta]3sav", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}]}], ";", 
  RowBox[{"w3sav", "=", 
   RowBox[{
    FractionBox["5", "9"], "*", 
    FractionBox["5", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]4sav", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}]}], ";", 
  RowBox[{"\[Eta]4sav", "=", "0"}], ";", 
  RowBox[{"w4sav", "=", 
   RowBox[{
    FractionBox["5", "9"], "*", 
    FractionBox["8", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]5sav", "=", "0"}], ";", " ", 
  RowBox[{"\[Eta]5sav", "=", "0"}], ";", 
  RowBox[{"w5sav", "=", 
   RowBox[{
    FractionBox["8", "9"], "*", 
    FractionBox["8", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]6sav", "=", 
   RowBox[{"Sqrt", "[", "0.6", "]"}]}], ";", 
  RowBox[{"\[Eta]6sav", "=", "0"}], ";", 
  RowBox[{"w6sav", "=", 
   RowBox[{
    FractionBox["5", "9"], "*", 
    FractionBox["8", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]7sav", "=", 
   RowBox[{"-", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}]}], ";", 
  RowBox[{"\[Eta]7sav", "=", 
   RowBox[{"Sqrt", "[", "0.6", "]"}]}], ";", 
  RowBox[{"w7sav", "=", 
   RowBox[{
    FractionBox["5", "9"], "*", 
    FractionBox["5", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]8sav", "=", "0"}], ";", " ", 
  RowBox[{"\[Eta]8sav", "=", 
   RowBox[{"Sqrt", "[", "0.6", "]"}]}], ";", 
  RowBox[{"w8sav", "=", 
   RowBox[{
    FractionBox["8", "9"], "*", 
    FractionBox["5", "9"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]9sav", "=", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}], ";", 
   RowBox[{"\[Eta]9sav", "=", 
    RowBox[{"Sqrt", "[", "0.6", "]"}]}], ";", 
   RowBox[{"w9sav", "=", 
    RowBox[{
     FractionBox["5", "9"], "*", 
     FractionBox["5", "9"]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Smicanje", " ", "-", " ", 
    RowBox[{"selektivna", " ", "2", "x2"}], " ", "-", " ", 
    RowBox[{
    "tacke", " ", "integracije", " ", "i", " ", "tezinski", " ", 
     "koeficijenti"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]1smic", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
  RowBox[{"\[Eta]1smic", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
  RowBox[{"w1smic", "=", 
   RowBox[{"1", "*", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]2smic", "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
  RowBox[{"\[Eta]2smic", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
  RowBox[{"w2smic", "=", 
   RowBox[{"1", "*", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Xi]3smic", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "/", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
  RowBox[{"\[Eta]3smic", "=", 
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
  RowBox[{"w3smic", "=", 
   RowBox[{"1", "*", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Xi]4smic", "=", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
   RowBox[{"\[Eta]4smic", "=", 
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]}], ";", 
   RowBox[{"w4smic", "=", 
    RowBox[{"1", "*", "1"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Matrica", " ", "krutosti", " ", "za", " ", "savijanje"}], " ", 
    "-", " ", 
    RowBox[{"tacke", " ", "integracije", " ", "1", " ", "do", " ", "9"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]1sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]1sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<smenaSav1 = \>\"", ",", "smenaSav1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J11 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "/.", "smenaSav1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J12 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", "smenaSav1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J21 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "/.", "smenaSav1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J22 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", "smenaSav1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<inverznaJakobi = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"inverznaJakobi", "/.", "smenaSav1"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav1", "=", 
   RowBox[{"Bsav", "/.", "smenaSav1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Bsav1 = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"N", "[", "Bsav1", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav1", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<detJakobiSav1 = \>\"", ",", 
    RowBox[{"Chop", "[", "detJakobiSav1", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ksav1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "Bsav1", "]"}], ".", "DsavNum", ".", "Bsav1"}],
     "*", "detJakobiSav1", "*", "w1sav"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<ksav1 = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Chop", "[", "ksav1", "]"}], "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], ",", 
     "\"\< * \!\(\*SuperscriptBox[\(10\), \(4\)]\)\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]2sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]2sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav2", "=", 
   RowBox[{"Bsav", "/.", "smenaSav2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav2", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav2", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav2", "]"}], ".", "DsavNum", ".", 
      "Bsav2"}], "*", "detJakobiSav2", "*", "w2sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]3sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]3sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav3", "=", 
   RowBox[{"Bsav", "/.", "smenaSav3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav3", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav3", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav3", "]"}], ".", "DsavNum", ".", 
      "Bsav3"}], "*", "detJakobiSav3", "*", "w3sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]4sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]4sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav4", "=", 
   RowBox[{"Bsav", "/.", "smenaSav4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav4", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav4", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav4", "]"}], ".", "DsavNum", ".", 
      "Bsav4"}], "*", "detJakobiSav4", "*", "w4sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]5sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]5sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav5", "=", 
   RowBox[{"Bsav", "/.", "smenaSav5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav5", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav5", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav5", "]"}], ".", "DsavNum", ".", 
      "Bsav5"}], "*", "detJakobiSav5", "*", "w5sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav6", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]6sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]6sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav6", "=", 
   RowBox[{"Bsav", "/.", "smenaSav6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav6", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav6", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav6", "]"}], ".", "DsavNum", ".", 
      "Bsav6"}], "*", "detJakobiSav6", "*", "w6sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav7", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]7sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]7sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav7", "=", 
   RowBox[{"Bsav", "/.", "smenaSav7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav7", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav7", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav7", "]"}], ".", "DsavNum", ".", 
      "Bsav7"}], "*", "detJakobiSav7", "*", "w7sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav8", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]8sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]8sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav8", "=", 
   RowBox[{"Bsav", "/.", "smenaSav8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav8", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav8", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav8", "]"}], ".", "DsavNum", ".", 
      "Bsav8"}], "*", "detJakobiSav8", "*", "w8sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSav9", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]9sav"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]9sav"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsav9", "=", 
   RowBox[{"Bsav", "/.", "smenaSav9"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSav9", "=", 
   RowBox[{"detJakobi", "/.", "smenaSav9"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksav9", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsav9", "]"}], ".", "DsavNum", ".", 
      "Bsav9"}], "*", "detJakobiSav9", "*", "w9sav"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kUkupnoSav", " ", "=", " ", 
   RowBox[{
   "ksav1", "+", "ksav2", "+", "ksav3", "+", "ksav4", "+", "ksav5", "+", 
    "ksav6", "+", "ksav7", "+", "ksav8", "+", "ksav9"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<kUkupnoSav = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Chop", "[", "kUkupnoSav", "]"}], "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], ",", 
     "\"\< * \!\(\*SuperscriptBox[\(10\), \(4\)]\)\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Matrica", " ", "krutosti", " ", "za", " ", "smicanje"}], " ", 
    "-", " ", 
    RowBox[{"tacke", " ", "integracije", " ", "1", " ", "do", " ", "4"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSmic1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]1smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]1smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J11 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "/.", "smenaSmic1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J12 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", "smenaSmic1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J21 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "/.", "smenaSmic1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<J22 = \>\"", ",", 
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"Jakobi", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", "smenaSmic1"}], "]"}]}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<inverznaJakobi = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"inverznaJakobi", "/.", "smenaSmic1"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsmic1", "=", 
   RowBox[{"Bsmic", "/.", "smenaSmic1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Bsmic1 = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"N", "[", "Bsmic1", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSmic1", "=", 
   RowBox[{"detJakobi", "/.", "smenaSmic1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<detJakobiSmic1 = \>\"", ",", 
    RowBox[{"Chop", "[", "detJakobiSmic1", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ksmic1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "Bsmic1", "]"}], ".", "DsmicNum", ".", 
     "Bsmic1"}], "*", "detJakobiSmic1", "*", "w1smic"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<ksmic1 = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Chop", "[", "ksmic1", "]"}], "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], ",", 
     "\"\< * \!\(\*SuperscriptBox[\(10\), \(4\)]\)\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSmic2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]2smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]2smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsmic2", "=", 
   RowBox[{"Bsmic", "/.", "smenaSmic2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSmic2", "=", 
   RowBox[{"detJakobi", "/.", "smenaSmic2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksmic2", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsmic2", "]"}], ".", "DsmicNum", ".", 
      "Bsmic2"}], "*", "detJakobiSmic2", "*", "w2smic"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSmic3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]3smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]3smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsmic3", "=", 
   RowBox[{"Bsmic", "/.", "smenaSmic3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSmic3", "=", 
   RowBox[{"detJakobi", "/.", "smenaSmic3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksmic3", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsmic3", "]"}], ".", "DsmicNum", ".", 
      "Bsmic3"}], "*", "detJakobiSmic3", "*", "w3smic"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaSmic4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]4smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]4smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bsmic4", "=", 
   RowBox[{"Bsmic", "/.", "smenaSmic4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiSmic4", "=", 
   RowBox[{"detJakobi", "/.", "smenaSmic4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ksmic4", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "Bsmic4", "]"}], ".", "DsmicNum", ".", 
      "Bsmic4"}], "*", "detJakobiSmic4", "*", "w4smic"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kUkupnoSmic", " ", "=", " ", 
   RowBox[{"ksmic1", "+", "ksmic2", "+", "ksmic3", "+", "ksmic4"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<kUkupnoSmic = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Chop", "[", "kUkupnoSmic", "]"}], "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], ",", 
     "\"\< * \!\(\*SuperscriptBox[\(10\), \(4\)]\)\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Ukupna", " ", "matrica", " ", "krutosti"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kUkupno", "=", 
   RowBox[{"kUkupnoSav", "+", "kUkupnoSmic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<kUkupno = kUkupnoSav+kUkupnoSmic = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Chop", "[", 
       RowBox[{"kUkupno", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "4"}]]}], "]"}], "]"}], ",", 
     "\"\< * \!\(\*SuperscriptBox[\(10\), \(4\)]\)\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Svojstvene vrednosti matrice kUkupno = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Chop", "[", 
       RowBox[{"Eigenvalues", "[", "kUkupno", "]"}], "]"}], "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Vektor", " ", "ekvivalentnog", " ", "opterecenja"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Analiticko", " ", "resenje"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaQ", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detJakobiQ", "=", 
   RowBox[{"detJakobi", "/.", "smenaQ"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<detJakobiQ = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"FullSimplify", "[", "detJakobiQ", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QA", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N1", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N2", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N3", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N4", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N5", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N6", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N7", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N8", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"N9", "*", "qz", "*", "detJakobiQ"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Xi]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Eta]", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<QA = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"N", "[", "QA", "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Numericko", " ", "resenje"}], " ", "-", " ", 
    RowBox[{"2", " ", "tacke", " ", "integracije"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaQa", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]1smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]1smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaQb", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]2smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]2smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaQc", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]3smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]3smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaQd", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "\[Xi]4smic"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "\[Eta]4smic"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q1a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N1", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 tacka integracije 1 = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"N1", "/.", "smenaQa"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Q1a tacka integracije 1 = \>\"", ",", "Q1a"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q1b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N1", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 tacka integracije 2 = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"N1", "/.", "smenaQb"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Q1b tacka integracije 2 = \>\"", ",", "Q1b"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q1c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N1", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 tacka integracije 3 = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"N1", "/.", "smenaQc"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Q1c tacka integracije 3 = \>\"", ",", "Q1c"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q1d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N1", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 tacka integracije 4 = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"N1", "/.", "smenaQd"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Q1d tacka integracije 4 = \>\"", ",", "Q1d"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q2a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N2", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q2b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N2", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q2c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N2", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q2d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N2", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q3a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N3", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q3b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N3", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q3c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N3", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q3d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N3", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q4a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N4", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q4b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N4", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q4c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N4", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q4d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N4", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q5a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N5", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q5b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N5", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q5c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N5", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q5d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N5", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q6a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N6", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q6b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N6", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q6c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N6", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q6d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N6", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q7a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N7", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q7b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N7", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q7c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N7", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q7d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N7", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q8a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N8", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q8b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N8", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q8c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N8", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q8d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N8", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q9a", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N9", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQa"}], 
     ")"}], "*", "w1smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q9b", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N9", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQb"}], 
     ")"}], "*", "w2smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q9c", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N9", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQc"}], 
     ")"}], "*", "w3smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q9d", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N9", "*", "qz", "*", "detJakobi"}], ")"}], "/.", "smenaQd"}], 
     ")"}], "*", "w4smic"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QN", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1a", "+", "Q1b", "+", "Q1c", "+", "Q1d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q2a", "+", "Q2b", "+", "Q2c", "+", "Q2d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q3a", "+", "Q3b", "+", "Q3c", "+", "Q3d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q4a", "+", "Q4b", "+", "Q4c", "+", "Q4d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q5a", "+", "Q5b", "+", "Q5c", "+", "Q5d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q6a", "+", "Q6b", "+", "Q6c", "+", "Q6d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q7a", "+", "Q7b", "+", "Q7c", "+", "Q7d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q8a", "+", "Q8b", "+", "Q8c", "+", "Q8d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{"Q9a", "+", "Q9b", "+", "Q9c", "+", "Q9d"}], "}"}], ",", 
     "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}], ",", "\[IndentingNewLine]", "  ", 
     RowBox[{"{", "0", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<QN = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"N", "[", "QN", "]"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<QA - QN = \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Chop", "[", 
       RowBox[{"QA", " ", "-", " ", "QN"}], "]"}], "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Numericko", " ", "resenje"}], " ", "-", " ", 
    RowBox[{"1", " ", "tack1", " ", "integracije"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"smenaQJednaTackaIntegracije", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", "x11"}], ",", 
     RowBox[{"y1", "\[Rule]", "y11"}], ",", 
     RowBox[{"x2", "\[Rule]", "x22"}], ",", 
     RowBox[{"y2", "\[Rule]", "y22"}], ",", 
     RowBox[{"x3", "\[Rule]", "x33"}], ",", 
     RowBox[{"y3", "\[Rule]", "y33"}], ",", 
     RowBox[{"x4", "\[Rule]", "x44"}], ",", 
     RowBox[{"y4", "\[Rule]", "y44"}], ",", 
     RowBox[{"x5", "\[Rule]", "x55"}], ",", 
     RowBox[{"y5", "\[Rule]", "y55"}], ",", 
     RowBox[{"x6", "\[Rule]", "x66"}], ",", 
     RowBox[{"y6", "\[Rule]", "y66"}], ",", 
     RowBox[{"x7", "\[Rule]", "x77"}], ",", 
     RowBox[{"y7", "\[Rule]", "y77"}], ",", 
     RowBox[{"x8", "\[Rule]", "x88"}], ",", 
     RowBox[{"y8", "\[Rule]", "y88"}], ",", 
     RowBox[{"x9", "\[Rule]", "x99"}], ",", 
     RowBox[{"y9", "\[Rule]", "y99"}], ",", 
     RowBox[{"\[Xi]", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Eta]", "\[Rule]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<N1 (1 tacka integracije) = \>\"", ",", 
    RowBox[{"N1", "/.", "smenaQJednaTackaIntegracije"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qcvora1i1tackaIntegracije", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"N1", "*", "qz", "*", "detJakobi"}], ")"}], "/.", 
      "smenaQJednaTackaIntegracije"}], ")"}], "*", "2", "*", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Q cvora 1 (1 tacka integracije) = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "Qcvora1i1tackaIntegracije", "]"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Vektor", " ", "ekvivalentnog", " ", "opterecenja"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stepeniSlobode", "=", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "13", ",", "14", ",", "22", ",", "24", ",", "25", ",", "26", 
     ",", "27"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Qa", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Length", "[", "stepeniSlobode", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "m", "]"}], ";", 
  RowBox[{"m", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"m", "\[LessEqual]", 
     RowBox[{"Length", "[", "stepeniSlobode", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Qa", "[", 
       RowBox[{"[", "m", "]"}], "]"}], "=", 
      RowBox[{"QN", "[", 
       RowBox[{"[", 
        RowBox[{"stepeniSlobode", "[", 
         RowBox[{"[", "m", "]"}], "]"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"m", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Qa = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "Qa", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Kaa", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Length", "[", "stepeniSlobode", "]"}], ",", 
       RowBox[{"Length", "[", "stepeniSlobode", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"m", ",", "n"}], "]"}], ";", 
  RowBox[{"m", "=", "1"}], ";", 
  RowBox[{"n", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"m", "\[LessEqual]", 
     RowBox[{"Length", "[", "stepeniSlobode", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Clear", "[", "n", "]"}], ";", 
     RowBox[{"n", "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"n", "\[LessEqual]", 
        RowBox[{"Length", "[", "stepeniSlobode", "]"}]}], ",", 
       "\[IndentingNewLine]", "\t", 
       RowBox[{
        RowBox[{
         RowBox[{"Kaa", "[", 
          RowBox[{"[", 
           RowBox[{"m", ",", "n"}], "]"}], "]"}], "=", 
         RowBox[{"kUkupno", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"stepeniSlobode", "[", 
             RowBox[{"[", "m", "]"}], "]"}], ",", 
            RowBox[{"stepeniSlobode", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\t", 
        RowBox[{"n", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"m", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Kaa = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Chop", "[", 
      RowBox[{"Kaa", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "]"}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(4\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"da", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "Kaa", "]"}], ".", "Qa"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<da = \>\"", ",", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"da", "*", 
      SuperscriptBox["10", "3"]}], "]"}], ",", 
    "\"\< * \!\(\*SuperscriptBox[\(10\), \(-3\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<wSredine tacno po teoriji tankih plo\[CHacek]a = \>\"", ",", 
    RowBox[{"0.00126", "*", 
     FractionBox[
      RowBox[{"qz", "*", 
       SuperscriptBox["LL", "4"]}], "Kploce"], "*", 
     SuperscriptBox["10", "3"]}], ",", 
    "\"\< \!\(\*SuperscriptBox[\(10\), \(-3\)]\)\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Exit", "[", "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.671285218561768*^9, 3.6712852224778795`*^9}, {
   3.6712853507781982`*^9, 3.6712853533627048`*^9}, {3.6712855156956444`*^9, 
   3.6712856569865522`*^9}, {3.67128569827171*^9, 3.6712858122335777`*^9}, {
   3.671285854529786*^9, 3.6712859397580795`*^9}, 3.671286029911565*^9, {
   3.67128621048756*^9, 3.671286417539914*^9}, {3.671286456937516*^9, 
   3.671286511641947*^9}, {3.6712865498084764`*^9, 3.671286641308779*^9}, {
   3.671286679408077*^9, 3.671286680392885*^9}, {3.6712868347312326`*^9, 
   3.6712870316508045`*^9}, {3.6712870631202908`*^9, 3.671287172719783*^9}, {
   3.671287218035914*^9, 3.6712872453120375`*^9}, {3.6712872857306986`*^9, 
   3.671287480913745*^9}, {3.67128760822691*^9, 3.671287615294515*^9}, {
   3.671287658983341*^9, 3.671287664085622*^9}, {3.671287720015352*^9, 
   3.6712878112462034`*^9}, {3.6712878430778933`*^9, 3.671288010857177*^9}, {
   3.6712880484430227`*^9, 3.6712880832353263`*^9}, {3.6712881190409427`*^9, 
   3.6712882842351017`*^9}, {3.671288322262892*^9, 3.6712886145514774`*^9}, {
   3.6712886499296465`*^9, 3.6712886964168*^9}, {3.6712887356531954`*^9, 
   3.6712887796809597`*^9}, {3.671288846683859*^9, 3.6712888540468025`*^9}, {
   3.671289010278998*^9, 3.6712890786229305`*^9}, {3.671289116596269*^9, 
   3.671289336057767*^9}, {3.6712893733520656`*^9, 3.6712894058850164`*^9}, {
   3.671289450951722*^9, 3.671289516751732*^9}, {3.6712895713626103`*^9, 
   3.6712897779221067`*^9}, {3.6712898803641434`*^9, 
   3.6712899069621696`*^9}, {3.6712900872947817`*^9, 3.671290110523388*^9}, {
   3.671290142906954*^9, 3.671290242433835*^9}, {3.6712907191559258`*^9, 
   3.6712907227028365`*^9}, {3.6712915529308906`*^9, 
   3.6712915541158876`*^9}, {3.6712915849831967`*^9, 
   3.6712915884658127`*^9}, {3.6712918668742604`*^9, 
   3.6712918948896437`*^9}, {3.6713638866615114`*^9, 
   3.6713639267959366`*^9}, {3.6713639654021297`*^9, 3.671364108649173*^9}, {
   3.671364163210293*^9, 3.671364170181383*^9}, 3.6713642026152887`*^9, 
   3.6713642576706853`*^9, {3.6713643072988725`*^9, 3.671364539558816*^9}, {
   3.671364580433095*^9, 3.6713645989780054`*^9}, {3.6713647080053787`*^9, 
   3.6713647472653875`*^9}, {3.6713647778689423`*^9, 3.6713647784323025`*^9}, 
   3.6713648706601353`*^9, {3.6713649157743363`*^9, 3.671364916136832*^9}, {
   3.6713649473896675`*^9, 3.671364998649497*^9}, {3.6713650955230904`*^9, 
   3.6713651050399957`*^9}, {3.671365304869897*^9, 3.6713653248734503`*^9}, {
   3.671365354956499*^9, 3.6713653614089217`*^9}, {3.671365396020467*^9, 
   3.671365431412361*^9}, {3.6713654780513506`*^9, 3.671365521483403*^9}, {
   3.6713656732056217`*^9, 3.6713659212539225`*^9}, {3.671426518830373*^9, 
   3.671426525233269*^9}, {3.6717741921281157`*^9, 3.671774212176962*^9}, {
   3.6717789587768874`*^9, 3.671779013165189*^9}, {3.6717791379871535`*^9, 
   3.671779186932439*^9}, {3.6717792438884296`*^9, 3.6717793035061707`*^9}, {
   3.671779347320695*^9, 3.671779450410405*^9}, {3.6717794989769335`*^9, 
   3.671779604387034*^9}, {3.671779661628614*^9, 3.671779707251586*^9}, {
   3.671779778085601*^9, 3.6717797983356867`*^9}, {3.6717799029052763`*^9, 
   3.6717799639934483`*^9}, {3.671780311972494*^9, 3.67178040856621*^9}, {
   3.671780639584324*^9, 3.6717807654167814`*^9}, {3.671780807517355*^9, 
   3.6717810976553736`*^9}, {3.6717811317585583`*^9, 3.671781206914386*^9}, {
   3.671781307239745*^9, 3.6717815025710073`*^9}, {3.671811932819356*^9, 
   3.6718122482552824`*^9}, {3.671812290688249*^9, 3.6718123623678527`*^9}, {
   3.671812420006447*^9, 3.671812446252369*^9}, {3.6718124774740324`*^9, 
   3.6718127818101397`*^9}, {3.6718128374554253`*^9, 3.67181294308043*^9}, {
   3.6718129769926376`*^9, 3.671813025462169*^9}, {3.6718130554713297`*^9, 
   3.6718132072752457`*^9}, {3.6718132726530647`*^9, 
   3.6718133742146673`*^9}, {3.6718134566132936`*^9, 3.671813580997898*^9}, {
   3.6718136154354467`*^9, 3.671813693988187*^9}, {3.671813739948841*^9, 
   3.671813787935314*^9}, {3.671813823417328*^9, 3.6718138250337043`*^9}, {
   3.6718138586745963`*^9, 3.671813895540545*^9}, {3.671814004842018*^9, 
   3.671814015478223*^9}, {3.6718199742193604`*^9, 3.6718200065635724`*^9}, {
   3.671820129618413*^9, 3.671820269119842*^9}, {3.671820338812415*^9, 
   3.6718203547218266`*^9}, {3.6718204023935676`*^9, 3.671820483971063*^9}, {
   3.671820584744954*^9, 3.6718206394933834`*^9}, {3.6718206805555696`*^9, 
   3.671820815156568*^9}, {3.6718208744598036`*^9, 3.6718209332828016`*^9}, {
   3.6718209668721514`*^9, 3.671820989211153*^9}, {3.671821061964681*^9, 
   3.671821111418125*^9}, {3.6718211845255175`*^9, 3.671821206509573*^9}, {
   3.6718212509793873`*^9, 3.6718215076635666`*^9}, {3.6718215393771024`*^9, 
   3.671821600321368*^9}, {3.6718216533057375`*^9, 3.671821663539055*^9}, {
   3.6718217255988903`*^9, 3.6718217759507914`*^9}, {3.6718218311602097`*^9, 
   3.6718218478347163`*^9}, {3.671821894305772*^9, 3.6718219297300587`*^9}, {
   3.6718221910898223`*^9, 3.6718222901567526`*^9}, {3.6718223518925424`*^9, 
   3.6718225175328913`*^9}, 3.671822579147814*^9, {3.67182269184648*^9, 
   3.6718228493494787`*^9}, {3.6718229830961466`*^9, 
   3.6718229872818766`*^9}, {3.6718230654528136`*^9, 3.671823141868691*^9}, {
   3.67182320143335*^9, 3.671823240288227*^9}, {3.6718232919420924`*^9, 
   3.671823308103662*^9}, {3.6718234025042424`*^9, 3.671823424530915*^9}, {
   3.6718236946353188`*^9, 3.6718237445504704`*^9}, {3.6718237783912354`*^9, 
   3.67182381086469*^9}, {3.6718239024213147`*^9, 3.6718239490975456`*^9}, {
   3.6718239959855213`*^9, 3.671824016390843*^9}, {3.6718240594319086`*^9, 
   3.671824124689901*^9}, {3.671824195488669*^9, 3.6718242009410715`*^9}, {
   3.6718242333409853`*^9, 3.671824252207259*^9}, {3.6718551784605937`*^9, 
   3.6718553262731314`*^9}, {3.6718553762594056`*^9, 
   3.6718554381127787`*^9}, {3.6718554853514585`*^9, 
   3.6718555283276367`*^9}, {3.671855593829836*^9, 3.671855603579984*^9}, {
   3.671855715187302*^9, 3.6718557398636*^9}, {3.6718557699019794`*^9, 
   3.6718557714182944`*^9}, {3.671855809941201*^9, 3.671855840050542*^9}, {
   3.6718559442812276`*^9, 3.6718559572800417`*^9}, {3.671856009468233*^9, 
   3.6718560570520725`*^9}, {3.671856101122105*^9, 3.6718561195348864`*^9}, {
   3.6718561626039658`*^9, 3.671856214746307*^9}, {3.671856272127247*^9, 
   3.6718562967772355`*^9}, 3.6718563310219126`*^9, {3.671856365488142*^9, 
   3.6718564155486126`*^9}, {3.671856458084223*^9, 3.671856474950062*^9}, {
   3.6718565060179415`*^9, 3.6718565467233124`*^9}, {3.671856613116184*^9, 
   3.671856653242087*^9}, {3.6718567121782827`*^9, 3.671856741618887*^9}, {
   3.6718567808982434`*^9, 3.6718569254495945`*^9}, {3.6718570757330837`*^9, 
   3.6718570855854588`*^9}, {3.6718571496350346`*^9, 
   3.6718571772586803`*^9}, {3.6718572291595306`*^9, 
   3.6718573207738256`*^9}, {3.6718574423460197`*^9, 3.671857466454465*^9}, {
   3.67185749711569*^9, 3.671857606936226*^9}, {3.671857655201708*^9, 
   3.671857686448434*^9}, {3.671857846702374*^9, 3.671857853955722*^9}, {
   3.67185788974846*^9, 3.671857900011544*^9}, {3.6718580239176764`*^9, 
   3.6718580246959057`*^9}, {3.671860089122366*^9, 3.671860175990391*^9}, {
   3.6718602160513296`*^9, 3.6718603397783556`*^9}, {3.6718604664273148`*^9, 
   3.6718605111823053`*^9}, {3.6718605670257945`*^9, 
   3.6718606463989315`*^9}, {3.6718606832246585`*^9, 3.6718606992270565`*^9}, 
   3.6718609088190937`*^9, {3.671860998007786*^9, 3.671861005307844*^9}, {
   3.6718617100985355`*^9, 3.671861714417272*^9}, {3.6718942709914985`*^9, 
   3.671894335625294*^9}, {3.6718949699354415`*^9, 3.671894970088913*^9}, {
   3.6718987476369715`*^9, 3.6718987483997793`*^9}, 3.6718989474868484`*^9, {
   3.671902181506486*^9, 3.6719022068810854`*^9}, {3.6719028263980923`*^9, 
   3.671902854322629*^9}, 3.6719521015513687`*^9, {3.6719830084599595`*^9, 
   3.671983021329599*^9}, {3.764850539337758*^9, 3.76485054025616*^9}, {
   3.764850635119614*^9, 3.7648507116432886`*^9}, 3.7648507719598923`*^9, 
   3.764850839990103*^9, {3.7648512978726315`*^9, 3.764851298837706*^9}, 
   3.764851811456026*^9, {3.7648525225664234`*^9, 3.7648526225140066`*^9}, {
   3.764852657875308*^9, 3.7648526590160475`*^9}, {3.7648527384406643`*^9, 
   3.7648527831957755`*^9}, {3.7648528351164117`*^9, 
   3.7648532582045083`*^9}, {3.764853356762643*^9, 3.7648534199999313`*^9}, {
   3.7648534522893753`*^9, 3.764853459246668*^9}, {3.764853492254261*^9, 
   3.764853543273456*^9}, {3.764853599536957*^9, 3.764853607188237*^9}, {
   3.76485376817686*^9, 3.7648538015875854`*^9}, {3.764853835567177*^9, 
   3.764853915326338*^9}, {3.7648539702145042`*^9, 3.764853971618474*^9}, {
   3.7648540847665024`*^9, 3.7648540857002497`*^9}, {3.7648542209112463`*^9, 
   3.7648542371406193`*^9}, {3.764854274005555*^9, 3.7648542931432734`*^9}, {
   3.764854323581976*^9, 3.764854444811792*^9}, 3.764854562667125*^9, 
   3.7648546292653484`*^9, {3.7648548581264105`*^9, 3.7648548601479225`*^9}, {
   3.7657752466623774`*^9, 3.7657752473325505`*^9}, {3.7658813395916853`*^9, 
   3.765881448289203*^9}, {3.765881488813991*^9, 3.765881556276971*^9}, {
   3.765882163004282*^9, 3.7658821652098007`*^9}, {3.7658823357784305`*^9, 
   3.765882406763747*^9}, {3.765882497851982*^9, 3.765882685234913*^9}, {
   3.7659513069574285`*^9, 3.7659513076216183`*^9}, 3.7659515949117403`*^9, {
   3.7686433368596773`*^9, 3.768643345823449*^9}, {3.7888683350258455`*^9, 
   3.788868375576277*^9}, {3.78886841172418*^9, 3.788868427260683*^9}, {
   3.7888691907912993`*^9, 3.7888692010860343`*^9}, {3.788869835867634*^9, 
   3.7888698712882147`*^9}, {3.7888712404301295`*^9, 
   3.7888713105880127`*^9}, {3.7888713832481165`*^9, 
   3.7888714096363935`*^9}, {3.788871445963838*^9, 3.788871454895713*^9}, {
   3.788875011781168*^9, 3.7888750166433363`*^9}, {3.788875091226059*^9, 
   3.7888753903779535`*^9}, {3.788875424680818*^9, 3.788875458243658*^9}, {
   3.788875549741234*^9, 3.7888755925845265`*^9}, {3.7888756459069138`*^9, 
   3.788875648762*^9}, {3.7888757070779734`*^9, 3.7888757421371164`*^9}, {
   3.788875803540922*^9, 3.788875855002714*^9}, {3.7888759030099225`*^9, 
   3.7888759293119535`*^9}, {3.7888759694250717`*^9, 
   3.7888759818829727`*^9}, {3.788876033942625*^9, 3.7888760342602825`*^9}, {
   3.788876092120573*^9, 3.78887613288743*^9}, {3.788876175376999*^9, 
   3.78887625555857*^9}, 3.7888763669045854`*^9, {3.7888764125905514`*^9, 
   3.788876821599981*^9}, {3.7888768539380307`*^9, 3.788876937039981*^9}, {
   3.788876978329454*^9, 3.7888769976538086`*^9}, {3.78887703002542*^9, 
   3.7888772036665*^9}, {3.7888772573958917`*^9, 3.7888774867392893`*^9}, {
   3.788878060292031*^9, 3.7888780849149446`*^9}, {3.788878116869171*^9, 
   3.7888782320923886`*^9}, {3.788878266245311*^9, 3.7888784384288692`*^9}, {
   3.78887849478141*^9, 3.7888785117391*^9}, {3.788878600777542*^9, 
   3.7888787355454855`*^9}, {3.788878805788706*^9, 3.7888788594279146`*^9}, {
   3.788878937411618*^9, 3.788878993699915*^9}, {3.788879044385849*^9, 
   3.7888790570286493`*^9}, {3.7889277027066326`*^9, 3.78892774620237*^9}, {
   3.7889280701483192`*^9, 3.788928141080653*^9}, {3.7889281827532663`*^9, 
   3.788928193720052*^9}, {3.78892826653611*^9, 3.7889283048322763`*^9}, {
   3.7889284990179915`*^9, 3.7889284995061855`*^9}, {3.788928586159482*^9, 
   3.788928624278353*^9}, {3.78892865966041*^9, 3.78892871630365*^9}, {
   3.788929867846249*^9, 3.7889298684112325`*^9}, {3.788930262719632*^9, 
   3.7889305267227263`*^9}, {3.7889306147870703`*^9, 
   3.7889306604723024`*^9}, {3.7889307132712784`*^9, 3.788930756268108*^9}, {
   3.7889307903948064`*^9, 3.7889307939007564`*^9}, {3.7889308523866963`*^9, 
   3.7889309434564586`*^9}, {3.788931030425323*^9, 3.788931162231959*^9}, {
   3.7889312823834467`*^9, 3.7889312840554113`*^9}, {3.788931315585106*^9, 
   3.7889314880972548`*^9}, {3.7889315182746763`*^9, 3.788931626692915*^9}, {
   3.7889316638505125`*^9, 3.788931695556734*^9}, {3.788931750353458*^9, 
   3.7889317937618065`*^9}, {3.7889318657636456`*^9, 3.788932122897314*^9}, {
   3.788932208111255*^9, 3.7889322593392577`*^9}, {3.7889323170669365`*^9, 
   3.788932346935416*^9}, {3.7889324258400745`*^9, 3.788932427028426*^9}, {
   3.7889325116645536`*^9, 3.7889325652719326`*^9}, {3.788932601249574*^9, 
   3.7889326295904965`*^9}, 3.788932663515993*^9, {3.7889327225289545`*^9, 
   3.7889327371778603`*^9}, {3.7889327728234186`*^9, 
   3.7889327908741307`*^9}, {3.7889328826694326`*^9, 
   3.7889329132232895`*^9}, {3.7889330725275407`*^9, 
   3.7889330731056595`*^9}, {3.7889331032253304`*^9, 
   3.7889331051471972`*^9}, {3.7889336873689585`*^9, 3.788933860702362*^9}, {
   3.7889339034640613`*^9, 3.788934030376363*^9}, {3.7889340697034044`*^9, 
   3.7889341099545465`*^9}, {3.788934149700876*^9, 3.7889342132389355`*^9}, {
   3.788934264848363*^9, 3.7889342830738583`*^9}, {3.7889343132574725`*^9, 
   3.788934614429613*^9}, {3.788934663501567*^9, 3.788934686694477*^9}, {
   3.7889347411103125`*^9, 3.7889347925621305`*^9}, 3.7889348356393414`*^9, {
   3.788934880140425*^9, 3.7889348938515415`*^9}, {3.788934939486585*^9, 
   3.788935082930088*^9}, {3.7889351211501803`*^9, 3.7889351408905783`*^9}, 
   3.7889351741547246`*^9, {3.788935252884767*^9, 3.788935342188068*^9}, {
   3.7889354425502276`*^9, 3.788935490909715*^9}, {3.788935546590757*^9, 
   3.788935598585597*^9}, {3.788935745258687*^9, 3.7889358353096666`*^9}, {
   3.7889358756468916`*^9, 3.788935941789583*^9}, {3.788935973524351*^9, 
   3.7889360682046227`*^9}, {3.7889360994055986`*^9, 
   3.7889361965614214`*^9}, {3.788936229416624*^9, 3.788936281779401*^9}, {
   3.7889363167117624`*^9, 3.78893631727426*^9}, {3.788936350325221*^9, 
   3.7889363547881804`*^9}, 3.7889364043104343`*^9, {3.788936468283768*^9, 
   3.788936472783749*^9}, {3.788936550841318*^9, 3.7889365917246265`*^9}, {
   3.788936624923196*^9, 3.7889366623949423`*^9}, {3.788936713039298*^9, 
   3.7889367238542137`*^9}, 3.7889368492799854`*^9, {3.7889369499518933`*^9, 
   3.7889369500925183`*^9}, {3.788936983017535*^9, 3.7889370718366346`*^9}, {
   3.7889371058205967`*^9, 3.788937109070583*^9}, 3.7889372314799876`*^9, {
   3.7889373144715014`*^9, 3.7889374040086536`*^9}, {3.7889374377889977`*^9, 
   3.7889375105223885`*^9}, {3.7889375755687256`*^9, 
   3.7889376237265973`*^9}, {3.788937697449001*^9, 3.7889377313929405`*^9}, {
   3.788937814713395*^9, 3.7889378496023054`*^9}, {3.788937916908702*^9, 
   3.78893794647971*^9}, {3.7889379933369236`*^9, 3.7889380774623194`*^9}, {
   3.7889385634986362`*^9, 3.788938584419098*^9}, {3.788938642662367*^9, 
   3.7889387175439806`*^9}, {3.78893875173489*^9, 3.788938823010933*^9}, 
   3.788938853674123*^9, {3.7889388881523705`*^9, 3.7889389207902775`*^9}, {
   3.788938994410183*^9, 3.788939000930122*^9}, {3.7889390906451716`*^9, 
   3.788939103344173*^9}, {3.7889391357277517`*^9, 3.788939246151387*^9}, {
   3.7889393046677485`*^9, 3.7889393764003906`*^9}, {3.7889394113789015`*^9, 
   3.788939457843468*^9}, {3.7889395135611067`*^9, 3.7889397004651575`*^9}, {
   3.788939750862116*^9, 3.788939867939757*^9}, {3.788939905089368*^9, 
   3.7889399744039097`*^9}, {3.7889400251977015`*^9, 3.788940088711226*^9}, {
   3.7889401356048317`*^9, 3.7889401596426983`*^9}, {3.788940221678084*^9, 
   3.7889402299874115`*^9}, {3.788940266193453*^9, 3.788940266740344*^9}, {
   3.788940460823142*^9, 3.7889405816799746`*^9}, {3.7889406123770475`*^9, 
   3.7889408309900866`*^9}, {3.788940874956951*^9, 3.7889409673805532`*^9}, {
   3.7889410318378477`*^9, 3.788941047106982*^9}, {3.7889410866515417`*^9, 
   3.788941106266632*^9}, {3.7889411702337947`*^9, 3.7889412104324627`*^9}, {
   3.788941249957552*^9, 3.78894128222021*^9}, {3.788941320337202*^9, 
   3.788941416522251*^9}, {3.788941490738638*^9, 3.7889414908306336`*^9}, {
   3.7889415298528266`*^9, 3.788941678410945*^9}, {3.7889417129325294`*^9, 
   3.788941788358096*^9}, {3.7889418468701725`*^9, 3.788941855901862*^9}, {
   3.7889420651805534`*^9, 3.7889421161174326`*^9}, {3.7889421474732027`*^9, 
   3.7889422577717943`*^9}, {3.788942303617524*^9, 3.7889424714791937`*^9}, {
   3.788942519320487*^9, 3.788942594647809*^9}, {3.7889426356570315`*^9, 
   3.7889426692096815`*^9}, {3.788942703217082*^9, 3.78894270651571*^9}, {
   3.788942754963399*^9, 3.788942788869017*^9}, {3.7889428225684185`*^9, 
   3.7889430646928864`*^9}, {3.788943292588423*^9, 3.7889433432983217`*^9}, {
   3.7889448499168944`*^9, 3.7889448985276546`*^9}, {3.788944936174612*^9, 
   3.788944945156077*^9}, {3.7889449772776623`*^9, 3.7889450176829185`*^9}, {
   3.7889450663171453`*^9, 3.7889452744140944`*^9}, {3.7889453132757463`*^9, 
   3.7889455905750628`*^9}, {3.7889456691017303`*^9, 3.788945744113161*^9}, {
   3.7889458012545357`*^9, 3.788945850892818*^9}, {3.7889459012495317`*^9, 
   3.7889460897136855`*^9}, {3.7889461526720867`*^9, 3.788946265544243*^9}, {
   3.788946305278676*^9, 3.788946330675517*^9}, {3.7889463633885746`*^9, 
   3.7889464337150946`*^9}, {3.788946500555638*^9, 3.788946551090985*^9}, {
   3.788946607516986*^9, 3.7889467505657225`*^9}, 3.7889467892684407`*^9, {
   3.7889468444326906`*^9, 3.7889468456202016`*^9}, 3.788946879327982*^9, {
   3.788946967481017*^9, 3.7889471081995664`*^9}, {3.788947211933799*^9, 
   3.788947344984446*^9}, {3.7889473811507883`*^9, 3.7889474765330505`*^9}, {
   3.788947545103493*^9, 3.788947548684409*^9}, {3.789023061008133*^9, 
   3.7890232181868067`*^9}, {3.789023349713216*^9, 3.7890234902202873`*^9}, {
   3.7890235513195314`*^9, 3.7890235609296155`*^9}, {3.7890236002351155`*^9, 
   3.7890236611514444`*^9}, {3.7890238415336933`*^9, 3.789023864943338*^9}, {
   3.789023910818262*^9, 3.7890239198446064`*^9}, 3.7890241520480905`*^9, {
   3.7890241937357283`*^9, 3.789024335991862*^9}, {3.7890243854397326`*^9, 
   3.789024437110846*^9}, {3.7890245319719687`*^9, 3.7890245528745394`*^9}, {
   3.789024651954897*^9, 3.7890246989480934`*^9}, {3.7890247681577177`*^9, 
   3.789024780584651*^9}, {3.789024819295697*^9, 3.789024841085168*^9}, {
   3.789024876726943*^9, 3.789025071435512*^9}, {3.789025109168145*^9, 
   3.78902521049349*^9}, {3.789025326046049*^9, 3.7890253613823905`*^9}, {
   3.7890253995219755`*^9, 3.789025473728295*^9}, {3.789025509692209*^9, 
   3.789025560624873*^9}, {3.7890256437284265`*^9, 3.7890256442987905`*^9}, {
   3.789025699377643*^9, 3.7890257192177715`*^9}, 3.7890257537080913`*^9, {
   3.789025829125077*^9, 3.7890258334942102`*^9}, {3.7890260353542414`*^9, 
   3.7890260913879347`*^9}, {3.789026122237811*^9, 3.789026184378585*^9}, {
   3.789026236255331*^9, 3.789026296185978*^9}, {3.789026348791497*^9, 
   3.789026350982068*^9}, {3.789026388246945*^9, 3.7890263937229595`*^9}, {
   3.789026503954151*^9, 3.7890265773010025`*^9}, {3.789026610673023*^9, 
   3.7890266517928057`*^9}, {3.789026682706566*^9, 3.7890266929331837`*^9}, {
   3.7890267361999865`*^9, 3.7890267750484004`*^9}, {3.789026809354734*^9, 
   3.7890268472747054`*^9}, 3.7890269392315044`*^9, {3.7890269738174143`*^9, 
   3.7890270380120773`*^9}, {3.7890273573663845`*^9, 3.789027370153887*^9}, {
   3.789027408118063*^9, 3.7890274160788717`*^9}, {3.789027525128593*^9, 
   3.78902764598519*^9}, {3.789027677587797*^9, 3.78902772035088*^9}, {
   3.789027752076336*^9, 3.789027784393772*^9}, {3.7890278421195297`*^9, 
   3.789027848467891*^9}, {3.789027879366764*^9, 3.7890279162985106`*^9}, {
   3.7890279961287107`*^9, 3.7890280169665985`*^9}, {3.789028107735612*^9, 
   3.7890281128645277`*^9}, {3.789028147381074*^9, 3.7890282385724897`*^9}, {
   3.7890282725633082`*^9, 3.789028344810417*^9}, {3.7890283755451946`*^9, 
   3.789028450977661*^9}, {3.7890285031852913`*^9, 3.789028544713812*^9}, {
   3.7890324643380632`*^9, 3.7890325758188767`*^9}, {3.789032641633298*^9, 
   3.7890327427016582`*^9}, {3.7890328770077715`*^9, 3.78903307560835*^9}, {
   3.7890359318106427`*^9, 3.789035932008642*^9}, {3.7890379486146765`*^9, 
   3.789037949617454*^9}, {3.7890389089036064`*^9, 3.7890389245012107`*^9}, {
   3.7890390222777205`*^9, 3.789039032151469*^9}, {3.789039188247497*^9, 
   3.7890392652095337`*^9}, 3.7890394915092936`*^9, {3.7890400346546144`*^9, 
   3.78904005785102*^9}, {3.789042512727436*^9, 3.789042514015156*^9}, {
   3.789482782714414*^9, 3.7894827829331636`*^9}, {3.790843725813648*^9, 
   3.7908437749356413`*^9}, {3.790843945040861*^9, 3.7908441005349083`*^9}, {
   3.79084469742492*^9, 3.790844761357546*^9}, {3.7908449665374513`*^9, 
   3.7908449991981263`*^9}, {3.7908450309699793`*^9, 3.7908450502061787`*^9}, 
   3.7908451050400906`*^9, {3.7908451810277057`*^9, 3.7908451912383113`*^9}, {
   3.7908459034609966`*^9, 3.7908459507545223`*^9}, {3.7908461176431317`*^9, 
   3.7908461179595385`*^9}, {3.7908466019254465`*^9, 
   3.7908467198173857`*^9}, {3.7908468888399305`*^9, 3.790846934048202*^9}, {
   3.7908469712347713`*^9, 3.7908469716893024`*^9}, {3.7909079051042857`*^9, 
   3.7909079427643685`*^9}, {3.7909079922911572`*^9, 
   3.7909080021969166`*^9}, {3.790909985821327*^9, 3.790909988130271*^9}, {
   3.79091015267225*^9, 3.790910157717128*^9}, {3.790910376527751*^9, 
   3.790910397554235*^9}, {3.7909104284624796`*^9, 3.79091042966345*^9}, {
   3.7909105061275826`*^9, 3.790910544646642*^9}, 3.790910636663686*^9, {
   3.7909116893537993`*^9, 3.790911796894176*^9}, {3.7909118802965746`*^9, 
   3.7909119918098526`*^9}, {3.7909120472064967`*^9, 
   3.7909120518163867`*^9}, {3.790912083556612*^9, 3.7909122484765854`*^9}, {
   3.79091234368426*^9, 3.790912353491021*^9}, {3.79091250411734*^9, 
   3.7909125842433834`*^9}, {3.7909127387521677`*^9, 
   3.7909127967417574`*^9}, {3.790912993990937*^9, 3.790913023057994*^9}, {
   3.790913412647771*^9, 3.7909134167226667`*^9}, {3.7909134797871275`*^9, 
   3.790913489289897*^9}, {3.790917982265809*^9, 3.7909180243917828`*^9}, {
   3.790918108393732*^9, 3.790918180655965*^9}, {3.7909182264284935`*^9, 
   3.7909182440050645`*^9}, 3.790918318495246*^9, {3.7909183997362394`*^9, 
   3.790918458373805*^9}, {3.7909185646572123`*^9, 3.7909186324525566`*^9}, {
   3.790918679539407*^9, 3.7909188176440372`*^9}, {3.7909188550291224`*^9, 
   3.7909189021979685`*^9}, {3.790918942972975*^9, 3.7909189557166643`*^9}, {
   3.790919174693166*^9, 3.7909192475123887`*^9}, {3.7909193247367444`*^9, 
   3.7909193449602547`*^9}, {3.790919424704063*^9, 3.7909196150214195`*^9}, {
   3.7909196532074847`*^9, 3.7909196939474926`*^9}, {3.7909197945770335`*^9, 
   3.7909198069617333`*^9}, {3.7910160031863527`*^9, 3.791016018185157*^9}, {
   3.791016062809433*^9, 3.7910161733526535`*^9}, {3.7910162489452024`*^9, 
   3.7910162987569733`*^9}, 3.7910164041088047`*^9, 3.7910164598809657`*^9, {
   3.791016530198585*^9, 3.791016559444867*^9}, 3.791016615540489*^9, 
   3.7910166538957453`*^9, {3.7910167292092323`*^9, 3.791016809833393*^9}, {
   3.791016842714589*^9, 3.791016852083356*^9}, {3.791016925933322*^9, 
   3.791016955775276*^9}, {3.7910170628158436`*^9, 3.791017083568331*^9}, {
   3.7910172299547367`*^9, 3.7910172379405346`*^9}, {3.791017374516403*^9, 
   3.7910173867051*^9}, {3.7910185663183537`*^9, 3.7910185712192326`*^9}, {
   3.791018693041989*^9, 3.791018695316489*^9}, {3.7910187332527747`*^9, 
   3.791018842077097*^9}, {3.7910188791347103`*^9, 3.7910189053010674`*^9}, {
   3.791018955733124*^9, 3.7910189656588764`*^9}, {3.7910191941184196`*^9, 
   3.7910192183738227`*^9}, 3.791019260597212*^9, {3.791019295282355*^9, 
   3.791019295844343*^9}, {3.791089516569024*^9, 3.7910895229836683`*^9}, {
   3.7910896983826494`*^9, 3.7910897798056135`*^9}, 3.7910903537254095`*^9, {
   3.791090447668702*^9, 3.7910905437563124`*^9}, {3.791090585582284*^9, 
   3.7910905949060497`*^9}, {3.791090630341486*^9, 3.791090711377494*^9}, {
   3.7910908160329647`*^9, 3.791090816777946*^9}, {3.7910908939438047`*^9, 
   3.791090903904558*^9}, {3.791098107725418*^9, 3.7910982165441127`*^9}, {
   3.7910983423446846`*^9, 3.791098342719671*^9}, {3.7910995084959235`*^9, 
   3.7910995787372026`*^9}, {3.7911001164609833`*^9, 
   3.7911003039604096`*^9}, {3.7911003371110992`*^9, 3.791100355140659*^9}, {
   3.7911003874068613`*^9, 3.7911004045214443`*^9}, {3.7911004584201727`*^9, 
   3.7911004994401646`*^9}, {3.7911006691861944`*^9, 
   3.7911006732560973`*^9}, {3.7911007387078953`*^9, 3.7911007605713577`*^9}, 
   3.7911008258159018`*^9, {3.791130562502917*^9, 3.7911305654264016`*^9}, {
   3.791206779717471*^9, 3.7912067882934227`*^9}, {3.791206886689635*^9, 
   3.7912069198875313`*^9}, {3.7912069635058904`*^9, 3.791207137956523*^9}, {
   3.7912071740064135`*^9, 3.7912072356832037`*^9}, {3.791207305674878*^9, 
   3.7912073266311374`*^9}, {3.7912095339422607`*^9, 3.791209669160851*^9}, {
   3.7912097079191923`*^9, 3.791209764978924*^9}, {3.7912098169137893`*^9, 
   3.791209821155846*^9}, {3.79120988676807*^9, 3.791209887215577*^9}, {
   3.791210055646822*^9, 3.7912100766490993`*^9}, {3.7912101250334845`*^9, 
   3.7912101602162066`*^9}, {3.791210205081773*^9, 3.7912102491041346`*^9}, {
   3.791210281488631*^9, 3.7912103087433558`*^9}, {3.791210387556986*^9, 
   3.791210427098445*^9}, {3.7912104851834445`*^9, 3.7912105339448347`*^9}, {
   3.7912105692360926`*^9, 3.791210888207255*^9}, {3.791211001858008*^9, 
   3.7912110073777456`*^9}, 3.7912110779936914`*^9, {3.791341730267441*^9, 
   3.7913417419214973`*^9}, {3.7913417853146534`*^9, 3.791341798033826*^9}, {
   3.7913595355926447`*^9, 3.7913596023199396`*^9}, {3.791359651552575*^9, 
   3.7913597062433863`*^9}, {3.7913597434718823`*^9, 
   3.7913597740218496`*^9}, {3.7913598126023602`*^9, 3.791359862306981*^9}, {
   3.7913599027928705`*^9, 3.791359926202795*^9}, {3.7913599696895533`*^9, 
   3.791359969921548*^9}, {3.791528747219673*^9, 3.791528827929741*^9}, {
   3.7915288968390913`*^9, 3.7915289702003355`*^9}, {3.791531227788316*^9, 
   3.7915312723522496`*^9}, {3.791532430345541*^9, 3.7915324363043985`*^9}, 
   3.7917154946725683`*^9, {3.7917175987352476`*^9, 3.791717633265417*^9}, {
   3.7917176903000317`*^9, 3.7917179844329023`*^9}, {3.7917191493886623`*^9, 
   3.7917191998544416`*^9}, {3.791719317619587*^9, 3.7917193211025004`*^9}, {
   3.791719928883767*^9, 3.7917199393315153`*^9}, {3.7919921921122885`*^9, 
   3.791992229097124*^9}, {3.7919922611770067`*^9, 3.791992362232455*^9}, {
   3.791992435115878*^9, 3.7919924726572123`*^9}, {3.791992528339139*^9, 
   3.7919925772773113`*^9}, {3.791992607532773*^9, 3.7919926447634306`*^9}, {
   3.791992780587294*^9, 3.79199278333025*^9}, {3.791992817983365*^9, 
   3.791992820820018*^9}, {3.791992922305483*^9, 3.791992953133733*^9}, {
   3.791994009721076*^9, 3.79199410409595*^9}, {3.7919941363315954`*^9, 
   3.7919941627997417`*^9}, {3.7919942015815783`*^9, 3.791994455260667*^9}, {
   3.7919944855065684`*^9, 3.791994546856903*^9}, {3.7919946309580555`*^9, 
   3.79199474786643*^9}, {3.7920389254875913`*^9, 3.792039113892807*^9}, {
   3.79203916337255*^9, 3.7920393202505665`*^9}, {3.7920393786520815`*^9, 
   3.792039380118044*^9}, {3.7920394424354606`*^9, 3.7920394439304223`*^9}, {
   3.792039726241169*^9, 3.79203982138475*^9}, {3.792040046856691*^9, 
   3.792040134683462*^9}, {3.792040254077426*^9, 3.792040254485421*^9}, {
   3.7920403483660336`*^9, 3.792040398843749*^9}, {3.792040501513089*^9, 
   3.792040505391992*^9}, {3.792040595544704*^9, 3.7920406003075857`*^9}, {
   3.792040684915433*^9, 3.792040688527341*^9}, {3.792040743562943*^9, 
   3.792040784374906*^9}, {3.792040901209937*^9, 3.792040925334028*^9}, {
   3.7920410140407734`*^9, 3.792041086887925*^9}, {3.792041289902769*^9, 
   3.792041337551556*^9}, {3.7920415013043966`*^9, 3.7920415548520365`*^9}, {
   3.792044562153653*^9, 3.792044575676306*^9}, 3.7920446552282877`*^9, {
   3.792051770806929*^9, 3.7920518306450343`*^9}, {3.7920519059258633`*^9, 
   3.7920519060278563`*^9}, {3.792051942438936*^9, 3.792052010747198*^9}, {
   3.7920520651548185`*^9, 3.792052065432809*^9}, {3.7920525026306853`*^9, 
   3.7920525050786266`*^9}, {3.792055255809986*^9, 3.7920552984689035`*^9}, {
   3.7920554397570353`*^9, 3.792055479555025*^9}, {3.7920557794534273`*^9, 
   3.7920558144525375`*^9}, {3.79205585687946*^9, 3.7920559060342116`*^9}, {
   3.7920560429307375`*^9, 3.792056109535041*^9}, {3.7920562621481895`*^9, 
   3.7920562656591005`*^9}, {3.7920564039456854`*^9, 
   3.7920564056376414`*^9}, {3.792118984679653*^9, 3.792119700388457*^9}, {
   3.7921197304460335`*^9, 3.7921197307897825`*^9}, {3.7921198402518864`*^9, 
   3.792120081728806*^9}, {3.792120114836179*^9, 3.792120186233304*^9}, {
   3.7921202553796024`*^9, 3.7921202970602226`*^9}, {3.7921203559988394`*^9, 
   3.79212042214878*^9}, {3.792120658655156*^9, 3.7921206707893667`*^9}, {
   3.7921207272140646`*^9, 3.7921207310265503`*^9}, {3.792120788922217*^9, 
   3.792120829722706*^9}, {3.792120872221571*^9, 3.7921211053517847`*^9}, 
   3.7921215799024444`*^9, {3.7923266274066224`*^9, 3.7923272329749365`*^9}, {
   3.7923309596675897`*^9, 3.7923310965709906`*^9}, {3.792331141028582*^9, 
   3.7923311795014935`*^9}, {3.7923312166681995`*^9, 3.792331243202761*^9}, {
   3.792331320135166*^9, 3.792331406934375*^9}, {3.792331461517105*^9, 
   3.792331506682172*^9}, {3.7923315573977423`*^9, 3.7923317291698737`*^9}, {
   3.792331827565338*^9, 3.7923319951021404`*^9}, {3.7923320381848016`*^9, 
   3.7923320883003454`*^9}, {3.7923321396999564`*^9, 3.79233219860413*^9}, {
   3.792332333917158*^9, 3.792332398230942*^9}, {3.792332434284911*^9, 
   3.7923326364744573`*^9}, {3.7923339049838934`*^9, 
   3.7923339219704447`*^9}, {3.792333963113363*^9, 3.792334065357673*^9}, {
   3.7923397925372334`*^9, 3.7923399249628553`*^9}, {3.8058147622453113`*^9, 
   3.805814763480281*^9}, 3.8058148065312047`*^9, {3.8058149672691946`*^9, 
   3.80581497021912*^9}, {3.805815104798761*^9, 3.8058154717985945`*^9}, {
   3.805815513600553*^9, 3.8058155154355073`*^9}, {3.8058155561654897`*^9, 
   3.805815988396697*^9}, {3.805816067845713*^9, 3.805816275099536*^9}, {
   3.8058166017663784`*^9, 3.80581661817397*^9}, {3.8058166953480434`*^9, 
   3.805816725561288*^9}, {3.8058169326121182`*^9, 3.8058169789309635`*^9}, {
   3.8058170122481318`*^9, 3.805817158644476*^9}, {3.805817190761671*^9, 
   3.805817195827548*^9}, {3.8058173008599253`*^9, 3.805817308645729*^9}, {
   3.805817397896501*^9, 3.8058173999494505`*^9}, {3.805817605999308*^9, 
   3.8058176118311625`*^9}, {3.8058176923231506`*^9, 3.805817725033332*^9}, {
   3.80581776565532*^9, 3.8058179267162957`*^9}, 3.8058179840377812`*^9, {
   3.80581802367079*^9, 3.80581803256557*^9}, {3.8058180835172973`*^9, 
   3.80581821588799*^9}, {3.80581826513476*^9, 3.8058182867162204`*^9}, {
   3.805818319017414*^9, 3.805818384702774*^9}, {3.8058184154620085`*^9, 
   3.80581842530276*^9}, {3.8058184571429644`*^9, 3.8058184776974545`*^9}, {
   3.8058185394409137`*^9, 3.8058185428588247`*^9}, {3.805818576175996*^9, 
   3.8058185790039253`*^9}, {3.8058186447832794`*^9, 
   3.8058186608888783`*^9}, {3.8058188838513107`*^9, 3.805818924666294*^9}, {
   3.8058189659982595`*^9, 3.8058190369324884`*^9}, {3.8058190812673826`*^9, 
   3.805819192741598*^9}, {3.805819253663077*^9, 3.805819293163093*^9}, {
   3.805819368922201*^9, 3.805819386939751*^9}, {3.805819496972001*^9, 
   3.805819497170004*^9}, {3.8058195357840347`*^9, 3.8058196039313297`*^9}, {
   3.8058196763825235`*^9, 3.805819980383933*^9}, {3.8058201166115313`*^9, 
   3.8058201206684275`*^9}, {3.8058201693142133`*^9, 3.805820180235943*^9}, {
   3.8058203419549017`*^9, 3.805820406283295*^9}, {3.805820450766187*^9, 
   3.805820471561666*^9}, {3.805820514729588*^9, 3.8058205369700356`*^9}, {
   3.8058206015734205`*^9, 3.8058206534651265`*^9}, {3.8058206844823503`*^9, 
   3.8058206969420404`*^9}, {3.8058207325851507`*^9, 3.805821058593007*^9}, 
   3.805821136182073*^9, {3.805821196068575*^9, 3.805821397255554*^9}, {
   3.8058215101187334`*^9, 3.8058215462668304`*^9}, {3.805821600439478*^9, 
   3.8058217967065773`*^9}, {3.805821852512184*^9, 3.805821857829051*^9}, {
   3.805821892894178*^9, 3.8058219192125206`*^9}, {3.8058219682572937`*^9, 
   3.805822332562197*^9}, {3.80582236525438*^9, 3.8058223881048098`*^9}, {
   3.8058224516182246`*^9, 3.805822460009017*^9}, {3.805822523493431*^9, 
   3.8058225526327047`*^9}, {3.8058231944256763`*^9, 3.805823209849292*^9}, {
   3.8058233560776405`*^9, 3.8058235153326664`*^9}, 3.805823623450965*^9, {
   3.8058236647409353`*^9, 3.805823698921081*^9}, {3.805823752397744*^9, 
   3.805823765225423*^9}, {3.805823803423473*^9, 3.8058238098143134`*^9}, {
   3.8058240324427524`*^9, 3.8058240607000484`*^9}, {3.8058623926719446`*^9, 
   3.80586250400599*^9}, {3.805862563425411*^9, 3.8058625695972443`*^9}, {
   3.805862619722911*^9, 3.8058626414383383`*^9}, {3.805862677684374*^9, 
   3.8058627644060683`*^9}, {3.8058630902094107`*^9, 
   3.8058631181376686`*^9}, {3.8058805517611437`*^9, 
   3.8058805571575947`*^9}, {3.80588059007928*^9, 3.805880698856336*^9}, {
   3.8058807387018013`*^9, 3.8058807923273344`*^9}, {3.8058808280252895`*^9, 
   3.805881309924591*^9}, {3.8058813623942475`*^9, 3.8058815547452326`*^9}, {
   3.805881624160426*^9, 3.8058816448680573`*^9}, {3.805881701134658*^9, 
   3.8058817508754764`*^9}, {3.805882397851256*^9, 3.805882407546729*^9}, 
   3.8058825038032045`*^9, {3.8058825471242247`*^9, 3.8058825540451202`*^9}, {
   3.8058826174464407`*^9, 3.805882627562143*^9}, {3.80588269309742*^9, 
   3.8058827019948835`*^9}, {3.8058828142817717`*^9, 3.805882819060461*^9}, {
   3.80588285258646*^9, 3.805882857234821*^9}, {3.8058831164774733`*^9, 
   3.8058832974731073`*^9}, {3.8058836079867425`*^9, 
   3.8058836447545347`*^9}, {3.8058836828201933`*^9, 3.805883778528556*^9}, {
   3.805883890694135*^9, 3.8058842430330734`*^9}, {3.805884394681576*^9, 
   3.805884425337839*^9}, {3.80595127191698*^9, 3.8059512872738123`*^9}, {
   3.805951346944213*^9, 3.8059514344272633`*^9}, {3.8059515017631598`*^9, 
   3.805951515316904*^9}, {3.8059516032733994`*^9, 3.8059516492636127`*^9}, {
   3.805951716116273*^9, 3.805951851569971*^9}, {3.8059521819106865`*^9, 
   3.8059523484752927`*^9}, {3.8059528847040586`*^9, 3.805953005165588*^9}, {
   3.805953038026204*^9, 3.8059530495951176`*^9}, {3.805955166708851*^9, 
   3.805955292808464*^9}, {3.8059553545728054`*^9, 3.80595541628915*^9}, {
   3.805955480909416*^9, 3.805955482741371*^9}, {3.805955775361514*^9, 
   3.8059557790824146`*^9}, {3.8059564265790377`*^9, 3.805956532842188*^9}, {
   3.805956578539959*^9, 3.805956684320121*^9}, {3.805956757697154*^9, 
   3.805956888449643*^9}, {3.805956928781561*^9, 3.8059569645546007`*^9}, 
   3.805957363050906*^9, {3.8059574156904936`*^9, 3.8059574972183056`*^9}, 
   3.8059575797800903`*^9, {3.80595765514907*^9, 3.8059576781684494`*^9}, {
   3.8059577360368967`*^9, 3.805957738969818*^9}, {3.805957950443143*^9, 
   3.805957952619083*^9}, 3.805958018041329*^9, {3.8059602904919066`*^9, 
   3.8059603629499607`*^9}, {3.805961538962305*^9, 3.805961544118164*^9}, {
   3.805962009840666*^9, 3.8059620290121512`*^9}, {3.8059620873605857`*^9, 
   3.8059621796141086`*^9}, {3.805962263646857*^9, 3.805962319219363*^9}, {
   3.805962914308392*^9, 3.805962917258319*^9}, {3.8059629501824293`*^9, 
   3.805963113376051*^9}, {3.8059631514510293`*^9, 3.8059631551369295`*^9}, {
   3.8059631916489496`*^9, 3.8059631962248263`*^9}, {3.8059632459354935`*^9, 
   3.805963274482727*^9}, {3.8059633156776204`*^9, 3.805963317294577*^9}, {
   3.8059634071221704`*^9, 3.805963550562318*^9}, {3.8059636454187727`*^9, 
   3.8059636590484056`*^9}, {3.8059637192887907`*^9, 
   3.8059637349393687`*^9}, {3.805966747649519*^9, 3.805966748785488*^9}, {
   3.805966853656674*^9, 3.8059669629587417`*^9}, {3.805967049831413*^9, 
   3.8059670519953547`*^9}, {3.805967108981823*^9, 3.8059671675152545`*^9}, {
   3.805967204763255*^9, 3.8059672265276685`*^9}, {3.8059672816401896`*^9, 
   3.8059673009866724`*^9}, {3.805967406646834*^9, 3.8059674463647685`*^9}, {
   3.805967816490836*^9, 3.8059678169048295`*^9}, {3.8059719168497963`*^9, 
   3.8059720315157194`*^9}, {3.8059720784684625`*^9, 3.80597209605399*^9}, {
   3.8059721640441637`*^9, 3.8059721848146048`*^9}, {3.805972718130294*^9, 
   3.8059727455445566`*^9}, {3.805972792561295*^9, 3.805972883005869*^9}, {
   3.8059729144120255`*^9, 3.8059729336855087`*^9}, {3.8059729852901263`*^9, 
   3.8059730830285006`*^9}, {3.805973144541849*^9, 3.8059731625383673`*^9}, {
   3.8059732162029257`*^9, 3.805973268934512*^9}, {3.8059733077934694`*^9, 
   3.805973319121168*^9}, {3.805973372193745*^9, 3.8059733942071505`*^9}, 
   3.8059734675881805`*^9, {3.805973513348952*^9, 3.8059736822334194`*^9}, {
   3.806038586076798*^9, 3.806038660234991*^9}, {3.8060387368051243`*^9, 
   3.806038745761904*^9}, {3.806039088507536*^9, 3.8060391659556475`*^9}, {
   3.8060392171013994`*^9, 3.806039217723384*^9}, {3.806039854272727*^9, 
   3.8060398765721846`*^9}, {3.8060405679408474`*^9, 
   3.8060406129457483`*^9}, {3.806040645172964*^9, 3.8060406489948664`*^9}, {
   3.8060407036055355`*^9, 3.806040769343931*^9}, {3.8060408039760857`*^9, 
   3.806040815786798*^9}, {3.8060408749433537`*^9, 3.806040898236785*^9}, {
   3.806040970350023*^9, 3.806040989559553*^9}, {3.8060410212147818`*^9, 
   3.8060410436162343`*^9}, {3.806041169398167*^9, 3.8060411875847206`*^9}, {
   3.806041259998954*^9, 3.8060412606999354`*^9}, {3.806041366007368*^9, 
   3.8060413822249722`*^9}, {3.806041422940981*^9, 3.80604146426397*^9}, 
   3.806041515580717*^9, {3.8060417171787944`*^9, 3.8060418108935056`*^9}, {
   3.806041971225596*^9, 3.8060419754164915`*^9}, {3.8060420583214703`*^9, 
   3.806042153978138*^9}, {3.8060421922822027`*^9, 3.8060422317382374`*^9}, {
   3.806042290691798*^9, 3.8060423074143877`*^9}, {3.8060424019330835`*^9, 
   3.8060424025360665`*^9}, 3.806042454020812*^9, {3.8060425109854193`*^9, 
   3.80604251391535*^9}, {3.8060425605292125`*^9, 3.8060426557338867`*^9}, {
   3.806042732005025*^9, 3.806042761333313*^9}, {3.8060428323335752`*^9, 
   3.8060429390714912`*^9}, {3.806047740278304*^9, 3.8060477438632174`*^9}, {
   3.8060481459264336`*^9, 3.806048146373418*^9}, {3.806048302623605*^9, 
   3.8060483766527977`*^9}, {3.806048438853284*^9, 3.8060484926829658`*^9}, {
   3.8060485796818438`*^9, 3.8060486444362607`*^9}, {3.806048705611771*^9, 
   3.806048736090027*^9}, {3.806048771312164*^9, 3.8060487869827847`*^9}, {
   3.8060488209339542`*^9, 3.806048838237534*^9}, {3.806049002503525*^9, 
   3.8060491941008477`*^9}, {3.80604923129694*^9, 3.806049236530814*^9}, {
   3.8060492747388787`*^9, 3.806049307095087*^9}, {3.806049449219619*^9, 
   3.8060494793388863`*^9}, {3.806049529526663*^9, 3.806049566322763*^9}, {
   3.8060496539126253`*^9, 3.8060496804589744`*^9}, {3.806049739676529*^9, 
   3.806049803830963*^9}, {3.8060498975576754`*^9, 3.8060499736698184`*^9}, {
   3.806050087209049*^9, 3.8060501338189077`*^9}, {3.8060501858756433`*^9, 
   3.806050235046438*^9}, {3.8060502762164335`*^9, 3.806050301919809*^9}, {
   3.8060503494926443`*^9, 3.806050361783345*^9}, {3.806050406901246*^9, 
   3.806050516803564*^9}, {3.8060505471878223`*^9, 3.8060505759041214`*^9}, {
   3.8060506403825493`*^9, 3.8060507843350334`*^9}, 3.806050955855845*^9, {
   3.8060510736459703`*^9, 3.8060512375409718`*^9}, {3.8060512719901285`*^9, 
   3.806051435454141*^9}, {3.8060514730732236`*^9, 3.8060515442354836`*^9}, {
   3.8060515976991816`*^9, 3.8060516033630404`*^9}, {3.806051829462522*^9, 
   3.8060518688325596`*^9}, {3.806052072866064*^9, 3.806052094075547*^9}, {
   3.8060521453643*^9, 3.806052159658945*^9}, {3.8060521903781986`*^9, 
   3.806052190663189*^9}, {3.806052262239477*^9, 3.80605230351147*^9}, {
   3.806052472794342*^9, 3.806052528291986*^9}, {3.8060525672380323`*^9, 
   3.806052642179204*^9}, {3.8060526746574154`*^9, 3.8060526849571624`*^9}, {
   3.8060528272836857`*^9, 3.80605283047561*^9}, {3.8060528666077304`*^9, 
   3.8060528952060275`*^9}, {3.8060529907557*^9, 3.8060529965715537`*^9}, {
   3.806053077452897*^9, 3.8060530827597666`*^9}, {3.8060531198718634`*^9, 
   3.806053119990861*^9}, {3.8060531863812428`*^9, 3.8060532663922896`*^9}, {
   3.806053298869492*^9, 3.806053310994199*^9}, {3.806053355922104*^9, 
   3.8060533708357344`*^9}, {3.806053458550598*^9, 3.8060534891528473`*^9}, {
   3.80605353783066*^9, 3.8060535481564064`*^9}, {3.806053585395503*^9, 
   3.8060536118908544`*^9}, {3.806053678268236*^9, 3.806053702792634*^9}, {
   3.806054155426788*^9, 3.806054224667097*^9}, {3.806054255156354*^9, 
   3.806054328176569*^9}, {3.8060544054856815`*^9, 3.80605441417447*^9}, {
   3.80605477840589*^9, 3.8060550621359673`*^9}, {3.8060550938631907`*^9, 
   3.806055159589589*^9}, 3.8060555104000263`*^9, {3.806059791560831*^9, 
   3.8060598132572994`*^9}, {3.8060598464224963`*^9, 3.806059891938382*^9}, {
   3.806059933351369*^9, 3.8060599349463315`*^9}, {3.8060619721541705`*^9, 
   3.8060619835408907`*^9}, {3.8060621464729166`*^9, 
   3.8060622403086224`*^9}, {3.8060624701270113`*^9, 
   3.8060625156399007`*^9}, {3.8060628946196504`*^9, 
   3.8060629213859997`*^9}, {3.8060629697868156`*^9, 
   3.8060630072969007`*^9}, {3.80606328268218*^9, 3.8060632897830057`*^9}, {
   3.806063346679618*^9, 3.8060633580853386`*^9}, {3.806064094732359*^9, 
   3.8060641565338526`*^9}, {3.8060642457796745`*^9, 
   3.8060642463306627`*^9}, {3.8060658085265284`*^9, 3.806065849723528*^9}, {
   3.8060660393238964`*^9, 3.8060660444607697`*^9}, {3.8060807680554075`*^9, 
   3.806080908945044*^9}, {3.8060809548979473`*^9, 3.8060809759814434`*^9}, {
   3.8060810509736567`*^9, 3.806081122508946*^9}, {3.806082975993018*^9, 
   3.8060830577300673`*^9}, {3.806083149744869*^9, 3.8060831901529045`*^9}, {
   3.8060833400473266`*^9, 3.806083344991209*^9}, {3.806083386935206*^9, 
   3.8060834313341465`*^9}, {3.806083487416808*^9, 3.8060834929076757`*^9}, {
   3.806084981763116*^9, 3.8060849837480683`*^9}, {3.806152704353943*^9, 
   3.8061527756044445`*^9}, {3.8062583244169064`*^9, 3.80625909416249*^9}, 
   3.806259162378767*^9, {3.806259194143967*^9, 3.8062592199073167`*^9}, {
   3.806259429142038*^9, 3.806259455771367*^9}, {3.806259533227412*^9, 
   3.806259535274361*^9}, {3.806260060402114*^9, 3.8062600639280252`*^9}, {
   3.806260259507095*^9, 3.806260259806085*^9}, {3.8062606399104953`*^9, 
   3.806260718937503*^9}, {3.8062607496697273`*^9, 3.806260775848069*^9}, {
   3.806260861547904*^9, 3.8062608660707912`*^9}, {3.806260943236845*^9, 
   3.806261052498087*^9}, {3.806261091085114*^9, 3.8062611904346085`*^9}, {
   3.8062612358124638`*^9, 3.806261306570679*^9}, {3.8062614696395645`*^9, 
   3.8062614699245586`*^9}, {3.8062615005937853`*^9, 3.806261573100958*^9}, 
   3.806261612429964*^9, 3.806261922133582*^9, {3.806263036574766*^9, 
   3.8062630500334272`*^9}, {3.806263202386584*^9, 3.806263220044138*^9}, {
   3.806292741519912*^9, 3.8062927429928727`*^9}, {3.8062928097241316`*^9, 
   3.8062929174703217`*^9}, {3.806292961245179*^9, 3.8062929803916817`*^9}, {
   3.8062930440670204`*^9, 3.806293045884973*^9}, {3.8062931001455564`*^9, 
   3.8062931780115256`*^9}, {3.8062932588494167`*^9, 3.806293299331362*^9}, {
   3.806293514855739*^9, 3.8062935834519496`*^9}, {3.806293658790984*^9, 
   3.80629367470557*^9}, 3.8062937060957513`*^9, 3.806293856837819*^9, {
   3.806293890480942*^9, 3.8062938919119034`*^9}, {3.806293978456646*^9, 
   3.806294031042274*^9}, {3.806294089117759*^9, 3.806294115093083*^9}, {
   3.8062941472252436`*^9, 3.8062941645877905`*^9}, {3.806294223317259*^9, 
   3.806294227373156*^9}, {3.8062942923314595`*^9, 3.806294333281391*^9}, {
   3.806294383436082*^9, 3.8062945065718737`*^9}, {3.806294574367101*^9, 
   3.8062946304806376`*^9}, {3.806295011603696*^9, 3.8062951920089912`*^9}, {
   3.8062952793377123`*^9, 3.806295337664192*^9}, {3.8062953856249433`*^9, 
   3.806295429382799*^9}, {3.8062955446187935`*^9, 3.806295634933442*^9}, {
   3.8062957968642144`*^9, 3.8062958114438334`*^9}, {3.8062958725882373`*^9, 
   3.8062960529285336`*^9}, {3.806296107839101*^9, 3.8062963009070644`*^9}, {
   3.8062963612354913`*^9, 3.806296570869023*^9}, {3.8062967118803453`*^9, 
   3.8062967146682715`*^9}, {3.80629681638762*^9, 3.8062968271813383`*^9}, {
   3.806297017100383*^9, 3.806297021052281*^9}, {3.806297464014725*^9, 
   3.806297572391899*^9}, {3.806297765241869*^9, 3.806297816892521*^9}, {
   3.806298276281537*^9, 3.806298285917286*^9}, {3.8062987616806*^9, 
   3.8062987680144353`*^9}, {3.8062990382133913`*^9, 3.806299041817296*^9}, {
   3.806420464745043*^9, 3.8064204942249875`*^9}, {3.8064205663056393`*^9, 
   3.806420576950287*^9}, {3.806420663479575*^9, 3.80642067700175*^9}, {
   3.8064207588649817`*^9, 3.806420784255071*^9}, {3.806420815146846*^9, 
   3.8064208307754765`*^9}, {3.8064209147322264`*^9, 3.806420931733082*^9}, {
   3.8064210141007895`*^9, 3.8064210277537374`*^9}, {3.806421310498294*^9, 
   3.8064213473378563`*^9}, {3.8064214758650823`*^9, 3.806421475980993*^9}, {
   3.8064217027365637`*^9, 3.806421725652338*^9}, {3.806421780082057*^9, 
   3.8064217848018637`*^9}, {3.8064218262980747`*^9, 
   3.8064218296922483`*^9}, {3.8064219343499613`*^9, 3.806421934481479*^9}, {
   3.8064221630557394`*^9, 3.806422170306838*^9}, {3.806422275284265*^9, 
   3.8064223436025715`*^9}, {3.806422559013601*^9, 3.8064225939834704`*^9}, {
   3.806422703621662*^9, 3.8064227169433575`*^9}, {3.806422847864078*^9, 
   3.8064228526932583`*^9}, {3.806422883804216*^9, 3.806422927519968*^9}, {
   3.8064230162305326`*^9, 3.8064230505637703`*^9}, {3.8064231293155084`*^9, 
   3.806423232162842*^9}, {3.8064235290786824`*^9, 3.8064235330576825`*^9}, {
   3.806424466655398*^9, 3.806424467073247*^9}, 3.806424528740016*^9, {
   3.8064246245695086`*^9, 3.806424630701586*^9}, {3.8064249045561953`*^9, 
   3.8064249048351855`*^9}, {3.8064268220541887`*^9, 
   3.8064268223591757`*^9}, {3.8064269112852955`*^9, 
   3.8064269114592905`*^9}, {3.8064271968467274`*^9, 
   3.8064272041155357`*^9}, {3.8064281213426275`*^9, 
   3.8064281254175215`*^9}, {3.806463033487875*^9, 3.8064630513331566`*^9}, {
   3.8064634659972563`*^9, 3.8064634662522492`*^9}, {3.806463605266906*^9, 
   3.806463655270669*^9}, {3.8064643489336767`*^9, 3.8064643494038467`*^9}, 
   3.8064645697576475`*^9, {3.806472300923811*^9, 3.8064723475344796`*^9}, {
   3.8064724441194043`*^9, 3.8064724473381386`*^9}, {3.8064724902431917`*^9, 
   3.80647250876315*^9}, {3.806472558744483*^9, 3.806472609089243*^9}, {
   3.806473711330943*^9, 3.806473768155487*^9}, {3.806474874377623*^9, 
   3.806474941756937*^9}, {3.8064751701897697`*^9, 3.8064751932126994`*^9}, {
   3.806476719937291*^9, 3.806476756385399*^9}, {3.806477102876441*^9, 
   3.8064771130498724`*^9}, 3.806484252016334*^9, {3.8064845459031982`*^9, 
   3.806484549958104*^9}, {3.8064849746752367`*^9, 3.806484979429125*^9}, {
   3.806485490696145*^9, 3.8064854920811157`*^9}, 3.8064861561810675`*^9, {
   3.8066717889511147`*^9, 3.8066717989527597`*^9}, 3.8066826775102253`*^9, 
   3.806682920475539*^9, {3.8067168524695044`*^9, 3.806716953794016*^9}, {
   3.806717049350457*^9, 3.8067170523430076`*^9}, {3.806717180652562*^9, 
   3.8067172209180813`*^9}, {3.8067178976483655`*^9, 3.806717939657549*^9}, {
   3.806719377552554*^9, 3.806719487044958*^9}, {3.806719613485961*^9, 
   3.8067196406603184`*^9}, {3.806820094745735*^9, 3.806820135723385*^9}, {
   3.807293756125896*^9, 3.807293758730835*^9}, {3.8072938904086304`*^9, 
   3.8072938992294188`*^9}, {3.8072948550601606`*^9, 
   3.8072948634769535`*^9}, {3.807320547212088*^9, 3.8073205748319263`*^9}, {
   3.8073210718244896`*^9, 3.8073210858946486`*^9}, {3.8073232072004447`*^9, 
   3.807323227103499*^9}, {3.807324520176442*^9, 3.807324523015729*^9}, {
   3.8073457278334785`*^9, 3.8073457439317527`*^9}, {3.8073458267468715`*^9, 
   3.8073458275960927`*^9}, {3.8075801409306526`*^9, 
   3.8075801573296347`*^9}, {3.807580256336297*^9, 3.8075802663180103`*^9}, {
   3.807580299343194*^9, 3.8075803684038906`*^9}, {3.807580460598915*^9, 
   3.807580463560544*^9}, {3.8075805743755183`*^9, 3.807580613151142*^9}, {
   3.8075806729530134`*^9, 3.807580675328724*^9}, {3.8075807503190966`*^9, 
   3.8075807940860844`*^9}, {3.8075808556763716`*^9, 3.807580875408876*^9}, {
   3.8075809096713495`*^9, 3.8075809322036104`*^9}, {3.8075809786478453`*^9, 
   3.807581133940355*^9}, {3.807581257579525*^9, 3.8075812580808167`*^9}, {
   3.807581291793475*^9, 3.807581305400307*^9}, {3.8075813690872593`*^9, 
   3.8075813727440753`*^9}, {3.807581429669726*^9, 3.8075814588803473`*^9}, {
   3.8075815413070445`*^9, 3.807581544145952*^9}, {3.8075817473002205`*^9, 
   3.8075817477859907`*^9}, {3.8075817840177774`*^9, 3.8075819619598866`*^9}, 
   3.8075820390327873`*^9, {3.807582101502959*^9, 3.8075821171785913`*^9}, {
   3.807582203952795*^9, 3.807582205187445*^9}, {3.807582311046046*^9, 
   3.807582363960781*^9}, {3.8075824580275106`*^9, 3.807582462138372*^9}, {
   3.8075824946597404`*^9, 3.807582521077366*^9}, 3.8075826430045605`*^9, {
   3.807582782752143*^9, 3.807582797894153*^9}, {3.807582887221235*^9, 
   3.807582914478451*^9}, {3.8075829454679565`*^9, 3.8075829484295907`*^9}, {
   3.807583053198392*^9, 3.8075830748118963`*^9}, 3.80758313095588*^9, {
   3.8075833022934313`*^9, 3.807583302832624*^9}, 3.8075833487647667`*^9, {
   3.807583396247253*^9, 3.8075834118786535`*^9}, {3.8075834782462454`*^9, 
   3.8075834808881826`*^9}, {3.8075835342536297`*^9, 3.8075835539851246`*^9}, 
   3.8075836172719655`*^9, {3.8075836654230404`*^9, 3.807583715538636*^9}, {
   3.8075837718437605`*^9, 3.8075837928712454`*^9}, 3.8075838621678886`*^9, {
   3.8075839487234006`*^9, 3.807583966027979*^9}, {3.8075840207077856`*^9, 
   3.8075840507023087`*^9}, {3.807584111396126*^9, 3.8075841524705477`*^9}, {
   3.807584217086954*^9, 3.8075843298699226`*^9}, {3.8075843945739956`*^9, 
   3.807584398322093*^9}, {3.807584528096592*^9, 3.80758455972281*^9}, {
   3.8075846567554173`*^9, 3.8075846983999767`*^9}, {3.807584780447291*^9, 
   3.807584842812403*^9}, {3.807584934444356*^9, 3.8075849346449175`*^9}, {
   3.8075850151553545`*^9, 3.807585023700121*^9}, {3.8075850893648767`*^9, 
   3.8075851370267167`*^9}, {3.8075852634901457`*^9, 
   3.8075853490094585`*^9}, {3.807585416706159*^9, 3.807585420644103*^9}, {
   3.807587243307002*^9, 3.807587260393323*^9}, {3.807587799087598*^9, 
   3.807587833513797*^9}, {3.8075878658757706`*^9, 3.807587932720568*^9}, {
   3.8075879995526123`*^9, 3.807588008292274*^9}, {3.807588071692251*^9, 
   3.807588103110821*^9}, {3.8075882079554768`*^9, 3.8075882083253617`*^9}, {
   3.8076887143741493`*^9, 3.8076887229499474`*^9}, {3.807688759737085*^9, 
   3.807688768001887*^9}, {3.807689213478317*^9, 3.8076892228330956`*^9}, {
   3.807689801700781*^9, 3.807689944729412*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N1 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", "\[Eta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}], " ", "\[Xi]"}]}],
  SequenceForm[
  "N1 = ", Rational[
    1, 4] (-1 + $CellContext`\[Eta]) $CellContext`\[Eta] (-1 + $CellContext`\
\[Xi]) $CellContext`\[Xi]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8062590823057947`*^9, 3.806259097973392*^9}, 
   3.806259175696431*^9, 3.806259235818915*^9, 3.8062594835796647`*^9, 
   3.806259837088747*^9, 3.806260097339182*^9, 3.8062602687588577`*^9, 
   3.806260721922427*^9, 3.806260779722968*^9, 3.806260836658532*^9, 
   3.8062613175034027`*^9, 3.8062615862506227`*^9, 3.806261616459861*^9, 
   3.8062619382921762`*^9, 3.8062629289174805`*^9, 3.806263055915275*^9, 
   3.8062632262409806`*^9, 3.8062931923931503`*^9, {3.806293287398672*^9, 
   3.80629331432297*^9}, 3.8062946378074465`*^9, 3.806295198613818*^9, 
   3.806295342435067*^9, 3.806295437953574*^9, 3.80629566011378*^9, 
   3.8062958163467045`*^9, 3.8062960600773478`*^9, 3.8062963080458784`*^9, 
   3.8062965247542257`*^9, 3.8062965750749135`*^9, 3.8062967379346647`*^9, 
   3.80629683319018*^9, 3.806297026586136*^9, 3.8062978267092657`*^9, 
   3.8062983816677885`*^9, 3.806298706519038*^9, 3.8062987723383217`*^9, 
   3.8062990539069767`*^9, 3.8064204980627546`*^9, 3.8064209366744537`*^9, 
   3.806421037896655*^9, 3.8064213537014556`*^9, 3.8064215020288677`*^9, 
   3.806421854082852*^9, 3.806421939465147*^9, 3.8064223470867105`*^9, 
   3.8064226000405397`*^9, 3.8064227228136964`*^9, 3.80642293151746*^9, 
   3.806423066237996*^9, 3.806423238144845*^9, 3.8064235353105392`*^9, 
   3.806424468405384*^9, 3.8064245332407374`*^9, 3.8064246366001854`*^9, 
   3.806424916616871*^9, 3.806425041332559*^9, 3.8064268259520807`*^9, 
   3.8064269186331015`*^9, 3.806427208709411*^9, 3.80642812760346*^9, 
   3.8064630639345775`*^9, 3.8064634742472663`*^9, 3.8064636107950788`*^9, 
   3.806463664980728*^9, 3.8064644043976526`*^9, 3.80646457698627*^9, 
   3.806470850690292*^9, 3.806472353520133*^9, 3.806472621950137*^9, 
   3.806473773141345*^9, 3.806474947085039*^9, 3.8064752039026546`*^9, 
   3.8064767614024787`*^9, 3.806477120910578*^9, 3.8064842549002633`*^9, 
   3.8064845610688353`*^9, 3.8064849849319906`*^9, 3.8064854960870185`*^9, 
   3.8064861608239517`*^9, 3.806671740998494*^9, 3.806671804532303*^9, 
   3.8066826808041406`*^9, 3.8066829250504217`*^9, 3.806716956923764*^9, 
   3.8067172250921783`*^9, 3.8067179465618305`*^9, 3.8067194943217845`*^9, 
   3.806719645560199*^9, 3.806761181351988*^9, 3.8068201473682756`*^9, 
   3.806820448998047*^9, 3.8072937628997307`*^9, 3.8072939059642496`*^9, 
   3.807294871351761*^9, 3.8072951095419683`*^9, 3.8072971575153203`*^9, 
   3.807321091379052*^9, 3.8073232331147118`*^9, 3.807324530812215*^9, 
   3.8073248383974667`*^9, 3.807345830590127*^9, 3.807580386193572*^9, 
   3.807580468103498*^9, 3.8075806338093395`*^9, 3.807580678627002*^9, 
   3.807580935339381*^9, 3.807581203655674*^9, 3.8075813198791003`*^9, 
   3.807581377446286*^9, 3.8075814640853834`*^9, 3.807581548973415*^9, 
   3.8075815804945197`*^9, 3.8075819698678913`*^9, 3.8075820517011924`*^9, 
   3.807582121220319*^9, 3.8075822102646217`*^9, 3.807582385486492*^9, 
   3.8075825442417965`*^9, 3.807582655582506*^9, 3.8075828016042333`*^9, 
   3.8075829525023985`*^9, 3.8075830819067245`*^9, 3.8075831396137285`*^9, 
   3.8075833516426926`*^9, 3.807583416927528*^9, 3.8075834852050734`*^9, 
   3.8075835582480187`*^9, {3.8075837035019307`*^9, 3.807583719427539*^9}, 
   3.807583802836999*^9, 3.807583866939765*^9, 3.8075839747357597`*^9, {
   3.8075840416212654`*^9, 3.8075840616927977`*^9}, {3.8075841423332024`*^9, 
   3.807584161521321*^9}, {3.807584313544323*^9, 3.807584333401832*^9}, 
   3.807584412152753*^9, 3.8075847108037214`*^9, 3.807584787749139*^9, {
   3.8075848187481155`*^9, 3.8075848481178546`*^9}, 3.807584939975685*^9, 
   3.8075850292615614`*^9, 3.807585139667612*^9, 3.8075853609595833`*^9, 
   3.807585441355931*^9, 3.8075872664560413`*^9, 3.807587837656022*^9, 
   3.8075879415284233`*^9, 3.8075880149153547`*^9, 3.807588121201116*^9, 
   3.807588250729895*^9, 3.8076887292188005`*^9, 3.807688774501734*^9, 
   3.8076899501372814`*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnXmczeX7/61lyRKRLUvGmo8lSZjc2cpOJJIipixlMsiefc2+jBETxi6y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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgT9Ubx++55yqbkJGVVDIy27QnWjYlSUilIi1piRJpqaRBhewRoiVN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           "]], Polygon3DBox[CompressedData["
1:eJwtmmXAVUUXRs/MXEJUBBQBG7uxO7C7sBMURQUVW0ARA7sAC7EbMLFFxQ7s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           "]], Polygon3DBox[CompressedData["
1:eJwt13e4FNUVAPB9uwuKgqiohKKIFCM1dEOVbmhKT2hGqpGmUiRSLFQVBBWB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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0jkvBVEYgOGxr9cS0RINUVCKglIUVCIKOqKgIBEFpULodPwCWiL0Ejr7
cu1rRMTW2NfwnETxznMy92TmO5lb0t7b1JMQRdGwXhXWj7rUbGIU5XGBxVxn
JU9Zywc28pttzE6Kopi6rcs5yGqOsp4TbOEUOznPfi7xntd817aewz0tG2iH
K4xzlbtc416Yifvc4AE3uaXD8BwecYfHjPOEuzzlHs+4z3NOO8cNP3Shl3BG
jZlti0NcZB/n2MFJNnOcdRxhFQdYxlJ1WWewlZ/e0cA71vCYFeFcLOKtfVd8
U66ewl4VmjGHBYwxn9lhD7MYYyazmBHex3SmMkVp1klMDd843OOvkvUTftOX
jBHNuNz+/x/+AMQfSu8=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{690, 1000, 473, 689, 1106, 912, 691, 1107, 913, 692, 1108, 
        914, 693, 1109, 915, 694, 1110, 916, 695, 1111, 1006, 1206, 696, 1112,
         917, 697, 1113, 918, 698, 1114, 919, 699, 1115, 920, 700, 1116, 921, 
        701, 1117, 922, 702, 1308, 1001, 923, 1002},
        VertexColors->None], 
       Line3DBox[{704, 1007, 1207, 703, 488, 705, 1118, 924, 706, 1119, 925, 
        707, 1120, 926, 708, 1121, 927, 709, 1122, 1008, 1208, 710, 1009, 
        1209, 711, 1123, 928, 712, 1124, 929, 713, 1125, 930, 714, 1126, 931, 
        715, 1127, 932, 716, 1128, 933, 717},
        VertexColors->None], 
       Line3DBox[{719, 1010, 1210, 718, 1011, 1211, 720, 504, 721, 1129, 934, 
        722, 1130, 935, 723, 1131, 936, 724, 1132, 1012, 1212, 725, 1013, 
        1213, 726, 1014, 1214, 727, 512, 728, 1133, 937, 729, 1134, 938, 730, 
        1135, 939, 731, 1136, 940, 732},
        VertexColors->None], 
       Line3DBox[{734, 1015, 1215, 733, 1016, 1216, 735, 1017, 1217, 736, 520,
         737, 1137, 941, 738, 1138, 942, 739, 1139, 1018, 1218, 740, 1019, 
        1219, 741, 1020, 1220, 742, 1021, 1221, 743, 528, 744, 1140, 943, 745,
         1141, 944, 746, 1142, 945, 747},
        VertexColors->None], 
       Line3DBox[{749, 1022, 1222, 748, 1023, 1223, 750, 1024, 1224, 751, 
        1025, 1225, 752, 536, 753, 1143, 946, 754, 1144, 1026, 1226, 755, 
        1027, 1227, 756, 1028, 1228, 757, 1029, 1229, 758, 1030, 1230, 759, 
        1031, 1231, 760, 1145, 947, 761, 1146, 948, 762},
        VertexColors->None], 
       Line3DBox[{764, 1032, 1232, 763, 1033, 1233, 765, 1034, 1234, 766, 
        1035, 1235, 767, 1036, 1236, 768, 552, 769, 1147, 1037, 1237, 770, 
        1038, 1238, 771, 1039, 1239, 772, 1040, 1240, 773, 1041, 1241, 774, 
        1042, 1242, 775, 560, 776, 1148, 949, 777},
        VertexColors->None], 
       Line3DBox[{781, 1149, 950, 779, 1150, 951, 783, 1151, 952, 785, 1152, 
        953, 787, 1153, 954, 789, 1154, 955, 791, 1155, 569, 793, 1156, 956, 
        795, 1157, 957, 797, 1158, 958, 799, 1159, 959, 801, 1160, 960, 803, 
        1161, 961, 805, 1163, 963, 807},
        VertexColors->None], 
       Line3DBox[{806, 962, 1162, 804, 1255, 1054, 802, 1254, 1053, 800, 1253,
         1052, 798, 1252, 1051, 796, 1251, 1050, 794, 1250, 1049, 792, 1249, 
        568, 790, 1248, 1048, 788, 1247, 1047, 786, 1246, 1046, 784, 1245, 
        1045, 782, 1244, 1044, 778, 1243, 1043, 780},
        VertexColors->None], 
       Line3DBox[{809, 1055, 1256, 808, 1164, 964, 810, 1165, 965, 811, 1166, 
        966, 812, 1167, 967, 813, 1168, 968, 814, 1169, 1056, 1257, 815, 585, 
        816, 1170, 969, 817, 1171, 970, 818, 1172, 971, 819, 1173, 972, 820, 
        1174, 973, 821, 1175, 974, 822},
        VertexColors->None], 
       Line3DBox[{824, 1057, 1258, 823, 1058, 1259, 825, 1176, 975, 826, 1177,
         976, 827, 1178, 977, 828, 1179, 978, 829, 1180, 1059, 1260, 830, 
        1060, 1261, 831, 601, 832, 1181, 979, 833, 1182, 980, 834, 1183, 981, 
        835, 1184, 982, 836, 1185, 983, 837},
        VertexColors->None], 
       Line3DBox[{839, 1061, 1262, 838, 1062, 1263, 840, 609, 841, 1186, 984, 
        842, 1187, 985, 843, 1188, 986, 844, 1189, 1063, 1264, 845, 1064, 
        1265, 846, 1065, 1266, 847, 617, 848, 1190, 987, 849, 1191, 988, 850, 
        1192, 989, 851, 1193, 990, 852},
        VertexColors->None], 
       Line3DBox[{854, 1066, 1267, 853, 1067, 1268, 855, 1068, 1269, 856, 625,
         857, 1194, 991, 858, 1195, 992, 859, 1196, 1069, 1270, 860, 1070, 
        1271, 861, 1071, 1272, 862, 1072, 1273, 863, 633, 864, 1197, 993, 865,
         1198, 994, 866, 1199, 995, 867},
        VertexColors->None], 
       Line3DBox[{869, 1073, 1274, 868, 1074, 1275, 870, 1075, 1276, 871, 
        1076, 1277, 872, 641, 873, 1200, 996, 874, 1201, 1077, 1278, 875, 
        1078, 1279, 876, 1079, 1280, 877, 1080, 1281, 878, 1081, 1282, 879, 
        649, 880, 1202, 997, 881, 1203, 998, 882},
        VertexColors->None], 
       Line3DBox[{884, 1082, 1283, 883, 1083, 1284, 885, 1084, 1285, 886, 
        1085, 1286, 887, 1086, 1287, 888, 657, 889, 1204, 1087, 1288, 890, 
        1088, 1289, 891, 1089, 1290, 892, 1090, 1291, 893, 1091, 1292, 894, 
        1092, 1293, 895, 665, 896, 1205, 999, 897},
        VertexColors->None], 
       Line3DBox[{911, 1005, 685, 910, 1307, 1104, 909, 1306, 1103, 908, 1305,
         1102, 907, 1304, 1101, 906, 1303, 1100, 905, 1302, 1099, 904, 1301, 
        1300, 1098, 903, 1299, 1097, 902, 1298, 1096, 901, 1297, 1095, 900, 
        1296, 1094, 899, 1295, 1093, 898, 1105, 1294, 1003, 1004},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 474, 1106, 252, 488, 280, 1211, 503, 295, 1216, 518, 
        310, 1223, 533, 325, 1233, 548, 340, 1244, 563, 1150, 355, 578, 1164, 
        370, 1259, 593, 385, 1263, 608, 400, 1268, 623, 415, 1275, 638, 430, 
        1284, 653, 445, 1295, 668, 460},
        VertexColors->None], 
       Line3DBox[{253, 475, 1107, 254, 489, 1118, 281, 504, 296, 1217, 519, 
        311, 1224, 534, 326, 1234, 549, 341, 1245, 564, 1151, 356, 579, 1165, 
        371, 594, 1176, 386, 609, 401, 1269, 624, 416, 1276, 639, 431, 1285, 
        654, 446, 1296, 669, 461},
        VertexColors->None], 
       Line3DBox[{255, 476, 1108, 256, 490, 1119, 282, 505, 1129, 297, 520, 
        312, 1225, 535, 327, 1235, 550, 342, 1246, 565, 1152, 357, 580, 1166, 
        372, 595, 1177, 387, 610, 1186, 402, 625, 417, 1277, 640, 432, 1286, 
        655, 447, 1297, 670, 462},
        VertexColors->None], 
       Line3DBox[{257, 477, 1109, 258, 491, 1120, 283, 506, 1130, 298, 521, 
        1137, 313, 536, 328, 1236, 551, 343, 1247, 566, 1153, 358, 581, 1167, 
        373, 596, 1178, 388, 611, 1187, 403, 626, 1194, 418, 641, 433, 1287, 
        656, 448, 1298, 671, 463},
        VertexColors->None], 
       Line3DBox[{259, 478, 1110, 260, 492, 1121, 284, 507, 1131, 299, 522, 
        1138, 314, 537, 1143, 329, 552, 344, 1248, 567, 1154, 359, 582, 1168, 
        374, 597, 1179, 389, 612, 1188, 404, 627, 1195, 419, 642, 1200, 434, 
        657, 449, 1299, 672, 464},
        VertexColors->None], 
       Line3DBox[{261, 479, 1111, 263, 493, 1122, 285, 508, 1132, 300, 523, 
        1139, 315, 538, 1144, 330, 553, 1147, 345, 568, 1155, 360, 583, 1169, 
        375, 598, 1180, 390, 613, 1189, 405, 628, 1196, 420, 643, 1201, 435, 
        658, 1204, 450, 1300, 673, 465},
        VertexColors->None], 
       Line3DBox[{265, 481, 1112, 266, 1209, 495, 287, 1213, 510, 302, 1219, 
        525, 317, 1227, 540, 332, 1238, 555, 347, 1250, 570, 1156, 362, 585, 
        377, 1261, 600, 392, 1265, 615, 407, 1271, 630, 422, 1279, 645, 437, 
        1289, 660, 452, 1302, 675, 467},
        VertexColors->None], 
       Line3DBox[{267, 482, 1113, 268, 496, 1123, 288, 1214, 511, 303, 1220, 
        526, 318, 1228, 541, 333, 1239, 556, 348, 1251, 571, 1157, 363, 586, 
        1170, 378, 601, 393, 1266, 616, 408, 1272, 631, 423, 1280, 646, 438, 
        1290, 661, 453, 1303, 676, 468},
        VertexColors->None], 
       Line3DBox[{269, 483, 1114, 270, 497, 1124, 289, 512, 304, 1221, 527, 
        319, 1229, 542, 334, 1240, 557, 349, 1252, 572, 1158, 364, 587, 1171, 
        379, 602, 1181, 394, 617, 409, 1273, 632, 424, 1281, 647, 439, 1291, 
        662, 454, 1304, 677, 469},
        VertexColors->None], 
       Line3DBox[{271, 484, 1115, 272, 498, 1125, 290, 513, 1133, 305, 528, 
        320, 1230, 543, 335, 1241, 558, 350, 1253, 573, 1159, 365, 588, 1172, 
        380, 603, 1182, 395, 618, 1190, 410, 633, 425, 1282, 648, 440, 1292, 
        663, 455, 1305, 678, 470},
        VertexColors->None], 
       Line3DBox[{273, 485, 1116, 274, 499, 1126, 291, 514, 1134, 306, 529, 
        1140, 321, 1231, 544, 336, 1242, 559, 351, 1254, 574, 1160, 366, 589, 
        1173, 381, 604, 1183, 396, 619, 1191, 411, 634, 1197, 426, 649, 441, 
        1293, 664, 456, 1306, 679, 471},
        VertexColors->None], 
       Line3DBox[{275, 486, 1117, 276, 500, 1127, 292, 515, 1135, 307, 530, 
        1141, 322, 545, 1145, 337, 560, 352, 1255, 575, 1161, 367, 590, 1174, 
        382, 605, 1184, 397, 620, 1192, 412, 635, 1198, 427, 650, 1202, 442, 
        665, 457, 1307, 680, 472},
        VertexColors->None], 
       Line3DBox[{277, 682, 1308, 683, 278, 501, 1128, 293, 516, 1136, 308, 
        531, 1142, 323, 546, 1146, 338, 561, 1148, 353, 576, 1162, 1163, 368, 
        591, 1175, 383, 606, 1185, 398, 621, 1193, 413, 636, 1199, 428, 651, 
        1203, 443, 666, 1205, 458, 685, 686, 687},
        VertexColors->None], 
       Line3DBox[{459, 667, 684, 1294, 444, 652, 1283, 429, 637, 1274, 414, 
        622, 1267, 399, 607, 1262, 384, 592, 1258, 369, 577, 1256, 354, 1149, 
        562, 1243, 339, 547, 1232, 324, 532, 1222, 309, 517, 1215, 294, 502, 
        1210, 279, 487, 1207, 250, 473, 681, 688},
        VertexColors->None], 
       Line3DBox[{466, 674, 1301, 451, 659, 1288, 436, 644, 1278, 421, 629, 
        1270, 406, 614, 1264, 391, 599, 1260, 376, 584, 1257, 361, 569, 1249, 
        346, 554, 1237, 331, 539, 1226, 316, 524, 1218, 301, 509, 1212, 286, 
        494, 1208, 264, 480, 1206, 262},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzFmXlYjeu7x0tmUShTkSnzVGnYqLvUNjQQQipbKTJk2ITQVjIlZSZFKqU5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     "],
    VertexNormals->CompressedData["
1:eJx0nHdcjtH7+IvslS0hRLYQGqorNFBIGZEiFYVSlGQWqTSlSEtTaWkvjdNe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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2}]], "Output",
 CellChangeTimes->{{3.8062590823037868`*^9, 3.8062590981303883`*^9}, 
   3.8062591758524275`*^9, 3.80625923597591*^9, 3.8062594837336607`*^9, 
   3.8062598372447433`*^9, 3.806260097497178*^9, 3.8062602689138536`*^9, 
   3.8062607220794234`*^9, 3.8062607798769646`*^9, 3.8062608368125277`*^9, 
   3.8062613176603985`*^9, 3.8062615864156184`*^9, 3.8062616166148567`*^9, 
   3.80626193846017*^9, 3.806262929080475*^9, 3.806263056092271*^9, 
   3.8062632264069753`*^9, 3.806293192531146*^9, {3.8062932875496683`*^9, 
   3.806293314471966*^9}, 3.806294637966442*^9, 3.806295198773814*^9, 
   3.8062953425930624`*^9, 3.8062954381165714`*^9, 3.806295660268776*^9, 
   3.8062958165037003`*^9, 3.8062960602323427`*^9, 3.806296308199875*^9, 
   3.8062965249092236`*^9, 3.806296575238909*^9, 3.806296738092661*^9, 
   3.806296833346176*^9, 3.806297026742131*^9, 3.80629782687426*^9, 
   3.806298381844784*^9, 3.806298706676035*^9, 3.806298772494319*^9, 
   3.8062990540669746`*^9, 3.8064204982945185`*^9, 3.8064209368437247`*^9, 
   3.806421038144055*^9, 3.806421353855109*^9, 3.8064215021916313`*^9, 
   3.8064218542299924`*^9, 3.8064219396031685`*^9, 3.806422347249019*^9, 
   3.8064226001876774`*^9, 3.8064227229673443`*^9, 3.806422931664608*^9, 
   3.8064230663851457`*^9, 3.8064232383076167`*^9, 3.806423535464188*^9, 
   3.8064244686592984`*^9, 3.8064245333883944`*^9, 3.806424636757181*^9, 
   3.8064249167708683`*^9, 3.8064250414645543`*^9, 3.8064268261470747`*^9, 
   3.806426918806096*^9, 3.806427208869408*^9, 3.8064281277844543`*^9, 
   3.8064630641685715`*^9, 3.806463474405262*^9, 3.8064636109600744`*^9, 
   3.806463665161723*^9, 3.8064644045669317`*^9, 3.8064645771711707`*^9, 
   3.8064708509402885`*^9, 3.806472353676381*^9, 3.8064726221063857`*^9, 
   3.806473773297595*^9, 3.806474947241291*^9, 3.8064752040589037`*^9, 
   3.806476761558728*^9, 3.806477121066829*^9, 3.806484255149258*^9, 
   3.8064845612268324`*^9, 3.806484985092987*^9, 3.8064854962690134`*^9, 
   3.806486160981949*^9, 3.8066717412328653`*^9, 3.80667180468855*^9, 
   3.8066826810541344`*^9, 3.8066829252444158`*^9, 3.8067169571438203`*^9, 
   3.8067172252458334`*^9, 3.8067179467246037`*^9, 3.8067194944947805`*^9, 
   3.8067196457291946`*^9, 3.8067611816049814`*^9, 3.806820147544272*^9, 
   3.8068204491660433`*^9, 3.807293763067728*^9, 3.8072939061262474`*^9, 
   3.807294871513759*^9, 3.8072951097259617`*^9, 3.807297157682315*^9, 
   3.8073210915331397`*^9, 3.80732323328399*^9, 3.8073245309906073`*^9, 
   3.8073248385602283`*^9, 3.807345830802204*^9, 3.8075803864434385`*^9, 
   3.807580468257147*^9, 3.8075806339629855`*^9, 3.807580678774136*^9, 
   3.8075809354930363`*^9, 3.8075812038093295`*^9, 3.807581320048287*^9, 
   3.8075813775999346`*^9, 3.80758146423903*^9, 3.807581549127282*^9, 
   3.8075815806572886`*^9, 3.80758197001503*^9, 3.8075820518548403`*^9, 
   3.80758212135834*^9, 3.807582210418275*^9, 3.8075823856336403`*^9, 
   3.807582544310808*^9, 3.807582655651515*^9, 3.807582801673309*^9, 
   3.807582952555792*^9, 3.8075830819757385`*^9, 3.8075831396827393`*^9, 
   3.807583351712691*^9, 3.8075834169995265`*^9, 3.8075834852780714`*^9, 
   3.8075835583190174`*^9, {3.80758370356993*^9, 3.807583719498537*^9}, 
   3.807583802906995*^9, 3.807583867011763*^9, 3.8075839748087587`*^9, {
   3.807584041692263*^9, 3.807584061761818*^9}, {3.807584142417838*^9, 
   3.8075841616043186`*^9}, {3.80758431361432*^9, 3.80758433347383*^9}, 
   3.8075844122307515`*^9, 3.807584710881852*^9, 3.8075847878181515`*^9, {
   3.8075848188327503`*^9, 3.807584848186865*^9}, 3.807584940044697*^9, 
   3.8075850293461995`*^9, 3.8075851397366233`*^9, 3.8075853610442142`*^9, 
   3.8075854414340563`*^9, 3.8075872665406756`*^9, 3.807587837725031*^9, 
   3.8075879415974426`*^9, 3.8075880149843636`*^9, 3.8075881212692966`*^9, 
   3.8075882507989025`*^9, 3.807688729312798*^9, 3.807688774587732*^9, 
   3.8076899502172823`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", "\[Eta]", " ", "\[Xi]",
     " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N2 = ", Rational[
    1, 4] (-1 + $CellContext`\[Eta]) $CellContext`\[Eta] $CellContext`\[Xi] (
    1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8062590823057947`*^9, 3.806259097973392*^9}, 
   3.806259175696431*^9, 3.806259235818915*^9, 3.8062594835796647`*^9, 
   3.806259837088747*^9, 3.806260097339182*^9, 3.8062602687588577`*^9, 
   3.806260721922427*^9, 3.806260779722968*^9, 3.806260836658532*^9, 
   3.8062613175034027`*^9, 3.8062615862506227`*^9, 3.806261616459861*^9, 
   3.8062619382921762`*^9, 3.8062629289174805`*^9, 3.806263055915275*^9, 
   3.8062632262409806`*^9, 3.8062931923931503`*^9, {3.806293287398672*^9, 
   3.80629331432297*^9}, 3.8062946378074465`*^9, 3.806295198613818*^9, 
   3.806295342435067*^9, 3.806295437953574*^9, 3.80629566011378*^9, 
   3.8062958163467045`*^9, 3.8062960600773478`*^9, 3.8062963080458784`*^9, 
   3.8062965247542257`*^9, 3.8062965750749135`*^9, 3.8062967379346647`*^9, 
   3.80629683319018*^9, 3.806297026586136*^9, 3.8062978267092657`*^9, 
   3.8062983816677885`*^9, 3.806298706519038*^9, 3.8062987723383217`*^9, 
   3.8062990539069767`*^9, 3.8064204980627546`*^9, 3.8064209366744537`*^9, 
   3.806421037896655*^9, 3.8064213537014556`*^9, 3.8064215020288677`*^9, 
   3.806421854082852*^9, 3.806421939465147*^9, 3.8064223470867105`*^9, 
   3.8064226000405397`*^9, 3.8064227228136964`*^9, 3.80642293151746*^9, 
   3.806423066237996*^9, 3.806423238144845*^9, 3.8064235353105392`*^9, 
   3.806424468405384*^9, 3.8064245332407374`*^9, 3.8064246366001854`*^9, 
   3.806424916616871*^9, 3.806425041332559*^9, 3.8064268259520807`*^9, 
   3.8064269186331015`*^9, 3.806427208709411*^9, 3.80642812760346*^9, 
   3.8064630639345775`*^9, 3.8064634742472663`*^9, 3.8064636107950788`*^9, 
   3.806463664980728*^9, 3.8064644043976526`*^9, 3.80646457698627*^9, 
   3.806470850690292*^9, 3.806472353520133*^9, 3.806472621950137*^9, 
   3.806473773141345*^9, 3.806474947085039*^9, 3.8064752039026546`*^9, 
   3.8064767614024787`*^9, 3.806477120910578*^9, 3.8064842549002633`*^9, 
   3.8064845610688353`*^9, 3.8064849849319906`*^9, 3.8064854960870185`*^9, 
   3.8064861608239517`*^9, 3.806671740998494*^9, 3.806671804532303*^9, 
   3.8066826808041406`*^9, 3.8066829250504217`*^9, 3.806716956923764*^9, 
   3.8067172250921783`*^9, 3.8067179465618305`*^9, 3.8067194943217845`*^9, 
   3.806719645560199*^9, 3.806761181351988*^9, 3.8068201473682756`*^9, 
   3.806820448998047*^9, 3.8072937628997307`*^9, 3.8072939059642496`*^9, 
   3.807294871351761*^9, 3.8072951095419683`*^9, 3.8072971575153203`*^9, 
   3.807321091379052*^9, 3.8073232331147118`*^9, 3.807324530812215*^9, 
   3.8073248383974667`*^9, 3.807345830590127*^9, 3.807580386193572*^9, 
   3.807580468103498*^9, 3.8075806338093395`*^9, 3.807580678627002*^9, 
   3.807580935339381*^9, 3.807581203655674*^9, 3.8075813198791003`*^9, 
   3.807581377446286*^9, 3.8075814640853834`*^9, 3.807581548973415*^9, 
   3.8075815804945197`*^9, 3.8075819698678913`*^9, 3.8075820517011924`*^9, 
   3.807582121220319*^9, 3.8075822102646217`*^9, 3.807582385486492*^9, 
   3.8075825442417965`*^9, 3.807582655582506*^9, 3.8075828016042333`*^9, 
   3.8075829525023985`*^9, 3.8075830819067245`*^9, 3.8075831396137285`*^9, 
   3.8075833516426926`*^9, 3.807583416927528*^9, 3.8075834852050734`*^9, 
   3.8075835582480187`*^9, {3.8075837035019307`*^9, 3.807583719427539*^9}, 
   3.807583802836999*^9, 3.807583866939765*^9, 3.8075839747357597`*^9, {
   3.8075840416212654`*^9, 3.8075840616927977`*^9}, {3.8075841423332024`*^9, 
   3.807584161521321*^9}, {3.807584313544323*^9, 3.807584333401832*^9}, 
   3.807584412152753*^9, 3.8075847108037214`*^9, 3.807584787749139*^9, {
   3.8075848187481155`*^9, 3.8075848481178546`*^9}, 3.807584939975685*^9, 
   3.8075850292615614`*^9, 3.807585139667612*^9, 3.8075853609595833`*^9, 
   3.807585441355931*^9, 3.8075872664560413`*^9, 3.807587837656022*^9, 
   3.8075879415284233`*^9, 3.8075880149153547`*^9, 3.807588121201116*^9, 
   3.807588250729895*^9, 3.8076887292188005`*^9, 3.807688774501734*^9, 
   3.807689950225284*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnXlcjen//+37vu/bpAxGYiwpXciSfYnBDGOLbCFb2bcsERIVaZCSyFqE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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgT9Ubx++55yqbkJGVVDIy27QnWjYlSUilIi1piRJpqaRBhewRoiVN
TSuRVREZZcsoJb/X+/e+f5zv87rne+/93HvuOc/zfp5TrcsdLW9PkyR5lT8R
OwN7FHZVSJLVWZLU47gUtg//nEN/Y3gBrTL9GfY7WiVdi/2KdjR8mHO/gcvB
Afs1rax+BLuEVh0uiF1MOxY+Evs97Xi4EHYRrSp8BHY37Sb4JOxd3Hc2tzkL
3k5rT//x2C208+Gq2IW0KnAB7FZaC/g47N1c+y7XNoH/oF1NfzXsGlpDuDT2
Z9op8NHYnbTO8InYlbST4ZLYpbQT4MLYIgWSZDh8AVwIfgE+D76d33qb3zoT
Lkn/SPovgYvCL8EXwqXhN+CmcDF4BHwRPJBrv+LaS+Ey9L9JfzN4Fa2uvg22
BP2vwRfDR8GjUp9/L9e+z7XnwD/SatNfHLuCVgcugS3F+a/Dl8HLaDXgoth7
uPY9rj0b/oF2Iv1FsPP1e/Ah/r8H7gHXxO6gXQ+fgN1MOxeugt1EOweujL0G
+yj37Mdc6gQ/Dj8Mt4YfhO+G28APwffAHeD+8P3wtfAA+AG4IzwQfhB+Bv4a
/hiuwTPdB3+OfY7+b+FP6W8LPwzfCz+dejznwTfCQ+GBcCv4AfgueBvP2o7j
6tjrsI/R/xD9XeAn4QFwV/gp+DH4BngI/Ch8M/wcPATuBj8NPw7345k+gs/n
ng/A8xLPkwfhjxPPgQHwl4nnxnraWVxfAXsH/TPoH8zxbxw3wVbE/kRrBJfB
rqWdBpfD/kI7FS6L3Ug7G66EXUc7HS6P3UBrDB+DvZX2D884gd+5BT4Ij4fv
p81NPIcfhj+FX9b3gT9JPD8fhecnnnvv0Ibx/3Oxz2O/07fQmHD8N3Yc5/4O
X8b/jsXex/EHib/V4/IRied/S477wX24ZrbeDx7G/ysyVydwfLXGLV+nc+h/
OF+n78EP5WPyLnwvXAGeCT8AN4Bn673g4+B34NHY1dx/Kb81nP4rOV5If1+4
GjwLHpE/02L4Hq1VeAZ8BxzhyXBvrXl4KnyX1iE8HX4iehyay+dovdH/Nn13
woXhafAj+fd6H+4FZ/AU+HY4hSfBt8EBngi/BF8FL4I/l7+A/5E/09rjPXZq
TsEF6D+gbwUfAf8Ffwgf4Jw/4aG0xTzbVfTNox2mf7/O0byg/yXNWfr/o38f
PA3ux//Wy5/p22s+wo9Fr0H5kE9pR9L/t3yP/CbX7oafpC3inCvpGwwvgC+H
Z9Ne4fzNmgvwfs7fA0/XOqF/AzwTHgJvhIfQFnLtFfQ9BS9JPB9m0Z7knE30
9c/XwgfwM/DFWvPws/Al8hfwPrgXXAe7V2sMrq1nZ449m9pnHpAfhOti39V6
4rde4NpDHD/C8SnYf7U24EYa4wL2R/KZBQrY1yi+HKY9Bp+mdaB5D9fXmqM9
BDfEluf8t1K/VwV4XOqxOgYen/ob/SWfDtfDlqN/bOoxnKMYxbM9z7MVpv/F
1H7moNYJ3AD7J02BvZbmF+c8lTp2R3ho6hiawk+kjlNDaRfAX3DPWdhS3P9Z
fevcb3wED8x91Fz4KfhCeD78InwFvAB+Ab5cvgAeBjeDv4Gfhi+Cv9Q8kU/i
/i/Cj+Y+6kP48dzXzZNfhMvA/0mU8JyPw6drTcCD4DPgL2jF4X855x1safkW
eHDmePSp1mPmePQJPCj3jR9r7snXcv5wuCz3HJN6zWoMbqX/RublLo67c1wj
f9ee9HcN1j5tNCeDtU9rze1gzdJO6ytYg7TV/A/WRFfKZ8Ll4RZaO8H66GrF
+uBYfSN8bbAmaq95HqyVOsKtgmN4V7gjXD8/p0WwjzkLbgSX1NjADYL9TSO4
drAv7AC3DPZVZ8IN4S28f0l4Jn3b4aXwM9H+spniVLCfawjXgotoHcB14JPg
G+D2wXrherht/gyXKY7ANeGWcDO4oOYpfEawzzgPPj1YX1wKnxvs2y6WDgn+
tpdIz8AnyL8n/qa6TwO4ZrB+6Qy3y59HY9s02LedDtcL1p5XKc4Ga8zr4NbB
Oq4T3AZO8nGrHzzvrlC8C/ap58CnBvvF0+C6wbGiqWJ6sK89Fz4tOFY0hk8J
9m314BODfXB9uEbwXJYemBO8LqUBPgpel4qtc4P9h/TD7GCd+yz8RLAmUFx+
P9dL0h6Dg9eEdMW7wWta8fo9uG9qLTEx2A9Jl04I9mHSe9PhIczv8zj+LFpH
309/73yO9YA7B/sV6f+pwbpvhOZJsF+U5nw7WJ92hzsF+znp7Wlw/9Rxf0aw
P5sOjw/W1y/LzwTryjfgEZqTGl+4fHB8OxYuh22ReXykQaTfB8OPBMecGnBV
7F/Bc+OkfK1pvp0JHwNfCDcO1ggXwGcF6/pu8HXBuc5N8PXBvnM8PCo4JkyD
xwXnIq8rVuba701ppFwTviL/E5xzSB/2h5um1rR9g2POBPj14Fg0EX4D7g1P
gt/UN8r8rKliKX0bab8lHhPlZf/Sfg/2z/8lvla/Oyw4Pk+Gx8AtuX51sA/v
mz/nKxz3gV9TXIPvgkfKD8N3wq8qpsAD4CnwWPg2+EX46WCt9yE8C27F/dcE
+9v76R9N/6scd6V/N/ZN+rvBe+DRcHfFJHhM9HzQ+47m+Eb6d2HfoL8t/Etw
zJXuGMM5rwXrgrHwSLg15/wUrA+lIz6j/8Ngnap18UGwvtR8mxmsm+Q3esGX
wr3gHsHx6m749uB4dRd8W7AevAe+I1hH3A53D9YRd8A3Ba8VrYsbgmPabXA3
eDnPVovjYtjm2D7096T/W44r5t9UumYm/ZPp/5XjM+V3Uq9rrdNJwbpmFjwF
7gm/AD8F3wo/Dw8Njqt3wrfmc6w3fAt8CzwMflJzkvtvw77OWL2cOedZAveA
99H/FtwZ3gqPgtfKL3NtAezP4f9hNwnYggWs76XztwfroiODv9URcNS76Dy4
EHY9rRBcJPerJ2GqBc8Lxdziwdq2Jnxc8DzlMPkn8bflZ5LDiZ9dOifDbqIV
g0tj/wiO9UnwHJREOKT1wIUDudGp2I30F6XvqOD3U06RYjfQCsPFsL/RisAl
gnV3Lbh6sMavDR8frM3rwCfA12S+Xjq5Y/4bL8PXZr7XCPi6zM/6Ctwm8zhK
p3XIPC7SG+0zj5f0z/WZ32ck3Cnz2n4tek7cwO92yH2a/GGF4LzqOPgY7H7l
GJx3cuZ87nj6K2H/pZ0AVw7O7arDFbF7aZXgMsFrsSJcKnguVIbLBq9FabOi
wWtXeUFJ+b3M14/l2d7InCf/CD+fz/Vv4VGZ8/Zl8A7OPZFrq2C3Y3fLh9G6
5HNoF+f8xfEu2g+0OfSvo39HdF1kFX1LgmsVK+HF8KDoHF/1kE9S6xblPl/C
5RLnHbqf7ruZ9nf+u7/SPk7tP+VHy+bvO5m+Ranji/KjJanHWeO9GK6aODeR
Nlyj5wzW4D/By4LrLivgRcF1HeVWX8Gf8XxFOT4YXddRzvJ17qO+h78JzmvX
wSv1ztg/aOs15/Mx2ZS4tqQc6svgnGAtvCK4zqR86ovgvOEX+MfgfOJneHlw
zelHeCE8l+c5pO8fXTdaTv8Cjt/MXJdZEZ1DKM+aH/z7m/Nn+DNxHNqaj6XG
9Pe870Di+LQ+j6fKhbek1n7SgP1zPalc79c8Fku7rUqtP5Xbrkmtl5RTr0yt
weQMVqfWtMqFH4keN41f72ifr9zwi9RzXr7rj9R6Vbl233yeKA7cqZw5cZ64
IdcAysF7RccL+d1lqTWt6iEdomOT4uo10fF0rdZ4dExch22X2Vdqrko/67up
Xqr5q3lYMB/Dvfnc1vfdY3f1/zHcl8/Jnfn4lqC9lrlupRrUOXrnxLXNc6P1
g7Re5+gYoXh+Q3Qc+RXbJTpeKE+/JTpGK0//ifOaJK4t6Bn25/Ps5uj4qDh8
o3KnxHn3/NR+Q/Fibz4Pt+XX7ciff3P+jfR9N6XW2KoNbkytjZWLrUutwfSt
f06tgVWLWJHHAn3ftan1sOoGP6bWb6pF/Cb/nbi+oTV0EdwkuIakMbkPrhcd
7xT3+mTOSbTWnssc41Vr6pc59yiWx+QunH+N/DzntUpcF12e2kep1vELXDdx
/WQ7fHbi3HNHam2voLQtdS6g+vbO1PmL6tv7UucpBfI4r/s3l4/Nn1+18V35
/Jcm3Zs6x1H9fH/q3Ee1btUhVBP7RD4cvjxxnfxAvqZUJ/8ndW6iOvl/qfMa
1WkPpc4xVZdWLfMZeBD3OZw6x1SNV4FS+ZHypH35XJRvPj1a86tOXlNzKHEt
XXNaPvMg7el8DU5NPZc1HzbIF0Tr01ex27Qm5Sui9xOWwd8pXnNcJT9Hfkjf
92TsJM4pDh8dfF/d/9vg++r+Wldvp9YGE/nzXua4otixNV8/+u3puS+dlvqd
5J+25P5pZ76+emaOi/KBAzLHV2mv8tFzQ3XXLDqvV53/yOj8WjlQgehcXrX3
ovIFifcLCkfn5qrHxug6gGrsxaNzTO0jHBFdE9AeSsnofFN12lLR+bLqt8dE
5/6qzVaKzvFV760SnZtUynWi5vzNiv/ReYrq7WfI3yXeyygTnQur3ntsdC6m
Orzypikaa3Rc2WhdofdvDb8F/4I9KlrHqqZaOlr3qj7ZlvZS4jpSwWjdqzEp
BN+cuL5aIro2ohrs0dE6WbW46tFaWrWXitF6VbWjatHaW3WYytE6WfWlctH6
XLWgqtGaXLWgItE1GdV+P0qtYaS7tsLNE9dmL4rOU6RJFkoTJda350fr4R+w
F0Zr6eXYC6K1tLTKxbThieNg0+h8Svlcrei6tGpiqgONgocz/r+nzv1V730r
c91fNaLvUutG5TgLUutG6aVLonNV7SU1i86zVmIvpT2ReA9lT+o6iWrXqsNs
yddau+gcWXXLKZlzNum99vlzKk5dF52T1svX7Pp8vXSNzmEb5jpxqsaE/8/I
nONJJ3ePzklVz+wGj0tcP7wpOj9VzbNHdExUvOgYPQ6qkV4fnVcqHrWJrgmo
pvp5as0pTXtQcTRx7f2y6LxYY7s7tS+SPwz5nJRf+jt1nUp1+HmpdZq09NzU
elUaW+OyJV/v8jPSKZrf8kXSdJWY552i6wmqu/aMzt9VP6yQxw6tp6ui6yfK
45U3aO/jHcbn5Og9KdWQp2bObxVnX8m8d/U9/G3qfEG5be3ovSTVQutE722p
znlr9JirDtwwej9LOvmU6D0m1UuXpq6taa9kUuY8XHqjUfSel+qoV0T7c+2B
jsy8r6b5/H0eZ6VXP02tXaVvx2ber1qtNR1db1G9dHTmPS3NvbrRe2SqjU/O
XBeQtvksdX6hHKRB9P6d6revZt6rWwqfl4+bNMk3qfM45fv1o7WK4vLXeaxX
Xj8xcx1BfmZM5n24VXCT6D01jee4zLnrGrhldO7/E7Z5dL1C518eXa/Qe51G
G5R4T+Ss6H067df8kLrmqf2sCZnz55+1PjLvI2rtt4quJ6i/cfSeoPLis6P3
7/SOV0bX3LTX2SK6vqFnuzqf85ozp0bvaWr/aHzm/FzP/D+cl+Wm
           "]], Polygon3DBox[CompressedData["
1:eJwtmmXAVUUXRs/MXEJUBBQBG7uxO7C7sBMURQUVW0ARA7sAC7EbMLFFxQ7s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           "]], Polygon3DBox[CompressedData["
1:eJwt13e4FNUVAPB9uwuKgqiohKKIFCM1dEOVbmhKT2hGqpGmUiRSLFQVBBWB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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0jkvBVEYgOGxr9cS0RINUVCKglIUVCIKOqKgIBEFpULodPwCWiL0Ejr7
cu1rRMTW2NfwnETxznMy92TmO5lb0t7b1JMQRdGwXhXWj7rUbGIU5XGBxVxn
JU9Zywc28pttzE6Kopi6rcs5yGqOsp4TbOEUOznPfi7xntd817aewz0tG2iH
K4xzlbtc416Yifvc4AE3uaXD8BwecYfHjPOEuzzlHs+4z3NOO8cNP3Shl3BG
jZlti0NcZB/n2MFJNnOcdRxhFQdYxlJ1WWewlZ/e0cA71vCYFeFcLOKtfVd8
U66ewl4VmjGHBYwxn9lhD7MYYyazmBHex3SmMkVp1klMDd843OOvkvUTftOX
jBHNuNz+/x/+AMQfSu8=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{690, 1000, 473, 689, 1106, 912, 691, 1107, 913, 692, 1108, 
        914, 693, 1109, 915, 694, 1110, 916, 695, 1111, 1006, 1206, 696, 1112,
         917, 697, 1113, 918, 698, 1114, 919, 699, 1115, 920, 700, 1116, 921, 
        701, 1117, 922, 702, 1308, 1001, 923, 1002},
        VertexColors->None], 
       Line3DBox[{704, 1007, 1207, 703, 488, 705, 1118, 924, 706, 1119, 925, 
        707, 1120, 926, 708, 1121, 927, 709, 1122, 1008, 1208, 710, 1009, 
        1209, 711, 1123, 928, 712, 1124, 929, 713, 1125, 930, 714, 1126, 931, 
        715, 1127, 932, 716, 1128, 933, 717},
        VertexColors->None], 
       Line3DBox[{719, 1010, 1210, 718, 1011, 1211, 720, 504, 721, 1129, 934, 
        722, 1130, 935, 723, 1131, 936, 724, 1132, 1012, 1212, 725, 1013, 
        1213, 726, 1014, 1214, 727, 512, 728, 1133, 937, 729, 1134, 938, 730, 
        1135, 939, 731, 1136, 940, 732},
        VertexColors->None], 
       Line3DBox[{734, 1015, 1215, 733, 1016, 1216, 735, 1017, 1217, 736, 520,
         737, 1137, 941, 738, 1138, 942, 739, 1139, 1018, 1218, 740, 1019, 
        1219, 741, 1020, 1220, 742, 1021, 1221, 743, 528, 744, 1140, 943, 745,
         1141, 944, 746, 1142, 945, 747},
        VertexColors->None], 
       Line3DBox[{749, 1022, 1222, 748, 1023, 1223, 750, 1024, 1224, 751, 
        1025, 1225, 752, 536, 753, 1143, 946, 754, 1144, 1026, 1226, 755, 
        1027, 1227, 756, 1028, 1228, 757, 1029, 1229, 758, 1030, 1230, 759, 
        1031, 1231, 760, 1145, 947, 761, 1146, 948, 762},
        VertexColors->None], 
       Line3DBox[{764, 1032, 1232, 763, 1033, 1233, 765, 1034, 1234, 766, 
        1035, 1235, 767, 1036, 1236, 768, 552, 769, 1147, 1037, 1237, 770, 
        1038, 1238, 771, 1039, 1239, 772, 1040, 1240, 773, 1041, 1241, 774, 
        1042, 1242, 775, 560, 776, 1148, 949, 777},
        VertexColors->None], 
       Line3DBox[{781, 1149, 950, 779, 1150, 951, 783, 1151, 952, 785, 1152, 
        953, 787, 1153, 954, 789, 1154, 955, 791, 1155, 569, 793, 1156, 956, 
        795, 1157, 957, 797, 1158, 958, 799, 1159, 959, 801, 1160, 960, 803, 
        1161, 961, 805, 1163, 963, 807},
        VertexColors->None], 
       Line3DBox[{806, 962, 1162, 804, 1255, 1054, 802, 1254, 1053, 800, 1253,
         1052, 798, 1252, 1051, 796, 1251, 1050, 794, 1250, 1049, 792, 1249, 
        568, 790, 1248, 1048, 788, 1247, 1047, 786, 1246, 1046, 784, 1245, 
        1045, 782, 1244, 1044, 778, 1243, 1043, 780},
        VertexColors->None], 
       Line3DBox[{809, 1055, 1256, 808, 1164, 964, 810, 1165, 965, 811, 1166, 
        966, 812, 1167, 967, 813, 1168, 968, 814, 1169, 1056, 1257, 815, 585, 
        816, 1170, 969, 817, 1171, 970, 818, 1172, 971, 819, 1173, 972, 820, 
        1174, 973, 821, 1175, 974, 822},
        VertexColors->None], 
       Line3DBox[{824, 1057, 1258, 823, 1058, 1259, 825, 1176, 975, 826, 1177,
         976, 827, 1178, 977, 828, 1179, 978, 829, 1180, 1059, 1260, 830, 
        1060, 1261, 831, 601, 832, 1181, 979, 833, 1182, 980, 834, 1183, 981, 
        835, 1184, 982, 836, 1185, 983, 837},
        VertexColors->None], 
       Line3DBox[{839, 1061, 1262, 838, 1062, 1263, 840, 609, 841, 1186, 984, 
        842, 1187, 985, 843, 1188, 986, 844, 1189, 1063, 1264, 845, 1064, 
        1265, 846, 1065, 1266, 847, 617, 848, 1190, 987, 849, 1191, 988, 850, 
        1192, 989, 851, 1193, 990, 852},
        VertexColors->None], 
       Line3DBox[{854, 1066, 1267, 853, 1067, 1268, 855, 1068, 1269, 856, 625,
         857, 1194, 991, 858, 1195, 992, 859, 1196, 1069, 1270, 860, 1070, 
        1271, 861, 1071, 1272, 862, 1072, 1273, 863, 633, 864, 1197, 993, 865,
         1198, 994, 866, 1199, 995, 867},
        VertexColors->None], 
       Line3DBox[{869, 1073, 1274, 868, 1074, 1275, 870, 1075, 1276, 871, 
        1076, 1277, 872, 641, 873, 1200, 996, 874, 1201, 1077, 1278, 875, 
        1078, 1279, 876, 1079, 1280, 877, 1080, 1281, 878, 1081, 1282, 879, 
        649, 880, 1202, 997, 881, 1203, 998, 882},
        VertexColors->None], 
       Line3DBox[{884, 1082, 1283, 883, 1083, 1284, 885, 1084, 1285, 886, 
        1085, 1286, 887, 1086, 1287, 888, 657, 889, 1204, 1087, 1288, 890, 
        1088, 1289, 891, 1089, 1290, 892, 1090, 1291, 893, 1091, 1292, 894, 
        1092, 1293, 895, 665, 896, 1205, 999, 897},
        VertexColors->None], 
       Line3DBox[{911, 1005, 685, 910, 1307, 1104, 909, 1306, 1103, 908, 1305,
         1102, 907, 1304, 1101, 906, 1303, 1100, 905, 1302, 1099, 904, 1301, 
        1300, 1098, 903, 1299, 1097, 902, 1298, 1096, 901, 1297, 1095, 900, 
        1296, 1094, 899, 1295, 1093, 898, 1105, 1294, 1003, 1004},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 474, 1106, 252, 488, 280, 1211, 503, 295, 1216, 518, 
        310, 1223, 533, 325, 1233, 548, 340, 1244, 563, 1150, 355, 578, 1164, 
        370, 1259, 593, 385, 1263, 608, 400, 1268, 623, 415, 1275, 638, 430, 
        1284, 653, 445, 1295, 668, 460},
        VertexColors->None], 
       Line3DBox[{253, 475, 1107, 254, 489, 1118, 281, 504, 296, 1217, 519, 
        311, 1224, 534, 326, 1234, 549, 341, 1245, 564, 1151, 356, 579, 1165, 
        371, 594, 1176, 386, 609, 401, 1269, 624, 416, 1276, 639, 431, 1285, 
        654, 446, 1296, 669, 461},
        VertexColors->None], 
       Line3DBox[{255, 476, 1108, 256, 490, 1119, 282, 505, 1129, 297, 520, 
        312, 1225, 535, 327, 1235, 550, 342, 1246, 565, 1152, 357, 580, 1166, 
        372, 595, 1177, 387, 610, 1186, 402, 625, 417, 1277, 640, 432, 1286, 
        655, 447, 1297, 670, 462},
        VertexColors->None], 
       Line3DBox[{257, 477, 1109, 258, 491, 1120, 283, 506, 1130, 298, 521, 
        1137, 313, 536, 328, 1236, 551, 343, 1247, 566, 1153, 358, 581, 1167, 
        373, 596, 1178, 388, 611, 1187, 403, 626, 1194, 418, 641, 433, 1287, 
        656, 448, 1298, 671, 463},
        VertexColors->None], 
       Line3DBox[{259, 478, 1110, 260, 492, 1121, 284, 507, 1131, 299, 522, 
        1138, 314, 537, 1143, 329, 552, 344, 1248, 567, 1154, 359, 582, 1168, 
        374, 597, 1179, 389, 612, 1188, 404, 627, 1195, 419, 642, 1200, 434, 
        657, 449, 1299, 672, 464},
        VertexColors->None], 
       Line3DBox[{261, 479, 1111, 263, 493, 1122, 285, 508, 1132, 300, 523, 
        1139, 315, 538, 1144, 330, 553, 1147, 345, 568, 1155, 360, 583, 1169, 
        375, 598, 1180, 390, 613, 1189, 405, 628, 1196, 420, 643, 1201, 435, 
        658, 1204, 450, 1300, 673, 465},
        VertexColors->None], 
       Line3DBox[{265, 481, 1112, 266, 1209, 495, 287, 1213, 510, 302, 1219, 
        525, 317, 1227, 540, 332, 1238, 555, 347, 1250, 570, 1156, 362, 585, 
        377, 1261, 600, 392, 1265, 615, 407, 1271, 630, 422, 1279, 645, 437, 
        1289, 660, 452, 1302, 675, 467},
        VertexColors->None], 
       Line3DBox[{267, 482, 1113, 268, 496, 1123, 288, 1214, 511, 303, 1220, 
        526, 318, 1228, 541, 333, 1239, 556, 348, 1251, 571, 1157, 363, 586, 
        1170, 378, 601, 393, 1266, 616, 408, 1272, 631, 423, 1280, 646, 438, 
        1290, 661, 453, 1303, 676, 468},
        VertexColors->None], 
       Line3DBox[{269, 483, 1114, 270, 497, 1124, 289, 512, 304, 1221, 527, 
        319, 1229, 542, 334, 1240, 557, 349, 1252, 572, 1158, 364, 587, 1171, 
        379, 602, 1181, 394, 617, 409, 1273, 632, 424, 1281, 647, 439, 1291, 
        662, 454, 1304, 677, 469},
        VertexColors->None], 
       Line3DBox[{271, 484, 1115, 272, 498, 1125, 290, 513, 1133, 305, 528, 
        320, 1230, 543, 335, 1241, 558, 350, 1253, 573, 1159, 365, 588, 1172, 
        380, 603, 1182, 395, 618, 1190, 410, 633, 425, 1282, 648, 440, 1292, 
        663, 455, 1305, 678, 470},
        VertexColors->None], 
       Line3DBox[{273, 485, 1116, 274, 499, 1126, 291, 514, 1134, 306, 529, 
        1140, 321, 1231, 544, 336, 1242, 559, 351, 1254, 574, 1160, 366, 589, 
        1173, 381, 604, 1183, 396, 619, 1191, 411, 634, 1197, 426, 649, 441, 
        1293, 664, 456, 1306, 679, 471},
        VertexColors->None], 
       Line3DBox[{275, 486, 1117, 276, 500, 1127, 292, 515, 1135, 307, 530, 
        1141, 322, 545, 1145, 337, 560, 352, 1255, 575, 1161, 367, 590, 1174, 
        382, 605, 1184, 397, 620, 1192, 412, 635, 1198, 427, 650, 1202, 442, 
        665, 457, 1307, 680, 472},
        VertexColors->None], 
       Line3DBox[{277, 682, 1308, 683, 278, 501, 1128, 293, 516, 1136, 308, 
        531, 1142, 323, 546, 1146, 338, 561, 1148, 353, 576, 1162, 1163, 368, 
        591, 1175, 383, 606, 1185, 398, 621, 1193, 413, 636, 1199, 428, 651, 
        1203, 443, 666, 1205, 458, 685, 686, 687},
        VertexColors->None], 
       Line3DBox[{459, 667, 684, 1294, 444, 652, 1283, 429, 637, 1274, 414, 
        622, 1267, 399, 607, 1262, 384, 592, 1258, 369, 577, 1256, 354, 1149, 
        562, 1243, 339, 547, 1232, 324, 532, 1222, 309, 517, 1215, 294, 502, 
        1210, 279, 487, 1207, 250, 473, 681, 688},
        VertexColors->None], 
       Line3DBox[{466, 674, 1301, 451, 659, 1288, 436, 644, 1278, 421, 629, 
        1270, 406, 614, 1264, 391, 599, 1260, 376, 584, 1257, 361, 569, 1249, 
        346, 554, 1237, 331, 539, 1226, 316, 524, 1218, 301, 509, 1212, 286, 
        494, 1208, 264, 480, 1206, 262},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzFmnlcztu3x0sSkTLLnOFwOEWDioZV5EREKFKZ60THdDooijInZYzK2KxR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     "],
    VertexNormals->CompressedData["
1:eJx0nHVYFV339xE7sRARFRW7sAVEFgYmJjaKIiCgooAotoCUhJRIiaQ00iWx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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2}]], "Output",
 CellChangeTimes->{{3.8062590823037868`*^9, 3.8062590981303883`*^9}, 
   3.8062591758524275`*^9, 3.80625923597591*^9, 3.8062594837336607`*^9, 
   3.8062598372447433`*^9, 3.806260097497178*^9, 3.8062602689138536`*^9, 
   3.8062607220794234`*^9, 3.8062607798769646`*^9, 3.8062608368125277`*^9, 
   3.8062613176603985`*^9, 3.8062615864156184`*^9, 3.8062616166148567`*^9, 
   3.80626193846017*^9, 3.806262929080475*^9, 3.806263056092271*^9, 
   3.8062632264069753`*^9, 3.806293192531146*^9, {3.8062932875496683`*^9, 
   3.806293314471966*^9}, 3.806294637966442*^9, 3.806295198773814*^9, 
   3.8062953425930624`*^9, 3.8062954381165714`*^9, 3.806295660268776*^9, 
   3.8062958165037003`*^9, 3.8062960602323427`*^9, 3.806296308199875*^9, 
   3.8062965249092236`*^9, 3.806296575238909*^9, 3.806296738092661*^9, 
   3.806296833346176*^9, 3.806297026742131*^9, 3.80629782687426*^9, 
   3.806298381844784*^9, 3.806298706676035*^9, 3.806298772494319*^9, 
   3.8062990540669746`*^9, 3.8064204982945185`*^9, 3.8064209368437247`*^9, 
   3.806421038144055*^9, 3.806421353855109*^9, 3.8064215021916313`*^9, 
   3.8064218542299924`*^9, 3.8064219396031685`*^9, 3.806422347249019*^9, 
   3.8064226001876774`*^9, 3.8064227229673443`*^9, 3.806422931664608*^9, 
   3.8064230663851457`*^9, 3.8064232383076167`*^9, 3.806423535464188*^9, 
   3.8064244686592984`*^9, 3.8064245333883944`*^9, 3.806424636757181*^9, 
   3.8064249167708683`*^9, 3.8064250414645543`*^9, 3.8064268261470747`*^9, 
   3.806426918806096*^9, 3.806427208869408*^9, 3.8064281277844543`*^9, 
   3.8064630641685715`*^9, 3.806463474405262*^9, 3.8064636109600744`*^9, 
   3.806463665161723*^9, 3.8064644045669317`*^9, 3.8064645771711707`*^9, 
   3.8064708509402885`*^9, 3.806472353676381*^9, 3.8064726221063857`*^9, 
   3.806473773297595*^9, 3.806474947241291*^9, 3.8064752040589037`*^9, 
   3.806476761558728*^9, 3.806477121066829*^9, 3.806484255149258*^9, 
   3.8064845612268324`*^9, 3.806484985092987*^9, 3.8064854962690134`*^9, 
   3.806486160981949*^9, 3.8066717412328653`*^9, 3.80667180468855*^9, 
   3.8066826810541344`*^9, 3.8066829252444158`*^9, 3.8067169571438203`*^9, 
   3.8067172252458334`*^9, 3.8067179467246037`*^9, 3.8067194944947805`*^9, 
   3.8067196457291946`*^9, 3.8067611816049814`*^9, 3.806820147544272*^9, 
   3.8068204491660433`*^9, 3.807293763067728*^9, 3.8072939061262474`*^9, 
   3.807294871513759*^9, 3.8072951097259617`*^9, 3.807297157682315*^9, 
   3.8073210915331397`*^9, 3.80732323328399*^9, 3.8073245309906073`*^9, 
   3.8073248385602283`*^9, 3.807345830802204*^9, 3.8075803864434385`*^9, 
   3.807580468257147*^9, 3.8075806339629855`*^9, 3.807580678774136*^9, 
   3.8075809354930363`*^9, 3.8075812038093295`*^9, 3.807581320048287*^9, 
   3.8075813775999346`*^9, 3.80758146423903*^9, 3.807581549127282*^9, 
   3.8075815806572886`*^9, 3.80758197001503*^9, 3.8075820518548403`*^9, 
   3.80758212135834*^9, 3.807582210418275*^9, 3.8075823856336403`*^9, 
   3.807582544310808*^9, 3.807582655651515*^9, 3.807582801673309*^9, 
   3.807582952555792*^9, 3.8075830819757385`*^9, 3.8075831396827393`*^9, 
   3.807583351712691*^9, 3.8075834169995265`*^9, 3.8075834852780714`*^9, 
   3.8075835583190174`*^9, {3.80758370356993*^9, 3.807583719498537*^9}, 
   3.807583802906995*^9, 3.807583867011763*^9, 3.8075839748087587`*^9, {
   3.807584041692263*^9, 3.807584061761818*^9}, {3.807584142417838*^9, 
   3.8075841616043186`*^9}, {3.80758431361432*^9, 3.80758433347383*^9}, 
   3.8075844122307515`*^9, 3.807584710881852*^9, 3.8075847878181515`*^9, {
   3.8075848188327503`*^9, 3.807584848186865*^9}, 3.807584940044697*^9, 
   3.8075850293461995`*^9, 3.8075851397366233`*^9, 3.8075853610442142`*^9, 
   3.8075854414340563`*^9, 3.8075872665406756`*^9, 3.807587837725031*^9, 
   3.8075879415974426`*^9, 3.8075880149843636`*^9, 3.8075881212692966`*^9, 
   3.8075882507989025`*^9, 3.807688729312798*^9, 3.807688774587732*^9, 
   3.8076899503652773`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N3 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", "\[Eta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", "\[Xi]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Xi]"}], ")"}]}]}],
  SequenceForm[
  "N3 = ", Rational[1, 4] $CellContext`\[Eta] (
    1 + $CellContext`\[Eta]) $CellContext`\[Xi] (1 + $CellContext`\[Xi])],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8062590823057947`*^9, 3.806259097973392*^9}, 
   3.806259175696431*^9, 3.806259235818915*^9, 3.8062594835796647`*^9, 
   3.806259837088747*^9, 3.806260097339182*^9, 3.8062602687588577`*^9, 
   3.806260721922427*^9, 3.806260779722968*^9, 3.806260836658532*^9, 
   3.8062613175034027`*^9, 3.8062615862506227`*^9, 3.806261616459861*^9, 
   3.8062619382921762`*^9, 3.8062629289174805`*^9, 3.806263055915275*^9, 
   3.8062632262409806`*^9, 3.8062931923931503`*^9, {3.806293287398672*^9, 
   3.80629331432297*^9}, 3.8062946378074465`*^9, 3.806295198613818*^9, 
   3.806295342435067*^9, 3.806295437953574*^9, 3.80629566011378*^9, 
   3.8062958163467045`*^9, 3.8062960600773478`*^9, 3.8062963080458784`*^9, 
   3.8062965247542257`*^9, 3.8062965750749135`*^9, 3.8062967379346647`*^9, 
   3.80629683319018*^9, 3.806297026586136*^9, 3.8062978267092657`*^9, 
   3.8062983816677885`*^9, 3.806298706519038*^9, 3.8062987723383217`*^9, 
   3.8062990539069767`*^9, 3.8064204980627546`*^9, 3.8064209366744537`*^9, 
   3.806421037896655*^9, 3.8064213537014556`*^9, 3.8064215020288677`*^9, 
   3.806421854082852*^9, 3.806421939465147*^9, 3.8064223470867105`*^9, 
   3.8064226000405397`*^9, 3.8064227228136964`*^9, 3.80642293151746*^9, 
   3.806423066237996*^9, 3.806423238144845*^9, 3.8064235353105392`*^9, 
   3.806424468405384*^9, 3.8064245332407374`*^9, 3.8064246366001854`*^9, 
   3.806424916616871*^9, 3.806425041332559*^9, 3.8064268259520807`*^9, 
   3.8064269186331015`*^9, 3.806427208709411*^9, 3.80642812760346*^9, 
   3.8064630639345775`*^9, 3.8064634742472663`*^9, 3.8064636107950788`*^9, 
   3.806463664980728*^9, 3.8064644043976526`*^9, 3.80646457698627*^9, 
   3.806470850690292*^9, 3.806472353520133*^9, 3.806472621950137*^9, 
   3.806473773141345*^9, 3.806474947085039*^9, 3.8064752039026546`*^9, 
   3.8064767614024787`*^9, 3.806477120910578*^9, 3.8064842549002633`*^9, 
   3.8064845610688353`*^9, 3.8064849849319906`*^9, 3.8064854960870185`*^9, 
   3.8064861608239517`*^9, 3.806671740998494*^9, 3.806671804532303*^9, 
   3.8066826808041406`*^9, 3.8066829250504217`*^9, 3.806716956923764*^9, 
   3.8067172250921783`*^9, 3.8067179465618305`*^9, 3.8067194943217845`*^9, 
   3.806719645560199*^9, 3.806761181351988*^9, 3.8068201473682756`*^9, 
   3.806820448998047*^9, 3.8072937628997307`*^9, 3.8072939059642496`*^9, 
   3.807294871351761*^9, 3.8072951095419683`*^9, 3.8072971575153203`*^9, 
   3.807321091379052*^9, 3.8073232331147118`*^9, 3.807324530812215*^9, 
   3.8073248383974667`*^9, 3.807345830590127*^9, 3.807580386193572*^9, 
   3.807580468103498*^9, 3.8075806338093395`*^9, 3.807580678627002*^9, 
   3.807580935339381*^9, 3.807581203655674*^9, 3.8075813198791003`*^9, 
   3.807581377446286*^9, 3.8075814640853834`*^9, 3.807581548973415*^9, 
   3.8075815804945197`*^9, 3.8075819698678913`*^9, 3.8075820517011924`*^9, 
   3.807582121220319*^9, 3.8075822102646217`*^9, 3.807582385486492*^9, 
   3.8075825442417965`*^9, 3.807582655582506*^9, 3.8075828016042333`*^9, 
   3.8075829525023985`*^9, 3.8075830819067245`*^9, 3.8075831396137285`*^9, 
   3.8075833516426926`*^9, 3.807583416927528*^9, 3.8075834852050734`*^9, 
   3.8075835582480187`*^9, {3.8075837035019307`*^9, 3.807583719427539*^9}, 
   3.807583802836999*^9, 3.807583866939765*^9, 3.8075839747357597`*^9, {
   3.8075840416212654`*^9, 3.8075840616927977`*^9}, {3.8075841423332024`*^9, 
   3.807584161521321*^9}, {3.807584313544323*^9, 3.807584333401832*^9}, 
   3.807584412152753*^9, 3.8075847108037214`*^9, 3.807584787749139*^9, {
   3.8075848187481155`*^9, 3.8075848481178546`*^9}, 3.807584939975685*^9, 
   3.8075850292615614`*^9, 3.807585139667612*^9, 3.8075853609595833`*^9, 
   3.807585441355931*^9, 3.8075872664560413`*^9, 3.807587837656022*^9, 
   3.8075879415284233`*^9, 3.8075880149153547`*^9, 3.807588121201116*^9, 
   3.807588250729895*^9, 3.8076887292188005`*^9, 3.807688774501734*^9, 
   3.807689950372278*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnXmcjeX7x63ZCikSk6XsyZIkS3MnZMvyRZEoy4iyZBAzyC77NowJ85Wx
y74zpnkYk2UkDCHD0MgylpSRskx+c+Zc7+uc5/bt9fr557zm7fac63zO/dzP
dV/X5x6lu33epke2LFmyBOTMkiV7xmvpcy02P3p0y+G1Xvt9dd66f7feJ4M2
zNvW97rya18e+KnTgVcDv833zKi+SZeVdy/6ce5bLUzgb4u/+KRM0xTlk1M3
Z+904O3AHpnXSVKe/n5w6ocZ3Ds+UXmxVUc++02vE6c8OL7KkQ8z3jeL/IHL
j6NkvIHXXhqTrWy+2rFyfeUl5oyNnFT53ViJR/mjlO0rBwxtL+NTlKftzN1r
Va2usfJ5lX8UWH7xgKE9Y0Uf5XtHbM8WPr5frPysfMZ3ZxtOrDwQ7qArevIz
r/evz2qSf2s/g87wXSlHe1yYG2rQGR42+4U/ntw6wqAzfELuqvs8HJ3hs+vn
vHRerxOnfMiXby14MuN90Rlu6wyPGpqUfXPIIAed9fpF7310MNcEB53hv+ae
dah89dkOOuv7tnut8N2ykQ46w8fVqrGvfPUlxKe88ZrZRYulrWR+KP9q4q6s
iR3W67xBP+Yn4+Doyc+87j1xN6pA2/GqMzx48fzG5+dOUp3hvc4cf8nD0Rm+
fPji133XiVPeudBTWTz6ozPc1hl+uURwU1NgtOoM3/NpuSoePdEZfm1608i5
D79RneEhj2b+dXfQCtUZnnq2/ey5D9erzvBf18cUDE/YojrD88TfP9qhZLTq
jE7c7+gMny3zk38PHyB68jOvVZutmpdv63TVGZ5tT3Q/D0dn+PUnjuxL1uvE
KT9R64cG+TLeF53hts46/t2LJTaFjFOd4U0vde18IFeE6gxv+dHVO+Uy5ic6
w18t8vGZO2XXqM7witMm3ypXfbPqDH+/5visz6ftUJ3hC8eWXHK0g6M6o8c/
sn6iM5z7HZ3h7vmZojyr6MnPvD79hkc3n87wOSb3En+d4SXWnyvqrzPc1hn+
fOOG2fx1hif/U+VNf53hD5o8c8ZfZ/1c/XJs9tcZfm7I1hP+OsNDPlmSXNRP
Z9Uh+7tD/HXmcz8vzyP3fE7U9dM9nxOdFa77PUX5NZmf7vmc6IS79ExUvrxc
y0P5/dYNeGBI/ZHJfusG/H/P50Rnx1Nz0gL91g34uG3TDpfzWzfgf+dv/iDc
b92Av5B79Gj/dQNepvMHt8P91g140wbPrZzjt27Aq789qsXj60ac01+e726d
45zB8jxy6xyn66db5zgnUe53t85xzgsyP906x6mebp3jnJ7lbt3M6/cchP9v
neOcj+ovu7TR7zkIH1T0YcABv+cgfHmNQKec33MQ/t99q6bc8XsOwmd2u7Cz
nN9zEB4RsWdXUb/nILzrmJDmR/2eg1ncf0ZZz3Xl1nNIubVuKrfuc2t84r/w
uMd4ln/5g87/myc+xtH5f49PeYyjs83R2ebo/C+c+WPekPzTms+GfMmaz8b9
fNf5bI7L88iaz8ZaP5W773edz+ZjmZ//pqs1n83alfsPRjQfZqz5bN47e3pX
Xt/zQvmDKZ+/nTx3nrHmszkWld7q772LjTWfzYyExnWT564y1nw2xUtNCS64
eIOx5rPpNnrLSxcubTHW+mzI56312YRL/mmtzyZO8iVrfTbW8135BXkeWeuz
GS/rp7U+G+73f5un1vps3hc9rfXZvPTNkpwnG0VZOieaCm/kzhF9cI2lc6J5
Jmuh94YEbLV0TjQzRjx4sPNgjKVzomnYrMuwNtviLJ0TzfCoDS9GjtlvrHzD
ZLno3R9Z+Ya5KPm8lW8YK/9U3kLyJSvfMPddz3fNN8xfrueR5huG9fPf7nsr
3zAPXfNT8w1TXvS08g3z5uo32vVP3646wwMPRO7dEbHHWPmGSe0xtkX/9P3G
yjfMwipH9ydXPWKsfMNUmVX/+TERx635nGLYb1r5swlx74+Uh0o+b+XPprrk
n1b+bMiXrPzZBMjz3cqfzUJ5Hv3bOmrlz3q/W/mzKSTz08qfVU8rfzZznDof
f3H4oDWfU8w7AzfG7og4Zs3nFBO2MO+Mk8knrfmcYtb8srLUszFnjbUfNNb+
XflY2W9a+0HD/gid4eTz1n7QkH+iM5x8CZ3hs+T5/m/PJXSGs36is3K53639
oM5PdIGjp7UfNBGlfnynf/opY+0HzdXo55zkqueNtR80AaX3PzMm4qKx6huG
eohV3zDs3636hrkk+010hr8n+yOrvmGGSD6PznDyT3SGky/923MeneE8j9AZ
3kDWT6u+ofc7OsOZn1Z9w6SKnlZ9w1Taluv+2Ea/Gqu+YXr+/HeRiiGpqjN/
P1PqS1a9zlAPsep1Jq/s39EZzn7TqtcZ9kfoDH9V8nl0hneT/PPf8iZ0hneX
5zs6w3keWfU6U1XWT3SGc79b9Tqdn1a9zvRy66mvO+alPu95ja8wslzStpsO
rwfPnI+6nqON6g8fd69VWMEPygTKz/rvfmu/PKFpr4WqC3xehzI1Dtxf5FjX
N7fc45VHv7j16EsvB8da1zfZUtJzPliRqj/zPjM6hL5RZcUNfT+uN9aKE77T
fX2Nlzit+M1Muf7tMZf79E36zeG12vas6+b3qwHXv++Y682o3JtnOtZ486Gb
679r1fNR8PrNNzQ+/t35mDxf9yldOJBx/H3NilWXb6kwIJZxxPv2p4O+vhc1
S3/m310cVaN655a++LgO17fGOw3c19F4X3O/r+rP9b8s/WvMo0e+uu5PpaMS
+iR/Zn7uMXTfo0dX9HrfB+8cNrlyvUA446de6Vc4IdcQU/PbgkcfPbqo4ye+
k9L25IL6gXDG1z92oV7MweHmxcxx53V8w0Vhdz31Ijjjn2q5PMlTLzqT+b6n
dPyz+26W9VwfzvgbnZ0/dmVcv0zmuCM+PT6/sndSRvxwxp/PUnnkwYz4y2dy
X33l8vUm77X+vJrU87+Oce9Tc9dlPNf5se/pXL0zdGO8e//asF5x73idD+sK
9Oi2O7VmLJzxzfJ1WRKZGuyU8Map4yMbRP906O0msXDG76m/refNE2OdU14d
dPzSeYcG/3KnbSyc8RU75omq0nqmU9Krs47vvzooJuVOp1g449es6/b79NUR
zmve71HHz3/5xLktM7vHwhnfp8SVqIiMfPi0d57o+MEtm9ep++ansXDGb2l3
qOPSqKXOcO881PF9qgV9uyf081g44w+v2FH4mLPKYd7y3BiydFNEjqDBOm+1
zlzXky+N1fkJb1Xzy0+D0yfoPIT3Ddxe01OHZF7B32r/SyXPeOYPPGHkgyae
6zMf4EX65yuVPSMe5oO7btFa5wP8qbvjd68786V+7/DKaQnNv/9qpn6/8Htd
Hia+W22Bfo/wLy6eeTFq5xL9vuBjwh4cS1zxrX4v8CMl+u/qXH2j6g/vOSB+
4itfbFWdeQ6/+p/iC3snD1Wd4U3WnHomYz+rOis/dPF+9MGpqjN8Xs5Xx3nq
t+gMr/Nh3HrPeHSGv/LDnC8z9q2qM/z8hjZJn2bEg87uOlA71Rn++sUnkhak
jlad4TN/ujTpxonZqjP8Zvjsa6+0XqQ6wwOjl1yZtnqF6gz/rv1L9Tx5ODrD
a9TKM2hJ1BbVGf7CyB1/HnF2qs7kNSUjJof46ww/H7807YCfzlpXr7Q00V9n
+KThDT7w1xl+MXrMBH+d4eGZdQafzvC37u3Z6q+zu67m0xleI/bBHn+d4bkP
vNzPX2fdZ5+LP+6vM3xD0pR9/jrDLyd/VsBfZ/iYtGrt/XWG5xq645i/zuSJ
tQdnKe+/bsA3jJ/fw3/dgBdsG/t7f791A/7Wkutbkv3WDXi9wS9u6u+3bsCf
+KHb1XJ+6wa8btMP1mfzWzfcdcrW1nxOdNKfa1DJf92Az0uI/Dveb92AJzxV
ppn/ugE/1Hi2s8hv3YA/Kp/Y3H/dgDttrwT5rxvwMt3jAx5fN+KcXOfutent
l1fAB50LPn7AL3+A75sU9G20X54AD0lrVyWfXz4An1yswcfRfs99eHpmfWyI
pXOcs6h+9Zmf+j2v3XXfhpbOcU7Veb+vXOD3XIaPjg5uc8Pv+Qs/W+ZuzCt+
z1l4qfSBy6b5PU/hT32yKSXc77kJP7q+Q50lfs9HrX8M2rH2iN9zMIv1B51t
js42R2ebo7PN0dnm6GxzdLYJOtscnW2OzjZHZ5ujs83R2ebobHNrPpt27w3+
yZOnWfPZZJ1Wan3G/HSs+WzmDzudP2M9caz5bO4enF3QUye35rMJrx53NmN9
cKz5bH4L2n85b8b1rflsasn8RGe49+cmMdZ8NrM3Tz9aJmWIseazaTu/+BN1
gycbaz6bQ11ib9TbHW6s+Wx+6FkzuOeMb4w1n03R4NoT87ddZqz5bP7qWfdS
lTGrjTWfTYN3j/acXGmjsdZnE5t7YO+j5cZZOieaoNvDpp9sNMvSOdHcnbv6
evOIcEvnRFN4QJMWnjq5tT4bZ2ybzZ7x1vps7hw6+ILn+tb6bD4L7/T8kYx4
3DpTP+9i6Zxo9u3uHPRp8mRL50Tz5uTfP+7m/NfSOdHEj1g8rmHISkvnRBOW
f8rL3+7eaOmcaErPXNXWUwe21meTL35N9KDbsZbOiabSe802JLXaa6x8wxQ7
/EzW7IdmOla+YXr1LX41+mCkY+UbJibnx3Of/SfKsfINs/T4l1c8dUIr3zC9
S33W0zPeyjdM2dONK3uub+Ubpmbf969kzYgHnd31814xVr5hQueXHpotaK6x
8g2zoHi75uUTVhor3zBT/wwqXDtoi7HyDXPmhZ03+8/9zlj5huncoG3EufS9
xso3TOGvi9zIl3DQWPmGmfzO7OhfnjtqzecUM/XzPhG1or625nOKqdSs7cMh
Acus+ZxiVh/+z7Lw7t9a8znFtIjbuM9TJ7fyZ/NkhYFdPOOt/Nlc/yd8gOf6
Vv5sjkx77X7NjHjc85n6+SBrPqeYOTfTG4X2XmTN5xTzRM3Dk06/ssmazylm
U/RnW9pe/c6azynm6t7eT0ds+t6azymm2o+TrtVoc9iazymmaOz+V0elJlrz
OcXc+SSw/oj5p4y1HzQ/b+36MNuhRY61HzQzN+e/EH1wjWPtB82yp9vPevaf
jY61HzRjs5VK8dTJrf2g6Vq5WzfPeGs/aMaUqFvGc31rP2jefn9pStaMeNDZ
XT8PibH2g6b2seSB2YKWG2s/aOp+3aNh+YQdxtoPmt6NNxaoHRRvrP2geaPc
wEv95x421n7QNHwtZta59OPG2g+aShMu/Jov4Wdj7QfN1UbPbPvluQt2vcjs
6zK10PYTyxyrLmQG3fumQNttmxyr/mOaZa8z4Ur37Y5V5zGXWzz7u6dObtVz
zDs/V2nmGW/VbUzvZZPC22Rc36rDmFVBTZduzYgHnd3181ExVr3FVArZvC+y
+Fpj1VXMlgU7rz0K2G2s+om5/0a5l5uNSTBWncTc6hh6r1vd48aqh5hXJxWI
qp3+s7HqHibqeKWv2u29YKz6hpl5Ztl/T1//VXWmXjc9pvD0VntWO1ZdzhQd
l3Y2csx2x6q/mX27/rOlQffvHKvOZlrvrTnNUye36mlmy/xvenrGW3Uzc6f+
jAae61v1MVN8QJ63t/VdrTq76+fjYqx6l6nxx5slyzTdZKy6lmmSZ1iJjYHx
xqpfmRzPN5tbZcVRY9WpTJ/afwYcqnjaWPUo8/uAb56OaHvBWHUnU2XG7BOr
C1xSPXnt2GdVpV5NPtX9SPiPz11oEnbD6f7CiIgK1QfqfmTtsObZw8rcdD4r
8lWih6Mndei0iXVKFtjaT/cjZ3/a1LRM09+cb1oUSqpUvbvuR9KkTtv3UmiH
oltb6n4kb7ViM7f1fbze2NNVP8xdFz1HSPx2nZD4gwP+U/tUo9G6HyH+uHGj
eg5In6D7EeK/NyJp6l9lp+p+JEniH9H80QexB6fqfoT451WaNLJE2kTVcc+O
d5Zs63vFKTRqxQj/fTSvbQKzLYxMHa16/lFoXWqTsKtO7qOnvglPGKd65tn9
y5NhZVKd59pU/zEjH1Y9S/UtXC1pW6rTM6r3pp0Ro1XPN4o1bVum6TVnX839
qz0+K/RstX/44L5J1x6rx6521d98+7s4id+uv52R+G8/tbXssQ4zVE/iv7Z2
+MW2rb5WPYn/9p41/b7/apHqSfx1W/zSOTxhqepJ/DP35OhcIWGl7u9aS/w7
rjh5pnVaozrnbL1qUt+kFOc1J3yWf13ohfSza7b1vei8UqTfmOxBX6nOvJb9
aF9Ai2pTVOcW7RumNQn71dm5sdKHf5adqjoH5QgpElbmkvN8vttZPPVPdB6+
cXXtpG2XnJCggccy9rmq8+yPzncq0/TxOuctV/3NV694QuK3628lJP7EGbWq
xvb01YWIf8K5/t3PV/1GdSb+xN/qP1uq0HLVmfgnTuo2/a+n1qrOxP/yW4u3
j6i7SXWeI/F3yJtnbKeAbarz7Mz76Kwz0aq/7c28X845b83Nds+//ua9L5Kd
KVs9eYWv/sZrKfGvovPKBWceNgm74Aw92n6xf/1td5P8pcLK/OIUefB6iH/9
7dSf9RskbfvlsTrnJ/9SfwuX+O36W7zEv3ulE+xffyP+eb1+/Nm//kb8HT+5
e9y//kb88ROyV/CvvxH/8L2te/vX305L/HkKBP7uX38LyPzejzt58nxVw3/d
eDfz+z3hTI91st484au/eb/Hn5zaJzekeupsxOe9r0867476Jbf/fOZ18h+R
c9/NmP/o7L1Pf3Z2flQlIVvG/YLO3vvxzGN1zt9d9TefziUkfrv+1kLi//7Y
gI5pab76G/HfnJjlxIFFkaoz8U+pkLA2Y7+sOv9MXt84vlLwXN98Jv4d16Y1
HROxWXWuLfHfyjryh0VFfTo3y4wn3vmifMHx/vU3b163z6lUonltz/qJznkz
r3/Qqb57TW3PeovOvTLn2yEn8NbCiv7r877MeXXYad5vz7k5Ges5Omu+NuOD
/RnzUHXekzlPjj1W5/zDVX/zrRstJX67/rZG4o8vvDhx2aTxqjPx78wRGe/x
X6Ez8R/6bGiDRk8vVJ2/l/jzJCydOzFpmepM/HG9Ny99vc461TlO4s918dBz
R8ptUZ0vZMYf5nTJ9AlnC3Tv7xY7IZk+4Zaqc7/MeFY7PxzO81b5jDwBne9k
jt/knMv0Cfvyig2Zn3ebE5Lp5xmo8fXJvM4u57Viwec9HJ15teuc7lffczDH
Em/81LvQ+W+Jv1emP7Od6txf4v+o0HeFTzYKVp2Jf22m/22s6rxO4i8b0OzU
johZqnNfif/C7KNFPHUAdK4s8a+RfB6dy0i8rST/cdcrdpkP1lX8LXluqD7/
lnnf12QvFbncw9H5qjdOUyjTpzpI14sO3s9lJj77Ud/kuZ/qPPZ+v4tNK9EB
fU94v3erXvh1zHVX/c1X5+TVrr91kfjrLUt50rP+o/NSif92v3zHwx/O0HyY
+A9l+tnCNB/uLPFfPvXFmoz5r/lwssT/ZKZfaKbuO+Ik/mqZ/pZxmid71/Nj
ZkKxsu/6199KMS8kL0Ln3d77yDzX48WiOzO+X3Tu5r3vzOI2rZdnvK/qnMN7
n5rWf875MGN9Vp2Xe+9r80nB397sOm2M6tzEuw48Vue84aq/+eqcsRK/XX/j
tV7q0+OH/neB6kz8sUNKN3zq/FLVmfif/HVtZt0SnXNK/DnDvmx/ceUG1Zn4
Cz19fXZM2ibV+R2Jv9+vOft80W+L6lzLu26bHsHNf8vmV3/L5V3nzdsti5T+
LHm+6ky8X0lehM4rvc8RE1k3Pne+rQtV51Dvc8dcGRcaFN59vursfS6cMId/
unfQs06ic3Hvc+2xOmeQq/7mq3PWlPjt+tsTEv+F7XurRI5ZoTrzeqbopvcy
8jHVmfgbnlyYWd9A56ESf9HDLY4kV3VUZ+J//sMB/f8bEac6F5P46y9ruKlX
o+9VZ8mjzJvrx4z2r7853rzFbL9QokZy+hLVeYU3zzGr3jjYqHDECtWZeD+Q
vAidf/fmUWZ5/7M75mTk+ei8x5t3mZSYbt/cfOIb1TnMm6c9Vue86aq/+eqc
JyV+u/4WK/FPDb3TfX+/jaov8SeOa/RTaPddqjOvEZNXxxe5HKc6/yHxz3um
cZ6F1Q6ozsS/OWnF6JF9D6vOsyT+iGqjHgysd0x1ln2B6fHS2Vv+9bdh3jzc
BPavsLHqmNWqc3dv3m5KHSi9dHnQBtW5uTfPN0NH315UcPEG1VnrhZIXobM3
n7xoopO/npEtaLnqLPumx+qcq1z1N1+dM0zit+tvQyX+F9s+/Crh1nbVmfgv
juwxMyYtTvUl/m6nRpYK756gOvNaZGWrA4EFjqnOxF8556HAuPQTqnMOiT/b
M8XfPnv1tOos+1yTM2BwDv/6m3c9uWbOXmv7vac+ic4lvftQszt69tnmEVtV
Z+86k2qO3CtypWShbb757N3nmrJl7mffkLBZdSZe8iLN67z76MfqnD1c9Tdf
nbOlxG/X316X+Df1Ch3VvqGjOhP/mYalA2IvHlCdiT+uwuWO+/sdU32J/8Uf
T/2zb8NJ1ZnXsQNLvHqy1FnVebfEf2t46Ny7x311TqnPmE+Co6KXt/LV3/DT
zZz44/lLW7epzme89RNTa1Cdd4d236U67xVfYqXIXjF3ysaozqu99Rlz7o3X
V27ovlN1nuOt55j4MaMm5Bm7WXWWuB6rc5Zy1d98dc48Er9dfyP+EudqVqi1
ba9vXZb4Wz99ctqe0UdUZ+IfNrxJXNZKJ1XnNRL/bw/qrrzy8KzqS/yfB/Q8
nF4gxdbTKTis7I57OV5V/fMJX/JGbL33eo3QPFBendpT9x7qNHa5Y9XxTE3h
1ngTUD/nd6UXXrKvb6YXjw57YVyqsfxmptq9Dh9fa3DNrrs6izsv2tQzqpqe
++Pv8UkyDs54fFRw/Gn4fuDVxU+FTwWO/wdfBRy/Cj4AeG7xV5Bv2r4A+qxw
+tf0BeEx0m+ljwUvLv1B+i7wKdLPok8APyP9F+racPoF6Mn9hI8UPeH4TtET
jq8PPeGNxYeGnnB8U+gJXy8+H/SE40tBP9tPgZ5w+v7oCe8ufWr0hNNXRU94
RekDah9LOH0r9NQ4pc/CPIbTF0Bn1if8t+pLFo5fF53hrcUnic7wxuLrQ2e9
jvjQ0Bn+tPim0Bm+X3w+6Gr7U9AZjo8CneH0/bV/LJw+NTrD10hfFZ11vyh9
QHSGN5e+FTrD6bOgM+s9vmV0huNzRmc4vlN0hn8tPkl0hk8WXx86w/GhoTM8
VHxT6Gr7fdAZ/pf4UtAZ/qz4KNAZvkz6/uis9WbpU6MznL4qOsOvSB8QneH0
rdCZ5yd+b3SG4w9HZzg+XnSG1xbfKTrD8UmiMxxfHzrDp4gPDV1t/xQ6w/H5
oDP8O/GlqC9BeB/xUaAz/Cnp+6MznD41OsMbS18VneH0AdGZfASfPDrD/xBf
PTrD8UWjM7yy+HjRGY7vVH2EwvFJojMcXx+62n40dFYfhPim0Fn7cuLzQWd4
OfGloDMcH4WelxNO3x+d4fSp0VnfV/qq6Ex+d1j6Vu7zA756Hfoz/pL0Dd3n
Exifuy7fC+Pp17j96IxvXY/vi/HnpO/g9lUzvl09vkfGG6mfu/3BvvF8v4yn
Duz2udrxxD1Wz3T7NX368P3/f32IzBPGvy71Jbd/jvFN1O/FeOokbh8Y47uo
b4nx7PfdfibG91L/DeN/lH2r25fD+EHqI2E8+y+3v4TxIeqHYDz7CLdPgvGj
tK/P+GLS93f3+xk/Ts+9sP+gT838hK+V8y/MQzh9WOab1pmkb8i8gtPnYv7A
6cswT+DVXPXDx/2nfO92nZbvF05dke8RHiJ1ML4vOHUbvhc4dQY9zymcfbH6
LYS/Kvs4dGY/FyfngPT3iAnn3BA6w1+RcyXoDOcchP7eHOF5xbePzvD54jNH
Z/gY8UWjq+3nRWd4O/GdojMcnyQ66+cSXx86w3OJDw2d4fim0Bm+VXw+6AzH
l4LO7I8ryPkpdNY6vZy3Qmc453TQGX5DzpWgs/oT5RwEOsPx7aMzHJ85utr+
aHSG/yA+XnSG4ztFZzg+SXSG4+tDZzg+NHSG45tCZ3h28fmgM/UGzp2hMzxY
zqmhM3ywnHtCZzjndPRcjXDOlaAzPEHOQaAzHN8+utp+c3SGHxZfNDrD8fGi
MxzfKTprn0d8kugMx9eHznB8aOgMxzeFztRvOK+HznDO96EznHNk6AyPkXNP
6AznnA46w/+RcyXoDM8v5yDQ1fbvozMcnzk6q+9GfNHorP0x8fGiMxzfKTrD
8UmiM7y6+PrQWeuO4kNDZ+phm+WcIzrDOReJzvCjci4PneGcI0NnOOee0BnO
OR10hh+TcyXoap+HQGc4vn10huMzR2c4vmh0huPjRWc4vlN0hi8SnyQ6w18R
Xx86U8/jfCh6wnvJeUb01DqhnL9DT/gTcl4MPeFl5XwTeqofWc7joJ99jgQ9
4Zx3QE94RfHnoyccPzl6wvE/oyccvy56wvGX6u8vEF5V6p/4+ajX4evDfwbH
h4ZfCj5B6pb4e7Q+KT4f/ChwfCkvSX4Dbyl5I31o+DjpR9M3VT+y9E/p88Hr
Sb+PvhQ8SPpT9FHgOaSfQt3fd31v/R+/HXW2yuK7ixN/Fby++MTwM8Gnia8J
/w38ZfHhvCj5B5w+O/1gvb70helfwrdJH5N+G5y+G/0heJL0iegHaL1R+hq3
xR9GvWuq+NzwM8HriC8rj/hv4PiI6EfCV0tflf6Z9qmkD0i/R/0F0reiPwGn
z7JGfFRadxI/GL4fuBH/Ev05OH1G+knwo9IXo/8Bp4+D/4n6STPxQdF/gtNH
o98Dp+9Dv4T6wF7p+7h9wOyz8tRd/T/37w3ruf2Xvn202y8If7+e29/m26e7
/Vi+67h9Lb59tNuHAW9m+QZ8+2J3nxvex+rLwvtbfUTffpY+kL2fdffDfPtZ
/L72fhN/KhyfKn5Ke7+J/8/eb+JXs/eb+FHs/SP+CXv/SL/f3j/Sn7b3j/RT
7f0j/T97/4jvlv0O/lt8onD8ovga4fvE34gPT32m4sfD/wHHB4JfAY5vgf46
/CXps9MPhm+RvrCvf+nl9DHxs7K/wNfKegXHh4lfEB4tvkHWK/gx8VGwXsG1
7y/rlfZRpU/NegWnr4rvk/x8svg/Wa/g+BVZr+BdxVfAegXfI31w1iv4cOnb
xst6Rb6aW3yPrFdw+ub0d+G3pM/LekU+1k/6vPR3eW7S5+U+hdO3JQ+Bc86F
fjD5yVLpC5M/w/vK7wmhvwunz3tWfJlcv5P4MzkvoX06OfdxQ/yO2l8T32aQ
+PPgHcRnyPkKnkecE+GcADyPnHfoI75JeIL4P/EpwvErxokvDV5U/HWc31Df
qJxD4RwCnPMU+Obh+P/vil8TniK+U/yFcHyS+OHg+Prwb8HxoXEehucd52I4
FwHvJec78PHDOY+wSnzncPzz+ErhQ8Qf2158kPAJ4ufEdwjHf4hPDn5Z/HL4
uuArxN/F/aDnL8WPxDkZ9efKeR/Oe8C/l3MrnE+Ah8o5C/z08MJyLgD/Nzxa
fOy9xUcLryF+YHyr8JbiX8WnqD5t8Vviq4P/IP5AfGBw/Gz4luC7xH/FOmD3
KTifY/c7OE9i9yk4/2D3I/Dr230H/OV2fwGfrt0XwFdq1//xQdp1fnx7dj0f
n5ldt8cXBa8v9XnOcdl1cnzYdl16rqxXPO8GyDkvzinB78p+4Y6sY/Ag+d4/
lnVM66LiN2Yd4zm1R86LsY5p3VLOPQ2QdQzeRXzg+JX1fIn4lvHXwvHZso7x
nLov59FYx+Bpcq6KdQx+TM4B3ZZ1TM9ViP+cdUzre+KX7i7rGLyA+HtZx+D4
UTkXx33/pZyPYx2Dc86LdQw+Sc4lcX4Gzjka1jF4OfHJd5J1DH5JfN1PyDqm
fmTxIbOOqc9QfLP4O7W+Jz5P1iue45zvY72C6zk1Wa/gnKtivYIPk3NAeWW9
gm+Xcyufy3oFvyj+f3zqcPzqrFdw/NWsV3D8wKxX8C3iX2W9guO35Nwd+cNO
OX/HOTH4B3JejHNN8NxyvolzOFoXkvM4nBvR8XJ+pKqsC/B1sn/Blw/Hn4+P
XPMf8ZPje4a/Jf5nfLrwueLXxVcKzyr+UnyQ8N/FD4kPT88bSf5GPkR+FTpm
8PuhAV9ovgJPD4vrd0HrG+eVr8m3dKKnXsRzVOs8N4otLZYWos8V5TXL77l5
wnfOBf7R4VnOwVw9dZ+j55+sc7LwYuvHtu6W8bxjPYIPWzq1ZZAzTdcReMqA
S2U/axTuu/+Fj6xdsszPQyJ1HsPzHL83c2TdxZrnodPgyJ3TJiWNVx3gDZrc
yerxraGD1nPqb7rfsd941QF+fGLaEFPAd64KXqVu/7QbGfrweeFp1jlW+PzU
/9R42HCefl74lsS9TWqUWmydR7vi1Dj33cm2rVbq54U3ejZi7/mq63V+wP/a
tWLC9S6bNb9Ej41f9bnkyd/4vFrniV/9zGcZ+2I+L7xN0XErPDroc1d4Yrbr
9Z/PmCfEr+e2uxabNCzEdz5U60UFiuSqVWedxg9fv+unwrP6+c7TwQu16Dts
YTXf7yXgc3R6dC/S//ym+q+aNvrc//wmfMGbtQ958hPdXwk/9GrRl/zPUcIr
jlgQ5H+OEj64a8WLnnWG9yWuBcVrHZmY5NMHPvF6xxme/z+C68NnHAv40eO/
4vr6+e4lxY7Mv0PzJ95n/pOtpw/JuK8ZDy/y7Pj86wI2W7+HylencvsmfXUq
t8/PV19y+9J8dSq3j8pXp3L7fnzXced5j593s+tX7v60r37l7qf66lfu/p+v
fuXuV/nqV+7+iq9+hZ52/crdP/DVr9BTf1/IC8ta/ll2uN4P8F3tvy3r+f8a
0BPeocv2Hzz1K/SEr18ZGllw8Sj9vuHDuqZUrBs81Hc+SHjBlCGn827tp+uq
1rVKjpw0Omai5nl6vvB4lvo3TszW+xTedPCVlVM6Rep9AT8TU3vEjPu+PAC+
uF/iCxnrj85D+NCjb26eWXmd3rfE1bVU6zzXboSpDvAPu/0Q6qlroQP86rut
fv08KEx1gBfcvXHW1denqQ7wIbUSW6aljdJ1VetmZf5aV7LQcv288Igs3Rbu
Gb1ePy+8cHzQxGP5t+rnhW8/VyR7yu1o/bzwBcuXlJy0bbeuC7x/g3wVz3nq
XXwu+JpPa8W9Xmehfi743ydLDeufHqGfS89pxQQkPH1iij4X4BV7XVpXO32n
xg8POX19bcuOezR++NzQhutOVNun8ev50Yjhp6uMOaTrDu/TLvz+wCqpyzRO
+LzAlRtKd43SOOFt4v955ki5ObrOw8cmRke+V+ugxqO/f+jckcuPAo5qPPD/
vLR2dd6/juu6xvU6pW7+0vP/DvC+8P4t6rzm8WNwfdVj/o9VQxN+0uvDn+9Y
omWJ9DN6n/PvUoZfePGtsVG+8/LCn/j7QMVVn/6i9797fc1dl59ZD8i7GO9e
d33rnp7/lnVD63Fy35CnMQ4+RPIWru9ev33nteGsP8xXOPcj78v8JQ/kfeHk
Rfx7OPkD8bifG75z+vAPZN0jHjjrAPNS31fuIz3PIPOUvJQ44dslT9NzQMId
yWe4Lpz8gfjdzzdf/HDWZ/fvJznlXJH1SuvOwrnf1V8i/D25v+z61S2pX7nP
WR9xxku+zeeFk3/yeeHkaXxeOHkR7wePlLwFHdzPc9+8gvM8Qgc46zM6wFnf
0AHOeoIOcO53dOB+ZX+BDvBXJN9GB/gxyUvRAT5f8kB0gE+QPI04dLzkXejj
zmt89zU8v/Vchg+2nlPwk9Y6D7fXVbi97sFZx/S8kMTF/ov47boW44k3QPZl
6GzXtbiOO1/znfvW/pTkIXr+Vz73UNnfcX34AtkHcX133uc77wwnn+H94I48
9/Ucl+h6UfaPvC98q+yztP8tfI3sX4jHnW/6zgXDm0keRTz63JR8Q89RCq8k
z3H1c8j3PEr2s8QJZ99HnHD2U8xzOPsa4nfnxb7ztroOSb5H/PBnJS8ifjj5
Bp8HPk6e+3wu/b0psh/nc8HfkX0rnwvOfpDPBa8g+zLuX/h02U/xed35vu/c
KzxK8lg+r9bHJN/j88LJo/i8+vsRJZ/h82v+JXkIOmg+YtVt4OzT9fftCH9a
9r/oAP9C9qHooPtU2T/q748S/pzsE1kv4PY5Vve+x3eOFR4qeT66wedLPqy/
b0c4eab2QYW3lnwP3eDkafr7o4TnknyMn/W+ET3/DxRTHIA=
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgT9Ubx++55yqbkJGVVDIy27QnWjYlSUilIi1piRJpqaRBhewRoiVN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           "]], Polygon3DBox[CompressedData["
1:eJwtmmXAVUUXRs/MXEJUBBQBG7uxO7C7sBMURQUVW0ARA7sAC7EbMLFFxQ7s
7kDF7tbP+tZyz495z6w758Z7zszez37m9NxrcJ+DctM0e/KnxbF9aZqdOS4L
H8MLd8L7O56Cl4QPgjdg/Bx4DfhYeHv4Ynh5+Ah4C/h8uB1tY3gd3v8C/QUZ
3w/uzfjp8Ky0XeFtGX+H/lKMD4Y3ZHwUvBx8OLw5fB68P3wDfAJ8K7wCfCS8
JXwBPBttN3g7Pu9d+qszPlxmfBzchbYjvDXjb9OfXL9vAHw8fB98MLwvfAK8
BHwgvD7vPxu+p/LejI+AF4cPgNdj/Cy4E217fw/jb9LvTNsB3gp+i/699frt
Ax8Hd6Xt7vWD36M/O20PeAf4ffqrcv7RcB8+fyzcjdYX3pHxD+ivyPhRfj7j
F8JP1P/38BS/9+76+/rDx8Krwcd4vTn/IngW2nbeL8bfoN+BtqXXH36Z/g+c
ty7cg+NR8Dscl4RbHA+Gl67XayN4NPw3vDK8DO9/HN4aHgMPZPw6+Cl4BHxk
ivs7FT4BHgaPgbeBz4UHcf718NPwifDRjJ8LbwufDx/I+AT4GXgkfEyK+bEZ
fJb3h/Fr4Js5fg5/QbuF/nOMn0z/2BTzpQ98HnwAY+Ph5+FT4BEprufvvL4J
3JPjUPhzjqvCnTkeDr/FcXE4czwIfqX+v6fz/kvhL3l9dXhWjkfCL9XfNzLF
fPyD1zeF5+c4DH6b4xJw4TgYfq3+vjM5/3L4BfgM53+K+fAifCZ8Yor7+Wq9
fmfAl8Fv8jmLwYnjgfCGzhF4CuOd2rCO4cfhB+BZ4A85bzl4Bo6HMLYsn3cY
vFmO6/8PvCa8Iuc/Ab8Mnw2flGL9f8F5q8FdOB4B/8v4WvBKjD8JP1njxREp
4sef8Irw0vCj8Cb1/9uL918F/wWvBPdi/DG4LW0j4wf8PP03GL8APhu+Em7R
NoDXgp+l38b/GV4bfs4AR1ubw8rwU/TX4/0nwbvzfVfAm9br2R++Gl6zztcd
4Evgdet82y3H/Ui03vAqfN5U+uvU+bprjuv/Ecfl4Q4cD4ULbX14Tc5/hv6i
nD8IXpfxM+Fl4EPhTXOsh5c57yX/N68Hbf06f/fI8f8+W3//8BTx1vm6Ezxf
jng7A20L47WfQ38l2k3wdfC/xgNjPHwTXLj/q8C3wOPhBN/H58wIT4d3NR7R
boUnwJnxNY2J8K1wW3gNY45rDW4DT+L95pe34T6M3VHzzLvwdsZn2l3wzXCL
8ycz3gH+GN6Fsdth/sXmHXhb4yc8A/wRvLPfDbeHP4R3gtfyHHgS3I7PWw9+
EL4Hngl+lvPnhn+B9zN+wHPBP8P7Gs9pF8LnwD/RX5J2ETwa/sV8QBsLj4J/
Nl7w/l7wr/Bk4xU8J/wTPAC+H54J/gTezflDmwLfDc/I71kavgy+EP7N+UN7
AL4L7sD4ysYw+Hq4gXv7mXTvhGeAe8GXw2Ph372WfF9b+H14B+MDvAz8G3wf
/FmO9TNLjvj8aY710THH+lqQdhw8lPO/of9BjvXSluND8LQc870dx4ddfzni
/b+cPwX+JMf6mznHej6Om/cIPA6+Ez4Yvs34CN8GT8+xHmbi+Ah8COO3G7/g
2713HOeDP+Pz7zZ2wQvD38L3OHfzf5eleQ/eHl6Idip8HPwt/cVoo+DT4B/p
96QNhQ+Bv6Q/D21fuB/8Gf05aXsbD+Dp9OemDYD7wp/Sn4u2j+sP/oT+6zni
0z/wA/C8tIHGL/hz+u/liH9tOD5oPM8R7/5m/H54ftow+FD4K+MB7Rz4VPgH
4yXnLwJ/B98LL0w7DT4e/s54QbsCvgj+g/4KtAnwlfDf9Kfy/jngH+F9XHhc
334cFuH1V43POfTEwhxfMb7n0B8L5cj/f+bQUwtwfBH+O4deWTBHPOld8/cu
OfKd67EbPI3vuwv+NYf+mSdH/P2e49Zwtxzx8rccemzeHPH8hxLv71D/319y
6Km5c8TzP0rM50VTzL9fS1yf+er8+wp+DL4f7sjE+L3E+lwkxfzdE74aPprP
u9n1UuOv92s4PCNtK3ijFNejPW1zeP0U//8E3vcR/KUxj/53vL8T/f81MT/7
wVfRH8bYTfBMrfh/N05xvV/h9QXhP+FB8C6cfwl8GK/fAHdvxf3ZifFp9DvS
toU3h1+nvzPnX+x84fyJ8Hc5fu/sOfLZtzn0W9cc+fYzzn8ZfjrF+nuE12f1
98N9jTXwzPCn8O7wY3BX+Gt4T7hdifXRK4defpTjbPBXjPeDWyXWy5I59OPD
HLvAXzC+B/wU3AP+Ad4bfgmeH/4D3r/O7+7w93B/eHnaePgK+C/6y9Kugy+D
/0d/Odr18OXwn/Rf5v0LeP3hgXCbEutzqRz6u22J9bt0Dv09FL4PHgPfAf+c
Q//OlSMf/5Tjes/J8WnnX4l4M29d37/BS7teUqznr3Pk19ly6KHM+F7w4vBr
cIH7w0vkuH9ztIJ34/0f0+/RivN3hT+i/yPnz+v6qPnkpxLxr3uN36vwOTub
G2kf+l7Gr2H8GF6/BV6f9hB8L+Mztwl9YXxZJ0c8eqDquUGMn9SKHLhQCk1v
buxqHKI/nTbRawJ/7fygXey9yjGXndOuZWuCTeBtmqgVOuXQZuYYc42atk+K
mlKtqwZeL4XmVRurEddNobHVjmqEv+h3bkI7vJVibbnGPldr0qbRH2+e5f87
C/4Avt44B58Jvw9f57yD7696aiCfM7IVmqNJsQbUIqcx/g79q+nP3iY0/jYp
NJRa6nTG36V/jXGtTWiQf5qY42qTUxl/uwlt1pXxU+C3nL+uM/hk+E3nq+sC
no32iFo3xfnmrJxiTZnLrCmsla2ZrTUUT9ZS5lhz7RYl9MIA+t9z7tol8ttO
OfL1hiX0Sd8c+W+rEvlhvxz5b8sSemHfHPll+xLrSRNAvWO9eTq8TY58tFaJ
fLQj/DXcq4Q+2Bj+At64hD7qlyMfnQi/Bl+So54YCb8OX5qj3jgJfsP1DHdu
E2t28RQ1h2vZmLAYvGwTscKaZVl4lSZqGWPmEik0tbH09xS5wJyg1rEGWy5F
jWZtZo26QooazNq1fQ6t3rsJLWONsyq8ThO1jxp9tRQ1r9rdGmz5FDWNtdnK
JfLv1jn0gxqrlSJmqr2MiXOmiEnGyn/ga1No7kG891f4ghT3cDe4PdfgjhSa
bpi1OuNLwivAr/L+R3ltCP2Dee0MxrrBs5eIAye2ou2XogZ3zBr8qBQ1i7W5
79FneaTEZ83F992QQwNPqevLnJbrenNOOjefaWJum0NvzLH+za2b5FhLrilr
FWOKudMcaqxRI6mVzBnzw6vmiFPd6fcw9tBfnfH1GP+4jhnLjIGe45zaHz6k
ibnmHD8lxRx07htTN0sRo421xug1UmjIn+ocHZJijjp3zWFzpci55rYh8KZw
H/jHHBqlbYoaQu3yeYpYa8xVe1pjzJQiR1l7WGOoTbrV882hc6TIaeZWNf8C
KTwBawFrigVT1PTWGuY4tYqaxdynJps/RY2uVjNH9nRON5E7zaE94J5N5FZr
oo4pcqq1kjVFlxQ1h7WGNVqnFJrP2k2N3L7+XrXzJPj2FDlwYIkcaDx6uonc
qAZfKoVGVZsf3Yp8s6dhs4RmnSdFTlTL3ghfA99oDiuhIWZLUVM9UHOiXoEa
2Fx5LXw+fCm8eYma+uQUHoK1tppabW3Ong/esYQeGJyj3joKfgo+J0e9qUen
V6eH17WEx9W/zscZ6/xzPrlGXCt6dnp3emKzlPD89P705GYt4cnpzenxdS6h
EW9IUbOoHfWY9Jqs8fUmrdH1ro6v62GZHLWE81/tNLyuD2uCmUt4qHqpeqB6
rXoqelsnNOG1uL6G1vnr/F+ohGfqGj6jNmOBnp9jemh6aXoqeqd6Ypem0AR6
ZXosei16gnq3epSHpfAU9S7NiQPrenN9qgkG1fU9ZwlPwtpkWF3feop6i3qI
eqMnwwek0BRzl/DsLk6hgfXy9PzGwVc24QXunKMWM2eZu/TY9Nr0NPQy9eT0
5vQ09Hb1pa29zTHmGmsMvbXRTdQeeiB6P3qCeiN6LnpfenB6MXo0emd6Yno3
ejxnpfDU9H70mMbA45rwnvTQ9NL0oPRK9dj02syJ5kY9Lr0uPTy970Ny1FrW
XDvB++eoxcy55l49yPNSaHy9yaE5vBM9lL4lPMdLUtQkepHWDBPhSU3UEtYE
V6fwvK0V9Az1DvWo9Lb1fPR+RjbhvetZnZuiRtDLska4Cp7YRO1wJO1J+mfn
8GdOYfzAFB77vOY2eHAKT30B13MJ/+HIHP6Ev9nfPiRHvblHCb/oqBz+gznN
XHdEjlxnzjO3jay5cL8S/sxxOerTvUv4P8Nz6PsBJfyjY3Po+31L+EsjctQD
XmOv9cE5/JgDSvglJ+Xwsw4q4fecksO/Ohp+Fj4vh19yYAn/5WQTHnxECT/0
rBz+02El/NAzc/hhg0vo6VNz+F2L5qjN+vGatfQQ2lS6o3L4TSPgF+GxOfT3
MfBz8Pk5/Jzh8PPwBTn8n2PhF+ALc/hTagBz77k5tMGp/k8p9lR6Oj95fWqK
7/C73AO5DZ7cxN6I+Uv93KXmCz0YvVU9Cr0ZPZ5eVU/q/Vizqq8713ynnupR
85n6696a77rXfGWNcWMKj8baw5qke81P6i9rlm41fz5f9ZZ6Tn2nvrI+UM+p
z9S3elDqW/Wd9YI1vXpO/ac+0yOaDD/chHd0Wo7axnvivTk+h9fnnHJujfYz
UtwT7401r7XvS014UXpK96XwpPSa/vNsaj7Wy9Ej0CtQT+p9WeNZ6+kh6OVM
qfnb/PxG1ec9a/5Wn+oh9avx3bh9Bu09+tcy1r1NzCm9Vue8c+3mElpIzan2
vLVEbWRNZG10S4nayJrA2kDNpDacMYeWuqmEVlXDqmW9PhNrvvJ6OWcn1Hji
9XKN6P26pg+omlBtuDBtkRJrQq/RNe1acQ2Nr/HKtTWhxL3zHqrNJ8GbNVHT
WdtNLKGV1eBq8etLaHU1vlp/dInayxrKWmpMidrHmszaTM27EPhXCi2sRvP6
zFG1220ltJs1p7Xn7SVqS2s2a7cb4TWa0Pxqf9e03rIxxbV+Q4laQE2vtr8D
3qWJGtVaNdXPX6xqH9eoXq0xxbXrGr2nzj/XrjFFL9YYZKwxBo6t8d/YaIy8
qOa/vjX+j6v50fhujLi3zu8RdX1PrvPT+boj728Hzw7fzdhe8NwprtHjOWpM
57v6zdrTGK2XbI1n7LZmfTxFDLKWVc/rjRnjtmlFzftYihhpLXxuiVrGmtTa
1Jis92KNaKxWg42q+Vhtpga7ta4/tZk5Re/fmG2uMebpZRtzjYXGyEk1Xg2p
69X4pR4dWtfzVTXfGc/MEVfW/OX6tkbVm7fGtXY1R+gFqREH1Hw8puY/8505
44qan80l5ozRNd+bS6x3rN3dX7E2P6/Etbams7YbVSKWGlP1Jt4qkcvNseba
N0t8l9+plni7hLY155v73ylxr73naiE1r1p3n6qF3y2R+9VMaqdpJbT0fzkf
/qDEtfgvh8Pvw9c2ofHUervW7zu8avH3Smg/NYXa4pMSc8k5ZSz91DXfRAw0
Fg6s33dirQ2mlNACajq13eMltJ6aUe34WAntqCZUGz5cQouqGdQOD5XQDuYs
c9eDJXKXGkOt8XoJraYGU4tNL3HvnQPmso1aoU8eTOEPfMz4HU3kHHPPhyVi
mzFOrfRRiVykRlerX15ibVjzWfu5Rryf36RYO5eWqM2t2azdtmjF2ngiRXze
vBVrwTXj2tmqFfn5qRT+0matyM+uGdfOhSVqLWsya7ONW1GfPJTC79mkFbnI
NepavaBE7WZNaW25ZSv0wJMp/KrzS+Rac6615qatWNvWaM7PrVuR+9UA+l/G
hHbmqhSxYnyJ/KBHolcyrkStb01mbXZRidrMmtHa8ZISud6cb615WYlaWQ9D
L0OPoGMTXqDewRUlcp850Fr2yhK5zxxo7XpdiVxvztfLubpE7WtNbG08tkSt
ao1qrXpNCe/RGtla+aoStbM1sbXxtfBSTXiUepVe04dqftdbuynHHv+0JrxB
PVS91P7e4xK/2d8+Hf6ixJ6D/s86TfiXF5cY+4T2Zf089YKe+TfONfjjJjx/
/Uc9EL2Qz2hfl/CUfbbDPQy9Zu/J1Ko3/D3Wg+Ymc5T1nh65z1q4p6F3rmfv
XnTvJrz8c3jtmyaeWfD79dx9VkU/0nrS+sL6x/rGekpPz3rKesh6Q8/Oteka
tV7R43MvyXpL70+P0Pry+CbqL/d4fNbDPQT3ftzTca/YPQT3etzzcO9Dj9u9
IPfE3BvTY5+nxB6JeyX6we4lOYedy64ZvVjrPetj61vrNfdA9I/1i9XP7gm5
N69f7F6Rz+z47I57TB1L7AnpJ+uHulfknrZaSE2kP+szQz475B5VhxL6XG1g
DjeX+0yNz9a4p9WpxBp2LbuG9I7dU/JZAfdAf6kazVjgmlS7uQej3t+zCd9N
T9NnJawZ9DqNUcYq17zeps/k+GxOP9dciT0F9/rdE3WvQQ/UZy+Mcf95o63Y
23EPwr0C9yx8dsg9M/cyfAbIZ4Hco+tSwnN079J6XC/SPQT3EvY25pXwYN0b
tF61XtYDdi9Uz1Jv2Hraetb61nrXPSKfzXCP170j/X21pJpSP///uqK9fg==

           "]], Polygon3DBox[CompressedData["
1:eJwt13e4FNUVAPB9uwuKgqiohKKIFCM1dEOVbmhKT2hGqpGmUiRSLFQVBBWB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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0jkvBVEYgOGxr9cS0RINUVCKglIUVCIKOqKgIBEFpULodPwCWiL0Ejr7
cu1rRMTW2NfwnETxznMy92TmO5lb0t7b1JMQRdGwXhXWj7rUbGIU5XGBxVxn
JU9Zywc28pttzE6Kopi6rcs5yGqOsp4TbOEUOznPfi7xntd817aewz0tG2iH
K4xzlbtc416Yifvc4AE3uaXD8BwecYfHjPOEuzzlHs+4z3NOO8cNP3Shl3BG
jZlti0NcZB/n2MFJNnOcdRxhFQdYxlJ1WWewlZ/e0cA71vCYFeFcLOKtfVd8
U66ewl4VmjGHBYwxn9lhD7MYYyazmBHex3SmMkVp1klMDd843OOvkvUTftOX
jBHNuNz+/x/+AMQfSu8=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{690, 1000, 473, 689, 1106, 912, 691, 1107, 913, 692, 1108, 
        914, 693, 1109, 915, 694, 1110, 916, 695, 1111, 1006, 1206, 696, 1112,
         917, 697, 1113, 918, 698, 1114, 919, 699, 1115, 920, 700, 1116, 921, 
        701, 1117, 922, 702, 1308, 1001, 923, 1002},
        VertexColors->None], 
       Line3DBox[{704, 1007, 1207, 703, 488, 705, 1118, 924, 706, 1119, 925, 
        707, 1120, 926, 708, 1121, 927, 709, 1122, 1008, 1208, 710, 1009, 
        1209, 711, 1123, 928, 712, 1124, 929, 713, 1125, 930, 714, 1126, 931, 
        715, 1127, 932, 716, 1128, 933, 717},
        VertexColors->None], 
       Line3DBox[{719, 1010, 1210, 718, 1011, 1211, 720, 504, 721, 1129, 934, 
        722, 1130, 935, 723, 1131, 936, 724, 1132, 1012, 1212, 725, 1013, 
        1213, 726, 1014, 1214, 727, 512, 728, 1133, 937, 729, 1134, 938, 730, 
        1135, 939, 731, 1136, 940, 732},
        VertexColors->None], 
       Line3DBox[{734, 1015, 1215, 733, 1016, 1216, 735, 1017, 1217, 736, 520,
         737, 1137, 941, 738, 1138, 942, 739, 1139, 1018, 1218, 740, 1019, 
        1219, 741, 1020, 1220, 742, 1021, 1221, 743, 528, 744, 1140, 943, 745,
         1141, 944, 746, 1142, 945, 747},
        VertexColors->None], 
       Line3DBox[{749, 1022, 1222, 748, 1023, 1223, 750, 1024, 1224, 751, 
        1025, 1225, 752, 536, 753, 1143, 946, 754, 1144, 1026, 1226, 755, 
        1027, 1227, 756, 1028, 1228, 757, 1029, 1229, 758, 1030, 1230, 759, 
        1031, 1231, 760, 1145, 947, 761, 1146, 948, 762},
        VertexColors->None], 
       Line3DBox[{764, 1032, 1232, 763, 1033, 1233, 765, 1034, 1234, 766, 
        1035, 1235, 767, 1036, 1236, 768, 552, 769, 1147, 1037, 1237, 770, 
        1038, 1238, 771, 1039, 1239, 772, 1040, 1240, 773, 1041, 1241, 774, 
        1042, 1242, 775, 560, 776, 1148, 949, 777},
        VertexColors->None], 
       Line3DBox[{781, 1149, 950, 779, 1150, 951, 783, 1151, 952, 785, 1152, 
        953, 787, 1153, 954, 789, 1154, 955, 791, 1155, 569, 793, 1156, 956, 
        795, 1157, 957, 797, 1158, 958, 799, 1159, 959, 801, 1160, 960, 803, 
        1161, 961, 805, 1163, 963, 807},
        VertexColors->None], 
       Line3DBox[{806, 962, 1162, 804, 1255, 1054, 802, 1254, 1053, 800, 1253,
         1052, 798, 1252, 1051, 796, 1251, 1050, 794, 1250, 1049, 792, 1249, 
        568, 790, 1248, 1048, 788, 1247, 1047, 786, 1246, 1046, 784, 1245, 
        1045, 782, 1244, 1044, 778, 1243, 1043, 780},
        VertexColors->None], 
       Line3DBox[{809, 1055, 1256, 808, 1164, 964, 810, 1165, 965, 811, 1166, 
        966, 812, 1167, 967, 813, 1168, 968, 814, 1169, 1056, 1257, 815, 585, 
        816, 1170, 969, 817, 1171, 970, 818, 1172, 971, 819, 1173, 972, 820, 
        1174, 973, 821, 1175, 974, 822},
        VertexColors->None], 
       Line3DBox[{824, 1057, 1258, 823, 1058, 1259, 825, 1176, 975, 826, 1177,
         976, 827, 1178, 977, 828, 1179, 978, 829, 1180, 1059, 1260, 830, 
        1060, 1261, 831, 601, 832, 1181, 979, 833, 1182, 980, 834, 1183, 981, 
        835, 1184, 982, 836, 1185, 983, 837},
        VertexColors->None], 
       Line3DBox[{839, 1061, 1262, 838, 1062, 1263, 840, 609, 841, 1186, 984, 
        842, 1187, 985, 843, 1188, 986, 844, 1189, 1063, 1264, 845, 1064, 
        1265, 846, 1065, 1266, 847, 617, 848, 1190, 987, 849, 1191, 988, 850, 
        1192, 989, 851, 1193, 990, 852},
        VertexColors->None], 
       Line3DBox[{854, 1066, 1267, 853, 1067, 1268, 855, 1068, 1269, 856, 625,
         857, 1194, 991, 858, 1195, 992, 859, 1196, 1069, 1270, 860, 1070, 
        1271, 861, 1071, 1272, 862, 1072, 1273, 863, 633, 864, 1197, 993, 865,
         1198, 994, 866, 1199, 995, 867},
        VertexColors->None], 
       Line3DBox[{869, 1073, 1274, 868, 1074, 1275, 870, 1075, 1276, 871, 
        1076, 1277, 872, 641, 873, 1200, 996, 874, 1201, 1077, 1278, 875, 
        1078, 1279, 876, 1079, 1280, 877, 1080, 1281, 878, 1081, 1282, 879, 
        649, 880, 1202, 997, 881, 1203, 998, 882},
        VertexColors->None], 
       Line3DBox[{884, 1082, 1283, 883, 1083, 1284, 885, 1084, 1285, 886, 
        1085, 1286, 887, 1086, 1287, 888, 657, 889, 1204, 1087, 1288, 890, 
        1088, 1289, 891, 1089, 1290, 892, 1090, 1291, 893, 1091, 1292, 894, 
        1092, 1293, 895, 665, 896, 1205, 999, 897},
        VertexColors->None], 
       Line3DBox[{911, 1005, 685, 910, 1307, 1104, 909, 1306, 1103, 908, 1305,
         1102, 907, 1304, 1101, 906, 1303, 1100, 905, 1302, 1099, 904, 1301, 
        1300, 1098, 903, 1299, 1097, 902, 1298, 1096, 901, 1297, 1095, 900, 
        1296, 1094, 899, 1295, 1093, 898, 1105, 1294, 1003, 1004},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 474, 1106, 252, 488, 280, 1211, 503, 295, 1216, 518, 
        310, 1223, 533, 325, 1233, 548, 340, 1244, 563, 1150, 355, 578, 1164, 
        370, 1259, 593, 385, 1263, 608, 400, 1268, 623, 415, 1275, 638, 430, 
        1284, 653, 445, 1295, 668, 460},
        VertexColors->None], 
       Line3DBox[{253, 475, 1107, 254, 489, 1118, 281, 504, 296, 1217, 519, 
        311, 1224, 534, 326, 1234, 549, 341, 1245, 564, 1151, 356, 579, 1165, 
        371, 594, 1176, 386, 609, 401, 1269, 624, 416, 1276, 639, 431, 1285, 
        654, 446, 1296, 669, 461},
        VertexColors->None], 
       Line3DBox[{255, 476, 1108, 256, 490, 1119, 282, 505, 1129, 297, 520, 
        312, 1225, 535, 327, 1235, 550, 342, 1246, 565, 1152, 357, 580, 1166, 
        372, 595, 1177, 387, 610, 1186, 402, 625, 417, 1277, 640, 432, 1286, 
        655, 447, 1297, 670, 462},
        VertexColors->None], 
       Line3DBox[{257, 477, 1109, 258, 491, 1120, 283, 506, 1130, 298, 521, 
        1137, 313, 536, 328, 1236, 551, 343, 1247, 566, 1153, 358, 581, 1167, 
        373, 596, 1178, 388, 611, 1187, 403, 626, 1194, 418, 641, 433, 1287, 
        656, 448, 1298, 671, 463},
        VertexColors->None], 
       Line3DBox[{259, 478, 1110, 260, 492, 1121, 284, 507, 1131, 299, 522, 
        1138, 314, 537, 1143, 329, 552, 344, 1248, 567, 1154, 359, 582, 1168, 
        374, 597, 1179, 389, 612, 1188, 404, 627, 1195, 419, 642, 1200, 434, 
        657, 449, 1299, 672, 464},
        VertexColors->None], 
       Line3DBox[{261, 479, 1111, 263, 493, 1122, 285, 508, 1132, 300, 523, 
        1139, 315, 538, 1144, 330, 553, 1147, 345, 568, 1155, 360, 583, 1169, 
        375, 598, 1180, 390, 613, 1189, 405, 628, 1196, 420, 643, 1201, 435, 
        658, 1204, 450, 1300, 673, 465},
        VertexColors->None], 
       Line3DBox[{265, 481, 1112, 266, 1209, 495, 287, 1213, 510, 302, 1219, 
        525, 317, 1227, 540, 332, 1238, 555, 347, 1250, 570, 1156, 362, 585, 
        377, 1261, 600, 392, 1265, 615, 407, 1271, 630, 422, 1279, 645, 437, 
        1289, 660, 452, 1302, 675, 467},
        VertexColors->None], 
       Line3DBox[{267, 482, 1113, 268, 496, 1123, 288, 1214, 511, 303, 1220, 
        526, 318, 1228, 541, 333, 1239, 556, 348, 1251, 571, 1157, 363, 586, 
        1170, 378, 601, 393, 1266, 616, 408, 1272, 631, 423, 1280, 646, 438, 
        1290, 661, 453, 1303, 676, 468},
        VertexColors->None], 
       Line3DBox[{269, 483, 1114, 270, 497, 1124, 289, 512, 304, 1221, 527, 
        319, 1229, 542, 334, 1240, 557, 349, 1252, 572, 1158, 364, 587, 1171, 
        379, 602, 1181, 394, 617, 409, 1273, 632, 424, 1281, 647, 439, 1291, 
        662, 454, 1304, 677, 469},
        VertexColors->None], 
       Line3DBox[{271, 484, 1115, 272, 498, 1125, 290, 513, 1133, 305, 528, 
        320, 1230, 543, 335, 1241, 558, 350, 1253, 573, 1159, 365, 588, 1172, 
        380, 603, 1182, 395, 618, 1190, 410, 633, 425, 1282, 648, 440, 1292, 
        663, 455, 1305, 678, 470},
        VertexColors->None], 
       Line3DBox[{273, 485, 1116, 274, 499, 1126, 291, 514, 1134, 306, 529, 
        1140, 321, 1231, 544, 336, 1242, 559, 351, 1254, 574, 1160, 366, 589, 
        1173, 381, 604, 1183, 396, 619, 1191, 411, 634, 1197, 426, 649, 441, 
        1293, 664, 456, 1306, 679, 471},
        VertexColors->None], 
       Line3DBox[{275, 486, 1117, 276, 500, 1127, 292, 515, 1135, 307, 530, 
        1141, 322, 545, 1145, 337, 560, 352, 1255, 575, 1161, 367, 590, 1174, 
        382, 605, 1184, 397, 620, 1192, 412, 635, 1198, 427, 650, 1202, 442, 
        665, 457, 1307, 680, 472},
        VertexColors->None], 
       Line3DBox[{277, 682, 1308, 683, 278, 501, 1128, 293, 516, 1136, 308, 
        531, 1142, 323, 546, 1146, 338, 561, 1148, 353, 576, 1162, 1163, 368, 
        591, 1175, 383, 606, 1185, 398, 621, 1193, 413, 636, 1199, 428, 651, 
        1203, 443, 666, 1205, 458, 685, 686, 687},
        VertexColors->None], 
       Line3DBox[{459, 667, 684, 1294, 444, 652, 1283, 429, 637, 1274, 414, 
        622, 1267, 399, 607, 1262, 384, 592, 1258, 369, 577, 1256, 354, 1149, 
        562, 1243, 339, 547, 1232, 324, 532, 1222, 309, 517, 1215, 294, 502, 
        1210, 279, 487, 1207, 250, 473, 681, 688},
        VertexColors->None], 
       Line3DBox[{466, 674, 1301, 451, 659, 1288, 436, 644, 1278, 421, 629, 
        1270, 406, 614, 1264, 391, 599, 1260, 376, 584, 1257, 361, 569, 1249, 
        346, 554, 1237, 331, 539, 1226, 316, 524, 1218, 301, 509, 1212, 286, 
        494, 1208, 264, 480, 1206, 262},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzFmnlUje27x0vIEGXIVGTmNURzr6GrFFGGEEIoIUOGnzH0KpmSMkaFKKVJ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     "],
    VertexNormals->CompressedData["
1:eJx0nHc8l+H3/7Wn0tJQadGeKiOchlHRoiEaZlERRdKkrMyEhGRGGdl7XPYm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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2}]], "Output",
 CellChangeTimes->{{3.8062590823037868`*^9, 3.8062590981303883`*^9}, 
   3.8062591758524275`*^9, 3.80625923597591*^9, 3.8062594837336607`*^9, 
   3.8062598372447433`*^9, 3.806260097497178*^9, 3.8062602689138536`*^9, 
   3.8062607220794234`*^9, 3.8062607798769646`*^9, 3.8062608368125277`*^9, 
   3.8062613176603985`*^9, 3.8062615864156184`*^9, 3.8062616166148567`*^9, 
   3.80626193846017*^9, 3.806262929080475*^9, 3.806263056092271*^9, 
   3.8062632264069753`*^9, 3.806293192531146*^9, {3.8062932875496683`*^9, 
   3.806293314471966*^9}, 3.806294637966442*^9, 3.806295198773814*^9, 
   3.8062953425930624`*^9, 3.8062954381165714`*^9, 3.806295660268776*^9, 
   3.8062958165037003`*^9, 3.8062960602323427`*^9, 3.806296308199875*^9, 
   3.8062965249092236`*^9, 3.806296575238909*^9, 3.806296738092661*^9, 
   3.806296833346176*^9, 3.806297026742131*^9, 3.80629782687426*^9, 
   3.806298381844784*^9, 3.806298706676035*^9, 3.806298772494319*^9, 
   3.8062990540669746`*^9, 3.8064204982945185`*^9, 3.8064209368437247`*^9, 
   3.806421038144055*^9, 3.806421353855109*^9, 3.8064215021916313`*^9, 
   3.8064218542299924`*^9, 3.8064219396031685`*^9, 3.806422347249019*^9, 
   3.8064226001876774`*^9, 3.8064227229673443`*^9, 3.806422931664608*^9, 
   3.8064230663851457`*^9, 3.8064232383076167`*^9, 3.806423535464188*^9, 
   3.8064244686592984`*^9, 3.8064245333883944`*^9, 3.806424636757181*^9, 
   3.8064249167708683`*^9, 3.8064250414645543`*^9, 3.8064268261470747`*^9, 
   3.806426918806096*^9, 3.806427208869408*^9, 3.8064281277844543`*^9, 
   3.8064630641685715`*^9, 3.806463474405262*^9, 3.8064636109600744`*^9, 
   3.806463665161723*^9, 3.8064644045669317`*^9, 3.8064645771711707`*^9, 
   3.8064708509402885`*^9, 3.806472353676381*^9, 3.8064726221063857`*^9, 
   3.806473773297595*^9, 3.806474947241291*^9, 3.8064752040589037`*^9, 
   3.806476761558728*^9, 3.806477121066829*^9, 3.806484255149258*^9, 
   3.8064845612268324`*^9, 3.806484985092987*^9, 3.8064854962690134`*^9, 
   3.806486160981949*^9, 3.8066717412328653`*^9, 3.80667180468855*^9, 
   3.8066826810541344`*^9, 3.8066829252444158`*^9, 3.8067169571438203`*^9, 
   3.8067172252458334`*^9, 3.8067179467246037`*^9, 3.8067194944947805`*^9, 
   3.8067196457291946`*^9, 3.8067611816049814`*^9, 3.806820147544272*^9, 
   3.8068204491660433`*^9, 3.807293763067728*^9, 3.8072939061262474`*^9, 
   3.807294871513759*^9, 3.8072951097259617`*^9, 3.807297157682315*^9, 
   3.8073210915331397`*^9, 3.80732323328399*^9, 3.8073245309906073`*^9, 
   3.8073248385602283`*^9, 3.807345830802204*^9, 3.8075803864434385`*^9, 
   3.807580468257147*^9, 3.8075806339629855`*^9, 3.807580678774136*^9, 
   3.8075809354930363`*^9, 3.8075812038093295`*^9, 3.807581320048287*^9, 
   3.8075813775999346`*^9, 3.80758146423903*^9, 3.807581549127282*^9, 
   3.8075815806572886`*^9, 3.80758197001503*^9, 3.8075820518548403`*^9, 
   3.80758212135834*^9, 3.807582210418275*^9, 3.8075823856336403`*^9, 
   3.807582544310808*^9, 3.807582655651515*^9, 3.807582801673309*^9, 
   3.807582952555792*^9, 3.8075830819757385`*^9, 3.8075831396827393`*^9, 
   3.807583351712691*^9, 3.8075834169995265`*^9, 3.8075834852780714`*^9, 
   3.8075835583190174`*^9, {3.80758370356993*^9, 3.807583719498537*^9}, 
   3.807583802906995*^9, 3.807583867011763*^9, 3.8075839748087587`*^9, {
   3.807584041692263*^9, 3.807584061761818*^9}, {3.807584142417838*^9, 
   3.8075841616043186`*^9}, {3.80758431361432*^9, 3.80758433347383*^9}, 
   3.8075844122307515`*^9, 3.807584710881852*^9, 3.8075847878181515`*^9, {
   3.8075848188327503`*^9, 3.807584848186865*^9}, 3.807584940044697*^9, 
   3.8075850293461995`*^9, 3.8075851397366233`*^9, 3.8075853610442142`*^9, 
   3.8075854414340563`*^9, 3.8075872665406756`*^9, 3.807587837725031*^9, 
   3.8075879415974426`*^9, 3.8075880149843636`*^9, 3.8075881212692966`*^9, 
   3.8075882507989025`*^9, 3.807688729312798*^9, 3.807688774587732*^9, 
   3.8076899504152765`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N4 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "4"], " ", "\[Eta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Eta]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Xi]"}], ")"}], " ", "\[Xi]"}]}],
  SequenceForm[
  "N4 = ", Rational[1, 4] $CellContext`\[Eta] (
    1 + $CellContext`\[Eta]) (-1 + $CellContext`\[Xi]) $CellContext`\[Xi]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8062590823057947`*^9, 3.806259097973392*^9}, 
   3.806259175696431*^9, 3.806259235818915*^9, 3.8062594835796647`*^9, 
   3.806259837088747*^9, 3.806260097339182*^9, 3.8062602687588577`*^9, 
   3.806260721922427*^9, 3.806260779722968*^9, 3.806260836658532*^9, 
   3.8062613175034027`*^9, 3.8062615862506227`*^9, 3.806261616459861*^9, 
   3.8062619382921762`*^9, 3.8062629289174805`*^9, 3.806263055915275*^9, 
   3.8062632262409806`*^9, 3.8062931923931503`*^9, {3.806293287398672*^9, 
   3.80629331432297*^9}, 3.8062946378074465`*^9, 3.806295198613818*^9, 
   3.806295342435067*^9, 3.806295437953574*^9, 3.80629566011378*^9, 
   3.8062958163467045`*^9, 3.8062960600773478`*^9, 3.8062963080458784`*^9, 
   3.8062965247542257`*^9, 3.8062965750749135`*^9, 3.8062967379346647`*^9, 
   3.80629683319018*^9, 3.806297026586136*^9, 3.8062978267092657`*^9, 
   3.8062983816677885`*^9, 3.806298706519038*^9, 3.8062987723383217`*^9, 
   3.8062990539069767`*^9, 3.8064204980627546`*^9, 3.8064209366744537`*^9, 
   3.806421037896655*^9, 3.8064213537014556`*^9, 3.8064215020288677`*^9, 
   3.806421854082852*^9, 3.806421939465147*^9, 3.8064223470867105`*^9, 
   3.8064226000405397`*^9, 3.8064227228136964`*^9, 3.80642293151746*^9, 
   3.806423066237996*^9, 3.806423238144845*^9, 3.8064235353105392`*^9, 
   3.806424468405384*^9, 3.8064245332407374`*^9, 3.8064246366001854`*^9, 
   3.806424916616871*^9, 3.806425041332559*^9, 3.8064268259520807`*^9, 
   3.8064269186331015`*^9, 3.806427208709411*^9, 3.80642812760346*^9, 
   3.8064630639345775`*^9, 3.8064634742472663`*^9, 3.8064636107950788`*^9, 
   3.806463664980728*^9, 3.8064644043976526`*^9, 3.80646457698627*^9, 
   3.806470850690292*^9, 3.806472353520133*^9, 3.806472621950137*^9, 
   3.806473773141345*^9, 3.806474947085039*^9, 3.8064752039026546`*^9, 
   3.8064767614024787`*^9, 3.806477120910578*^9, 3.8064842549002633`*^9, 
   3.8064845610688353`*^9, 3.8064849849319906`*^9, 3.8064854960870185`*^9, 
   3.8064861608239517`*^9, 3.806671740998494*^9, 3.806671804532303*^9, 
   3.8066826808041406`*^9, 3.8066829250504217`*^9, 3.806716956923764*^9, 
   3.8067172250921783`*^9, 3.8067179465618305`*^9, 3.8067194943217845`*^9, 
   3.806719645560199*^9, 3.806761181351988*^9, 3.8068201473682756`*^9, 
   3.806820448998047*^9, 3.8072937628997307`*^9, 3.8072939059642496`*^9, 
   3.807294871351761*^9, 3.8072951095419683`*^9, 3.8072971575153203`*^9, 
   3.807321091379052*^9, 3.8073232331147118`*^9, 3.807324530812215*^9, 
   3.8073248383974667`*^9, 3.807345830590127*^9, 3.807580386193572*^9, 
   3.807580468103498*^9, 3.8075806338093395`*^9, 3.807580678627002*^9, 
   3.807580935339381*^9, 3.807581203655674*^9, 3.8075813198791003`*^9, 
   3.807581377446286*^9, 3.8075814640853834`*^9, 3.807581548973415*^9, 
   3.8075815804945197`*^9, 3.8075819698678913`*^9, 3.8075820517011924`*^9, 
   3.807582121220319*^9, 3.8075822102646217`*^9, 3.807582385486492*^9, 
   3.8075825442417965`*^9, 3.807582655582506*^9, 3.8075828016042333`*^9, 
   3.8075829525023985`*^9, 3.8075830819067245`*^9, 3.8075831396137285`*^9, 
   3.8075833516426926`*^9, 3.807583416927528*^9, 3.8075834852050734`*^9, 
   3.8075835582480187`*^9, {3.8075837035019307`*^9, 3.807583719427539*^9}, 
   3.807583802836999*^9, 3.807583866939765*^9, 3.8075839747357597`*^9, {
   3.8075840416212654`*^9, 3.8075840616927977`*^9}, {3.8075841423332024`*^9, 
   3.807584161521321*^9}, {3.807584313544323*^9, 3.807584333401832*^9}, 
   3.807584412152753*^9, 3.8075847108037214`*^9, 3.807584787749139*^9, {
   3.8075848187481155`*^9, 3.8075848481178546`*^9}, 3.807584939975685*^9, 
   3.8075850292615614`*^9, 3.807585139667612*^9, 3.8075853609595833`*^9, 
   3.807585441355931*^9, 3.8075872664560413`*^9, 3.807587837656022*^9, 
   3.8075879415284233`*^9, 3.8075880149153547`*^9, 3.807588121201116*^9, 
   3.807588250729895*^9, 3.8076887292188005`*^9, 3.807688774501734*^9, 
   3.807689950422276*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJyNnHdYFMn39RVzzmENmFjMec1IqRjAnMN3dU0ouoqKEbNiWDEiCiiyKqiY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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgT9Ubx++55yqbkJGVVDIy27QnWjYlSUilIi1piRJpqaRBhewRoiVN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           "]], Polygon3DBox[CompressedData["
1:eJwtmmXAVUUXRs/MXEJUBBQBG7uxO7C7sBMURQUVW0ARA7sAC7EbMLFFxQ7s
7kDF7tbP+tZyz495z6w758Z7zszez37m9NxrcJ+DctM0e/KnxbF9aZqdOS4L
H8MLd8L7O56Cl4QPgjdg/Bx4DfhYeHv4Ynh5+Ah4C/h8uB1tY3gd3v8C/QUZ
3w/uzfjp8Ky0XeFtGX+H/lKMD4Y3ZHwUvBx8OLw5fB68P3wDfAJ8K7wCfCS8
JXwBPBttN3g7Pu9d+qszPlxmfBzchbYjvDXjb9OfXL9vAHw8fB98MLwvfAK8
BHwgvD7vPxu+p/LejI+AF4cPgNdj/Cy4E217fw/jb9LvTNsB3gp+i/699frt
Ax8Hd6Xt7vWD36M/O20PeAf4ffqrcv7RcB8+fyzcjdYX3pHxD+ivyPhRfj7j
F8JP1P/38BS/9+76+/rDx8Krwcd4vTn/IngW2nbeL8bfoN+BtqXXH36Z/g+c
ty7cg+NR8Dscl4RbHA+Gl67XayN4NPw3vDK8DO9/HN4aHgMPZPw6+Cl4BHxk
ivs7FT4BHgaPgbeBz4UHcf718NPwifDRjJ8LbwufDx/I+AT4GXgkfEyK+bEZ
fJb3h/Fr4Js5fg5/QbuF/nOMn0z/2BTzpQ98HnwAY+Ph5+FT4BEprufvvL4J
3JPjUPhzjqvCnTkeDr/FcXE4czwIfqX+v6fz/kvhL3l9dXhWjkfCL9XfNzLF
fPyD1zeF5+c4DH6b4xJw4TgYfq3+vjM5/3L4BfgM53+K+fAifCZ8Yor7+Wq9
fmfAl8Fv8jmLwYnjgfCGzhF4CuOd2rCO4cfhB+BZ4A85bzl4Bo6HMLYsn3cY
vFmO6/8PvCa8Iuc/Ab8Mnw2flGL9f8F5q8FdOB4B/8v4WvBKjD8JP1njxREp
4sef8Irw0vCj8Cb1/9uL918F/wWvBPdi/DG4LW0j4wf8PP03GL8APhu+Em7R
NoDXgp+l38b/GV4bfs4AR1ubw8rwU/TX4/0nwbvzfVfAm9br2R++Gl6zztcd
4Evgdet82y3H/Ui03vAqfN5U+uvU+bprjuv/Ecfl4Q4cD4ULbX14Tc5/hv6i
nD8IXpfxM+Fl4EPhTXOsh5c57yX/N68Hbf06f/fI8f8+W3//8BTx1vm6Ezxf
jng7A20L47WfQ38l2k3wdfC/xgNjPHwTXLj/q8C3wOPhBN/H58wIT4d3NR7R
boUnwJnxNY2J8K1wW3gNY45rDW4DT+L95pe34T6M3VHzzLvwdsZn2l3wzXCL
8ycz3gH+GN6Fsdth/sXmHXhb4yc8A/wRvLPfDbeHP4R3gtfyHHgS3I7PWw9+
EL4Hngl+lvPnhn+B9zN+wHPBP8P7Gs9pF8LnwD/RX5J2ETwa/sV8QBsLj4J/
Nl7w/l7wr/Bk4xU8J/wTPAC+H54J/gTezflDmwLfDc/I71kavgy+EP7N+UN7
AL4L7sD4ysYw+Hq4gXv7mXTvhGeAe8GXw2Ph372WfF9b+H14B+MDvAz8G3wf
/FmO9TNLjvj8aY710THH+lqQdhw8lPO/of9BjvXSluND8LQc870dx4ddfzni
/b+cPwX+JMf6mznHej6Om/cIPA6+Ez4Yvs34CN8GT8+xHmbi+Ah8COO3G7/g
2713HOeDP+Pz7zZ2wQvD38L3OHfzf5eleQ/eHl6Idip8HPwt/cVoo+DT4B/p
96QNhQ+Bv6Q/D21fuB/8Gf05aXsbD+Dp9OemDYD7wp/Sn4u2j+sP/oT+6zni
0z/wA/C8tIHGL/hz+u/liH9tOD5oPM8R7/5m/H54ftow+FD4K+MB7Rz4VPgH
4yXnLwJ/B98LL0w7DT4e/s54QbsCvgj+g/4KtAnwlfDf9Kfy/jngH+F9XHhc
334cFuH1V43POfTEwhxfMb7n0B8L5cj/f+bQUwtwfBH+O4deWTBHPOld8/cu
OfKd67EbPI3vuwv+NYf+mSdH/P2e49Zwtxzx8rccemzeHPH8hxLv71D/319y
6Km5c8TzP0rM50VTzL9fS1yf+er8+wp+DL4f7sjE+L3E+lwkxfzdE74aPprP
u9n1UuOv92s4PCNtK3ijFNejPW1zeP0U//8E3vcR/KUxj/53vL8T/f81MT/7
wVfRH8bYTfBMrfh/N05xvV/h9QXhP+FB8C6cfwl8GK/fAHdvxf3ZifFp9DvS
toU3h1+nvzPnX+x84fyJ8Hc5fu/sOfLZtzn0W9cc+fYzzn8ZfjrF+nuE12f1
98N9jTXwzPCn8O7wY3BX+Gt4T7hdifXRK4defpTjbPBXjPeDWyXWy5I59OPD
HLvAXzC+B/wU3AP+Ad4bfgmeH/4D3r/O7+7w93B/eHnaePgK+C/6y9Kugy+D
/0d/Odr18OXwn/Rf5v0LeP3hgXCbEutzqRz6u22J9bt0Dv09FL4PHgPfAf+c
Q//OlSMf/5Tjes/J8WnnX4l4M29d37/BS7teUqznr3Pk19ly6KHM+F7w4vBr
cIH7w0vkuH9ztIJ34/0f0+/RivN3hT+i/yPnz+v6qPnkpxLxr3uN36vwOTub
G2kf+l7Gr2H8GF6/BV6f9hB8L+Mztwl9YXxZJ0c8eqDquUGMn9SKHLhQCk1v
buxqHKI/nTbRawJ/7fygXey9yjGXndOuZWuCTeBtmqgVOuXQZuYYc42atk+K
mlKtqwZeL4XmVRurEddNobHVjmqEv+h3bkI7vJVibbnGPldr0qbRH2+e5f87
C/4Avt44B58Jvw9f57yD7696aiCfM7IVmqNJsQbUIqcx/g79q+nP3iY0/jYp
NJRa6nTG36V/jXGtTWiQf5qY42qTUxl/uwlt1pXxU+C3nL+uM/hk+E3nq+sC
no32iFo3xfnmrJxiTZnLrCmsla2ZrTUUT9ZS5lhz7RYl9MIA+t9z7tol8ttO
OfL1hiX0Sd8c+W+rEvlhvxz5b8sSemHfHPll+xLrSRNAvWO9eTq8TY58tFaJ
fLQj/DXcq4Q+2Bj+At64hD7qlyMfnQi/Bl+So54YCb8OX5qj3jgJfsP1DHdu
E2t28RQ1h2vZmLAYvGwTscKaZVl4lSZqGWPmEik0tbH09xS5wJyg1rEGWy5F
jWZtZo26QooazNq1fQ6t3rsJLWONsyq8ThO1jxp9tRQ1r9rdGmz5FDWNtdnK
JfLv1jn0gxqrlSJmqr2MiXOmiEnGyn/ga1No7kG891f4ghT3cDe4PdfgjhSa
bpi1OuNLwivAr/L+R3ltCP2Dee0MxrrBs5eIAye2ou2XogZ3zBr8qBQ1i7W5
79FneaTEZ83F992QQwNPqevLnJbrenNOOjefaWJum0NvzLH+za2b5FhLrilr
FWOKudMcaqxRI6mVzBnzw6vmiFPd6fcw9tBfnfH1GP+4jhnLjIGe45zaHz6k
ibnmHD8lxRx07htTN0sRo421xug1UmjIn+ocHZJijjp3zWFzpci55rYh8KZw
H/jHHBqlbYoaQu3yeYpYa8xVe1pjzJQiR1l7WGOoTbrV882hc6TIaeZWNf8C
KTwBawFrigVT1PTWGuY4tYqaxdynJps/RY2uVjNH9nRON5E7zaE94J5N5FZr
oo4pcqq1kjVFlxQ1h7WGNVqnFJrP2k2N3L7+XrXzJPj2FDlwYIkcaDx6uonc
qAZfKoVGVZsf3Yp8s6dhs4RmnSdFTlTL3ghfA99oDiuhIWZLUVM9UHOiXoEa
2Fx5LXw+fCm8eYma+uQUHoK1tppabW3Ong/esYQeGJyj3joKfgo+J0e9qUen
V6eH17WEx9W/zscZ6/xzPrlGXCt6dnp3emKzlPD89P705GYt4cnpzenxdS6h
EW9IUbOoHfWY9Jqs8fUmrdH1ro6v62GZHLWE81/tNLyuD2uCmUt4qHqpeqB6
rXoqelsnNOG1uL6G1vnr/F+ohGfqGj6jNmOBnp9jemh6aXoqeqd6Ypem0AR6
ZXosei16gnq3epSHpfAU9S7NiQPrenN9qgkG1fU9ZwlPwtpkWF3feop6i3qI
eqMnwwek0BRzl/DsLk6hgfXy9PzGwVc24QXunKMWM2eZu/TY9Nr0NPQy9eT0
5vQ09Hb1pa29zTHmGmsMvbXRTdQeeiB6P3qCeiN6LnpfenB6MXo0emd6Yno3
ejxnpfDU9H70mMbA45rwnvTQ9NL0oPRK9dj02syJ5kY9Lr0uPTy970Ny1FrW
XDvB++eoxcy55l49yPNSaHy9yaE5vBM9lL4lPMdLUtQkepHWDBPhSU3UEtYE
V6fwvK0V9Az1DvWo9Lb1fPR+RjbhvetZnZuiRtDLska4Cp7YRO1wJO1J+mfn
8GdOYfzAFB77vOY2eHAKT30B13MJ/+HIHP6Ev9nfPiRHvblHCb/oqBz+gznN
XHdEjlxnzjO3jay5cL8S/sxxOerTvUv4P8Nz6PsBJfyjY3Po+31L+EsjctQD
XmOv9cE5/JgDSvglJ+Xwsw4q4fecksO/Ohp+Fj4vh19yYAn/5WQTHnxECT/0
rBz+02El/NAzc/hhg0vo6VNz+F2L5qjN+vGatfQQ2lS6o3L4TSPgF+GxOfT3
MfBz8Pk5/Jzh8PPwBTn8n2PhF+ALc/hTagBz77k5tMGp/k8p9lR6Oj95fWqK
7/C73AO5DZ7cxN6I+Uv93KXmCz0YvVU9Cr0ZPZ5eVU/q/Vizqq8713ynnupR
85n6696a77rXfGWNcWMKj8baw5qke81P6i9rlm41fz5f9ZZ6Tn2nvrI+UM+p
z9S3elDqW/Wd9YI1vXpO/ac+0yOaDD/chHd0Wo7axnvivTk+h9fnnHJujfYz
UtwT7401r7XvS014UXpK96XwpPSa/vNsaj7Wy9Ej0CtQT+p9WeNZ6+kh6OVM
qfnb/PxG1ec9a/5Wn+oh9avx3bh9Bu09+tcy1r1NzCm9Vue8c+3mElpIzan2
vLVEbWRNZG10S4nayJrA2kDNpDacMYeWuqmEVlXDqmW9PhNrvvJ6OWcn1Hji
9XKN6P26pg+omlBtuDBtkRJrQq/RNe1acQ2Nr/HKtTWhxL3zHqrNJ8GbNVHT
WdtNLKGV1eBq8etLaHU1vlp/dInayxrKWmpMidrHmszaTM27EPhXCi2sRvP6
zFG1220ltJs1p7Xn7SVqS2s2a7cb4TWa0Pxqf9e03rIxxbV+Q4laQE2vtr8D
3qWJGtVaNdXPX6xqH9eoXq0xxbXrGr2nzj/XrjFFL9YYZKwxBo6t8d/YaIy8
qOa/vjX+j6v50fhujLi3zu8RdX1PrvPT+boj728Hzw7fzdhe8NwprtHjOWpM
57v6zdrTGK2XbI1n7LZmfTxFDLKWVc/rjRnjtmlFzftYihhpLXxuiVrGmtTa
1Jis92KNaKxWg42q+Vhtpga7ta4/tZk5Re/fmG2uMebpZRtzjYXGyEk1Xg2p
69X4pR4dWtfzVTXfGc/MEVfW/OX6tkbVm7fGtXY1R+gFqREH1Hw8puY/8505
44qan80l5ozRNd+bS6x3rN3dX7E2P6/Etbams7YbVSKWGlP1Jt4qkcvNseba
N0t8l9+plni7hLY155v73ylxr73naiE1r1p3n6qF3y2R+9VMaqdpJbT0fzkf
/qDEtfgvh8Pvw9c2ofHUervW7zu8avH3Smg/NYXa4pMSc8k5ZSz91DXfRAw0
Fg6s33dirQ2mlNACajq13eMltJ6aUe34WAntqCZUGz5cQouqGdQOD5XQDuYs
c9eDJXKXGkOt8XoJraYGU4tNL3HvnQPmso1aoU8eTOEPfMz4HU3kHHPPhyVi
mzFOrfRRiVykRlerX15ibVjzWfu5Rryf36RYO5eWqM2t2azdtmjF2ngiRXze
vBVrwTXj2tmqFfn5qRT+0matyM+uGdfOhSVqLWsya7ONW1GfPJTC79mkFbnI
NepavaBE7WZNaW25ZSv0wJMp/KrzS+Rac6615qatWNvWaM7PrVuR+9UA+l/G
hHbmqhSxYnyJ/KBHolcyrkStb01mbXZRidrMmtHa8ZISud6cb615WYlaWQ9D
L0OPoGMTXqDewRUlcp850Fr2yhK5zxxo7XpdiVxvztfLubpE7WtNbG08tkSt
ao1qrXpNCe/RGtla+aoStbM1sbXxtfBSTXiUepVe04dqftdbuynHHv+0JrxB
PVS91P7e4xK/2d8+Hf6ixJ6D/s86TfiXF5cY+4T2Zf089YKe+TfONfjjJjx/
/Uc9EL2Qz2hfl/CUfbbDPQy9Zu/J1Ko3/D3Wg+Ymc5T1nh65z1q4p6F3rmfv
XnTvJrz8c3jtmyaeWfD79dx9VkU/0nrS+sL6x/rGekpPz3rKesh6Q8/Oteka
tV7R43MvyXpL70+P0Pry+CbqL/d4fNbDPQT3ftzTca/YPQT3etzzcO9Dj9u9
IPfE3BvTY5+nxB6JeyX6we4lOYedy64ZvVjrPetj61vrNfdA9I/1i9XP7gm5
N69f7F6Rz+z47I57TB1L7AnpJ+uHulfknrZaSE2kP+szQz475B5VhxL6XG1g
DjeX+0yNz9a4p9WpxBp2LbuG9I7dU/JZAfdAf6kazVjgmlS7uQej3t+zCd9N
T9NnJawZ9DqNUcYq17zeps/k+GxOP9dciT0F9/rdE3WvQQ/UZy+Mcf95o63Y
23EPwr0C9yx8dsg9M/cyfAbIZ4Hco+tSwnN079J6XC/SPQT3EvY25pXwYN0b
tF61XtYDdi9Uz1Jv2Hraetb61nrXPSKfzXCP170j/X21pJpSP///uqK9fg==

           "]], Polygon3DBox[CompressedData["
1:eJwt13e4FNUVAPB9uwuKgqiohKKIFCM1dEOVbmhKT2hGqpGmUiRSLFQVBBWB
KKBGignYgoAF0CAgSlPp3VA/FEFRMYqAv/PN++N8557fnDtvd3bm3nklew5u
NyidSqU+FnlEgWwqVQ50yUml/iJGqktmUqkbxfXG9R2bJC9RlzRupKeFeT8b
z2JH1AVFfraCvcy+U18hirJPWAvzX5Y/Z7vZRD1vi5tYY9aS/WJ8mh1XFxYl
2IdsNjuhvqAuJFazlayOfNh5i8fnFCWMG7L79f5d3y3sH+Ko+ipRgK10/Hl2
TF0oPiNbxd5kV8vVWB32lfEr7Hv11aI428BKxWcWN/hbDdSPZ5O/HZ+hmHFd
NkH+p/qMeVeKYuZ+yuexH9TXiOvZRlZV7xj5dbaM9dYzX/yovk7cwDY5/h9W
RK7NGrMzxjeae7s8gj0onla/qO+kcTbm61vreBH2u5jveG31OPmU+ks9l4pL
RGdWjBWNyCbXdrz8kvrb+G1FEedbz0vE94/v7Hg99UT5C3VH4+H6HtZXT30V
r8R6sD5xr7F1ognrwwaxCnE99bVlj7LHWS22QbRiA9kwVk39iWjB+rMhrIr6
U9GSDWBDWVX1etGM9WP3sUrqnaIHe5hNZE3Vlfzd4WwBe411YxXZMDafzROL
1TeLvmyG+jkxX/2x3qasr3qwuRXVlfmDbCF7nXVna0Vj1psNZOXVpfR1juvG
JojZ6tX8Nna3+m/6yqo3itZsEBvOqqs/zCTP47Fsch/G/fhBJvkdjmaTZzae
3ZLGd7JHzJ1k7q2sDLuLTWUzWXO2SbRhg+MeYjXUpfX9OZ55NpXVZ2tEI9aL
DWDl1GX1/ZVNY7NYM7YqkzwDR7LJPRL3yh+MR7BX9b2hrwfbJXqysWwya6He
IbqzMXFdWBN1oXguRWHnqBn3iPy5uoPxMH1j9NWNe01cKa5zvEZ8b3mu+ms9
aXGtvjV8M7tDvo+NYDXV14pr4hkxp5Zjj8kF1Pnj7xtXZaPlK0R5467m9jQ3
7XhBVoF1Y71YJj4Hq8i6s94syy4Xl8XfcaxafEe5oPqK+PvG1ePezH0uD5qX
R+SNNYFtYe0cH6Ie5Xy11XtE73hG2VOslbq83sHsRbaQdWQV2H3sJfYq68xu
YffE2s1eZG3Y71k/NpPNZa3ZbtEr1gs2hbVUbxfd4nqw8ayx+jPRng1lo1md
+M2crzK7i/VleVk5FhvPXLaAdWLbRFc2io1jjdRbRRc2ko1lDdVzxFfqVKyf
0keOn4/rLzdgzdixeJbZz7HviFLsC/Yt+yZ3nYv17h2f42Jcd8eaqlvrO2mc
wwvLzdkd7LTxAX0D5afYDNYh1nDxa6zhsT6LFebtZffqe1L9rL626v1iAJsS
6wZrH2uuGMKmszmsa/ze4gH2bKwFrEsmWdubs3tiPRAn1Pt4fzZZPV1fu9y1
pFM6Wf9jHziZjRvOc8CaqdsoT8U1Ys/IS9jbcR1s/Mszyb24L5vch3E/Lssk
9/vebHK/xn27VFRh7czr4nz51EfEY7FHxhrJ7lX/Ev2sAqsoVsezKMamk7U0
1tQL2WSNHZpO1tJYU8+qvzf3J+ObRWXn2+z4GXZWXVZUYlvYW/FMytVZXfZ1
rIXsSXlxfDf2QHwO5yzLOrEe7EI6Wcf7pJM1N9beb9UX4plkTdSt9H1jfCkv
JbdnXdmv6eS75ZfrxvtB7D96zrECrJ66ib4jxpfEGizfGXsq+ymdvF/dEu9A
rKXYrs4rSrA71J30nTX+NdYDuT5ryo4a/8guxPcXNdh2dpZdjOskarId6eSe
PJ973eP6D3D+tCiaTj5vfO5P1Yf1jWJz4vcwt1dcd5GH1WD12AHj4+x5+X32
EXtU/T/xEHuBvcLuVh8SI9ns2C9Zz0zyd4ulk+8a33mEOhPvaayVur2+7+M8
meT9Jt5zFqlPqLPxPmXcmnVw7Afjy1gZuSPrzs4b54n9RW7DOrIfjX82/xK5
FmvADhr/n+WVa7L6bL9xPnNLyx1YN3bOOH/s83Jndhe7GPupuU/Ii9gSdr/6
9njHYlvYTjaezYjroL5cXMbec7yKvtHya2wp66Nnkciw0vEbsb3GtfVNllew
NWyonsVxHViZ+D3ZvvgN9U2RV7K1bEjs+Wwq+yAneZcfzt7JJHvJ/myyH8a+
GM/+s+yjeCbjGYl3ejGNfaheb+6DsW+zp9gqto4NY39kk9g77AM2iP1L5LCb
WDm22/g7dlpdIp5Xto69HnueXJ5VZ4fjerB8cjlWjR2K9wJ2Tl1clGHb2Bvx
2eWqrDY7YfzvuLfkUqw822P8XiZ5LziYTfbw2MvfzSTvAAeyybtDvEMsjPXJ
vGKitLlbc/eFU7lreKzlPfWvyCTvyIeyybtwvBO/n0neC76MddW4cFxj40fY
m7GfOF+/WEvZw/HZ2XLWl93GprM1bAN7iLVkr7CtbA+bxFqxeWwb28seZ63Z
fLad7WNPxJobe6bxC7Heibbx28ZeoydH5HVsWaxnfJa8nm1hY/Q0ZbPZxpzk
HHGuP8U7PvuM7WITWDM2h22KtYqNZc3jfYptZjvYONaIzWDr2CY2ik0XB9SZ
2G/Z8nhG9S2Qd7D97Ek9z4h96oup5H/QpY7fqm+ivJyvYgMzyf4xLp3sWbF3
vRXvgWI8Wxp7r77+8fuwCWwZW8kGsOdizVLni2DvOt5Q33PyWraRjdTTmM1k
H7PNbDR7WuxVn0+209Tbjs9kh1mBeNbZ+2wa26M+F+9+Ykms6SYslHfyA2yy
A3eyV9kudpBNYf/NJP9DHo/1yLiM+A0hPNI8
           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0jkvBVEYgOGxr9cS0RINUVCKglIUVCIKOqKgIBEFpULodPwCWiL0Ejr7
cu1rRMTW2NfwnETxznMy92TmO5lb0t7b1JMQRdGwXhXWj7rUbGIU5XGBxVxn
JU9Zywc28pttzE6Kopi6rcs5yGqOsp4TbOEUOznPfi7xntd817aewz0tG2iH
K4xzlbtc416Yifvc4AE3uaXD8BwecYfHjPOEuzzlHs+4z3NOO8cNP3Shl3BG
jZlti0NcZB/n2MFJNnOcdRxhFQdYxlJ1WWewlZ/e0cA71vCYFeFcLOKtfVd8
U66ewl4VmjGHBYwxn9lhD7MYYyazmBHex3SmMkVp1klMDd843OOvkvUTftOX
jBHNuNz+/x/+AMQfSu8=
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{690, 1000, 473, 689, 1106, 912, 691, 1107, 913, 692, 1108, 
        914, 693, 1109, 915, 694, 1110, 916, 695, 1111, 1006, 1206, 696, 1112,
         917, 697, 1113, 918, 698, 1114, 919, 699, 1115, 920, 700, 1116, 921, 
        701, 1117, 922, 702, 1308, 1001, 923, 1002},
        VertexColors->None], 
       Line3DBox[{704, 1007, 1207, 703, 488, 705, 1118, 924, 706, 1119, 925, 
        707, 1120, 926, 708, 1121, 927, 709, 1122, 1008, 1208, 710, 1009, 
        1209, 711, 1123, 928, 712, 1124, 929, 713, 1125, 930, 714, 1126, 931, 
        715, 1127, 932, 716, 1128, 933, 717},
        VertexColors->None], 
       Line3DBox[{719, 1010, 1210, 718, 1011, 1211, 720, 504, 721, 1129, 934, 
        722, 1130, 935, 723, 1131, 936, 724, 1132, 1012, 1212, 725, 1013, 
        1213, 726, 1014, 1214, 727, 512, 728, 1133, 937, 729, 1134, 938, 730, 
        1135, 939, 731, 1136, 940, 732},
        VertexColors->None], 
       Line3DBox[{734, 1015, 1215, 733, 1016, 1216, 735, 1017, 1217, 736, 520,
         737, 1137, 941, 738, 1138, 942, 739, 1139, 1018, 1218, 740, 1019, 
        1219, 741, 1020, 1220, 742, 1021, 1221, 743, 528, 744, 1140, 943, 745,
         1141, 944, 746, 1142, 945, 747},
        VertexColors->None], 
       Line3DBox[{749, 1022, 1222, 748, 1023, 1223, 750, 1024, 1224, 751, 
        1025, 1225, 752, 536, 753, 1143, 946, 754, 1144, 1026, 1226, 755, 
        1027, 1227, 756, 1028, 1228, 757, 1029, 1229, 758, 1030, 1230, 759, 
        1031, 1231, 760, 1145, 947, 761, 1146, 948, 762},
        VertexColors->None], 
       Line3DBox[{764, 1032, 1232, 763, 1033, 1233, 765, 1034, 1234, 766, 
        1035, 1235, 767, 1036, 1236, 768, 552, 769, 1147, 1037, 1237, 770, 
        1038, 1238, 771, 1039, 1239, 772, 1040, 1240, 773, 1041, 1241, 774, 
        1042, 1242, 775, 560, 776, 1148, 949, 777},
        VertexColors->None], 
       Line3DBox[{781, 1149, 950, 779, 1150, 951, 783, 1151, 952, 785, 1152, 
        953, 787, 1153, 954, 789, 1154, 955, 791, 1155, 569, 793, 1156, 956, 
        795, 1157, 957, 797, 1158, 958, 799, 1159, 959, 801, 1160, 960, 803, 
        1161, 961, 805, 1163, 963, 807},
        VertexColors->None], 
       Line3DBox[{806, 962, 1162, 804, 1255, 1054, 802, 1254, 1053, 800, 1253,
         1052, 798, 1252, 1051, 796, 1251, 1050, 794, 1250, 1049, 792, 1249, 
        568, 790, 1248, 1048, 788, 1247, 1047, 786, 1246, 1046, 784, 1245, 
        1045, 782, 1244, 1044, 778, 1243, 1043, 780},
        VertexColors->None], 
       Line3DBox[{809, 1055, 1256, 808, 1164, 964, 810, 1165, 965, 811, 1166, 
        966, 812, 1167, 967, 813, 1168, 968, 814, 1169, 1056, 1257, 815, 585, 
        816, 1170, 969, 817, 1171, 970, 818, 1172, 971, 819, 1173, 972, 820, 
        1174, 973, 821, 1175, 974, 822},
        VertexColors->None], 
       Line3DBox[{824, 1057, 1258, 823, 1058, 1259, 825, 1176, 975, 826, 1177,
         976, 827, 1178, 977, 828, 1179, 978, 829, 1180, 1059, 1260, 830, 
        1060, 1261, 831, 601, 832, 1181, 979, 833, 1182, 980, 834, 1183, 981, 
        835, 1184, 982, 836, 1185, 983, 837},
        VertexColors->None], 
       Line3DBox[{839, 1061, 1262, 838, 1062, 1263, 840, 609, 841, 1186, 984, 
        842, 1187, 985, 843, 1188, 986, 844, 1189, 1063, 1264, 845, 1064, 
        1265, 846, 1065, 1266, 847, 617, 848, 1190, 987, 849, 1191, 988, 850, 
        1192, 989, 851, 1193, 990, 852},
        VertexColors->None], 
       Line3DBox[{854, 1066, 1267, 853, 1067, 1268, 855, 1068, 1269, 856, 625,
         857, 1194, 991, 858, 1195, 992, 859, 1196, 1069, 1270, 860, 1070, 
        1271, 861, 1071, 1272, 862, 1072, 1273, 863, 633, 864, 1197, 993, 865,
         1198, 994, 866, 1199, 995, 867},
        VertexColors->None], 
       Line3DBox[{869, 1073, 1274, 868, 1074, 1275, 870, 1075, 1276, 871, 
        1076, 1277, 872, 641, 873, 1200, 996, 874, 1201, 1077, 1278, 875, 
        1078, 1279, 876, 1079, 1280, 877, 1080, 1281, 878, 1081, 1282, 879, 
        649, 880, 1202, 997, 881, 1203, 998, 882},
        VertexColors->None], 
       Line3DBox[{884, 1082, 1283, 883, 1083, 1284, 885, 1084, 1285, 886, 
        1085, 1286, 887, 1086, 1287, 888, 657, 889, 1204, 1087, 1288, 890, 
        1088, 1289, 891, 1089, 1290, 892, 1090, 1291, 893, 1091, 1292, 894, 
        1092, 1293, 895, 665, 896, 1205, 999, 897},
        VertexColors->None], 
       Line3DBox[{911, 1005, 685, 910, 1307, 1104, 909, 1306, 1103, 908, 1305,
         1102, 907, 1304, 1101, 906, 1303, 1100, 905, 1302, 1099, 904, 1301, 
        1300, 1098, 903, 1299, 1097, 902, 1298, 1096, 901, 1297, 1095, 900, 
        1296, 1094, 899, 1295, 1093, 898, 1105, 1294, 1003, 1004},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{251, 474, 1106, 252, 488, 280, 1211, 503, 295, 1216, 518, 
        310, 1223, 533, 325, 1233, 548, 340, 1244, 563, 1150, 355, 578, 1164, 
        370, 1259, 593, 385, 1263, 608, 400, 1268, 623, 415, 1275, 638, 430, 
        1284, 653, 445, 1295, 668, 460},
        VertexColors->None], 
       Line3DBox[{253, 475, 1107, 254, 489, 1118, 281, 504, 296, 1217, 519, 
        311, 1224, 534, 326, 1234, 549, 341, 1245, 564, 1151, 356, 579, 1165, 
        371, 594, 1176, 386, 609, 401, 1269, 624, 416, 1276, 639, 431, 1285, 
        654, 446, 1296, 669, 461},
        VertexColors->None], 
       Line3DBox[{255, 476, 1108, 256, 490, 1119, 282, 505, 1129, 297, 520, 
        312, 1225, 535, 327, 1235, 550, 342, 1246, 565, 1152, 357, 580, 1166, 
        372, 595, 1177, 387, 610, 1186, 402, 625, 417, 1277, 640, 432, 1286, 
        655, 447, 1297, 670, 462},
        VertexColors->None], 
       Line3DBox[{257, 477, 1109, 258, 491, 1120, 283, 506, 1130, 298, 521, 
        1137, 313, 536, 328, 1236, 551, 343, 1247, 566, 1153, 358, 581, 1167, 
        373, 596, 1178, 388, 611, 1187, 403, 626, 1194, 418, 641, 433, 1287, 
        656, 448, 1298, 671, 463},
        VertexColors->None], 
       Line3DBox[{259, 478, 1110, 260, 492, 1121, 284, 507, 1131, 299, 522, 
        1138, 314, 537, 1143, 329, 552, 344, 1248, 567, 1154, 359, 582, 1168, 
        374, 597, 1179, 389, 612, 1188, 404, 627, 1195, 419, 642, 1200, 434, 
        657, 449, 1299, 672, 464},
        VertexColors->None], 
       Line3DBox[{261, 479, 1111, 263, 493, 1122, 285, 508, 1132, 300, 523, 
        1139, 315, 538, 1144, 330, 553, 1147, 345, 568, 1155, 360, 583, 1169, 
        375, 598, 1180, 390, 613, 1189, 405, 628, 1196, 420, 643, 1201, 435, 
        658, 1204, 450, 1300, 673, 465},
        VertexColors->None], 
       Line3DBox[{265, 481, 1112, 266, 1209, 495, 287, 1213, 510, 302, 1219, 
        525, 317, 1227, 540, 332, 1238, 555, 347, 1250, 570, 1156, 362, 585, 
        377, 1261, 600, 392, 1265, 615, 407, 1271, 630, 422, 1279, 645, 437, 
        1289, 660, 452, 1302, 675, 467},
        VertexColors->None], 
       Line3DBox[{267, 482, 1113, 268, 496, 1123, 288, 1214, 511, 303, 1220, 
        526, 318, 1228, 541, 333, 1239, 556, 348, 1251, 571, 1157, 363, 586, 
        1170, 378, 601, 393, 1266, 616, 408, 1272, 631, 423, 1280, 646, 438, 
        1290, 661, 453, 1303, 676, 468},
        VertexColors->None], 
       Line3DBox[{269, 483, 1114, 270, 497, 1124, 289, 512, 304, 1221, 527, 
        319, 1229, 542, 334, 1240, 557, 349, 1252, 572, 1158, 364, 587, 1171, 
        379, 602, 1181, 394, 617, 409, 1273, 632, 424, 1281, 647, 439, 1291, 
        662, 454, 1304, 677, 469},
        VertexColors->None], 
       Line3DBox[{271, 484, 1115, 272, 498, 1125, 290, 513, 1133, 305, 528, 
        320, 1230, 543, 335, 1241, 558, 350, 1253, 573, 1159, 365, 588, 1172, 
        380, 603, 1182, 395, 618, 1190, 410, 633, 425, 1282, 648, 440, 1292, 
        663, 455, 1305, 678, 470},
        VertexColors->None], 
       Line3DBox[{273, 485, 1116, 274, 499, 1126, 291, 514, 1134, 306, 529, 
        1140, 321, 1231, 544, 336, 1242, 559, 351, 1254, 574, 1160, 366, 589, 
        1173, 381, 604, 1183, 396, 619, 1191, 411, 634, 1197, 426, 649, 441, 
        1293, 664, 456, 1306, 679, 471},
        VertexColors->None], 
       Line3DBox[{275, 486, 1117, 276, 500, 1127, 292, 515, 1135, 307, 530, 
        1141, 322, 545, 1145, 337, 560, 352, 1255, 575, 1161, 367, 590, 1174, 
        382, 605, 1184, 397, 620, 1192, 412, 635, 1198, 427, 650, 1202, 442, 
        665, 457, 1307, 680, 472},
        VertexColors->None], 
       Line3DBox[{277, 682, 1308, 683, 278, 501, 1128, 293, 516, 1136, 308, 
        531, 1142, 323, 546, 1146, 338, 561, 1148, 353, 576, 1162, 1163, 368, 
        591, 1175, 383, 606, 1185, 398, 621, 1193, 413, 636, 1199, 428, 651, 
        1203, 443, 666, 1205, 458, 685, 686, 687},
        VertexColors->None], 
       Line3DBox[{459, 667, 684, 1294, 444, 652, 1283, 429, 637, 1274, 414, 
        622, 1267, 399, 607, 1262, 384, 592, 1258, 369, 577, 1256, 354, 1149, 
        562, 1243, 339, 547, 1232, 324, 532, 1222, 309, 517, 1215, 294, 502, 
        1210, 279, 487, 1207, 250, 473, 681, 688},
        VertexColors->None], 
       Line3DBox[{466, 674, 1301, 451, 659, 1288, 436, 644, 1278, 421, 629, 
        1270, 406, 614, 1264, 391, 599, 1260, 376, 584, 1257, 361, 569, 1249, 
        346, 554, 1237, 331, 539, 1226, 316, 524, 1218, 301, 509, 1212, 286, 
        494, 1208, 264, 480, 1206, 262},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzFmXk81dvXx5WklGhOs4arW1dliAotbrpKgwZKqEu4ym26GgiVZok0yNBI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     "],
    VertexNormals->CompressedData["
1:eJx0nHdcT2/4/0v2KiNJCJFVsiXpskKEyIgUUZSRSmQrGpS2tGhr014aV3tJ
2jvtofXOalm/c973+7y/X5/H9+ef8/icz3F3u859rvl8tfDctSNao3h4eOaO
4eHho67T0k1n3E+4nTIsHzpmiWcdVFdk/lji2QP9GQ+HjSRvpUjd61wyPbgS
LF+tFL6a2Asn/CwlFXfeTFl6ZMXsssQSWDTok7jatQ+srAoP6U4yTFHzX/9N
f0IBmA2tPj5tMwuCK7x6rrvqp8TryI1kqmWAptBP3whvFowTWzhpFq9uiuee
7uvndeLAJmR2c0g9C2ycX1jGe2unXEox9rnS5AfrMw7ulRqm1nnw/ukTifMp
POSP8chf+g8LDjrHnew8q5rSz/scph7zxM4revwrfrFgMOuIVbWOUsrWSfOP
B84KRgN9uXzVHywQq9pRJt+wIUWm7FxhkUIY8hT0PgjvZ8GNU1sHdjRskPOy
HBym74/MyWDfTxwxL63SUZJbbC1YTa/D/6Q0j15n8ydP746zqnLNDzf/4Kd+
rjiMYf/cxnvNktQ+5TjXlAHOPkN/PJbvmBqLQjZadRMMykEn+n371LF9cP3P
QcUdWtF4sNfd3kq/GAqW2wfmvu0D+3BZrW1WkXjohsBdOfn34H65PqZVkgUz
7EJXfrYKx2krTjRs2pwJZn8j56ZbsCBpquiUty2hWCAj2imdkwgeo34YGqez
IKX7ie6NZ4G49UC+dk1SOByYuDl0XBsLnj/Unuy7wA/LYnT6zYtfwXhbs9bV
Ayyo0tptJUD9exg7dz9snEr/u7bA+fF7NF7g6LgDm+Wp66usiPGzqPtlMiHr
d1Vb4qa1Uy7Ofu2D2zsWhNRR7yvhyuaYNW36uOlZ7O676v6oN7z1kfAQC0za
4k9LtenDgUVftOj7C89Ksu+HaMmN31ltCQ8VCjPpde7xjATT66SUzDfYrfGC
ueK1407sn8uxO/MeUhj7f+eralj2NR0ta8SKN5nnQ8G6QqneL31wefQHhcVK
aTjgHbHK4kgWrH/+WHPVdhZ4+z7U3b0J8e9QWX+IeSq43hw/Ke8+C3jHBVhJ
RyaiX1Vf8Pkz8TC0sn72vWAW5F7pr6meHY9J748eSX4bDpcG68aJ5bOg9fvp
eY/1o9F/Z9qVU9P9AE4pCps1sODB52LWorRwfNV6aOuMBnvY28AXLdVLrf+k
6FgQdZ4YO/+Iuco+V9V/C7cLU//+Y0GRdtspu+qUZLLt4CNd8ID+9w/wVc6g
7Z+qWcS2w7OKqwG1lfexqVHbuK7WDSftCnw/QN23kBZMqay8D6ZBP1/T93H4
Lfv+tg3PTKm/z1xxlmEnex2O3SGIvAeu/TnnHpLId5DCnP+5+/NLxk/LwcBT
otcK+iPgtbSytbYWC7TSh4KVvmXipogPJjtDQkF/XtrUh6YsWJg2ifddYTqW
3Im/cXaBP5x7369/0pP6HgV5RI76pWLknHsS/vJeIO187s++WOp7NFG9u7wr
CbW+H381sPUF1Ak9XeqTx4LlB3ffiHwcj8fiLqasT7GE9FOH2/2rWWAvo2JR
NCsan4a9Hpb8aASX+1You7azQGbJedti+jvn2HlM0mryvQvl/KTPX3HTgXOr
qHOqn5BtQp9Dsco1JfWUve61Byyl7IfXxQ3YdtNz+7p952cTvLSu8+M26loQ
m/3iDPVdH1/wp5P6b1AhV9Srq2Hf59gdrMh74Nr/IDn3zHfAPf8cvwNXiR9K
YfxPiF5eGG1nvr7B7ML+CGx/6fiUtvN71o5ntJ3v2ZZv3xMSinW3PCbTdt7U
ItaeQNm5yV9f9fwCfxSv/KxH23mQ146PtvNas8MHA+W9kHWQn23n/LO/j9B2
bt0fbTG89QVu1nFl23lagYQybeezi76AdIolOshase283lj7Mm1nzezE2Ws+
GmHgz4tsO4/RLTz/v+085aoqe//2xs/qaDtL7y18t5r67jOPVLLt/GmyZyht
53w9nmnU+YU0vcts+6wPrltG25lzhWX2kWx7XiB2B13yHoCxP+fcM98BMOd/
M/E7jB8Cxv9w/D4TB+QY//8Ab9+m/YZy/B+WtHk+1v88tZj2G9HlTX1ilN+Q
SjCf/eRIFrbzRKjRfuO8WvsHecpvLBQsCwg1T0WfGNNxtN8wezPj7ybKb4za
Z/xO80w86rebCtF+IzrMSYP2GxXlDZNT3objcpUstt9wq82KfUT5jZ4L1gdU
p/uhw58stt+QrXrvTvuNGUrmY2Y22ONPGRe23wjhqy4J/F9+47RnFft7FG2f
0kr7zdm6osk7KD+6NqGb/f3qjhKaSvsNzhWuHYtnf+8cu2M9eQ9c+xuTc898
B8Cc/yHidxg/BIz/4fh9KCFxABj/z4m7TByWY+KvUmLeqHYqDkr5aahPNCjH
riGFUjoOygwViG+n4uCRPLO/VBxE13N/3Ok4KGUTpgZUHNTXzFwJ8u9xg1vA
WzoOhs96sqOTioPKv6s1pTdnos62HcJ0HDRvkL4VSsXB4vvPvTfnJKLJ3brr
dBx85XJRyJCKg/LyEtVUHERp2WPsOGh4V/mbNxUHRb//ibcofoXOuePa6DgY
3+BVPvV/xcGwN/vZ8eWIiMNH2m9yrlC6vpBtB47dkfMeuPaXIeceHch3wD3/
pcTvMH4IGP/D8ftQReIAMP6fE3eZOAxM/GWRvIfJg+SY/Iezb56s07rXqbwO
hw8fraHzOub+aodyCyqvQzeNsDF0Xsfc/6Euf4nK6/BbxrQwOq9j7sv/Fb9u
MKEAY+NGHaLzOub+8yvfjmapZeDlJ4+86LyOuS+8c30Llddhj1dxI53XMffL
z1wde7XJD5+aTGHndYx9ef7508+9z3kPwNifuc/5DoA5/1z/TvwQMP6Huc+J
A8D4f+Y+Jw4DE3+Z+5w8CJj8h7nPyUPlmPxz1NlI/2yZd5B3f8dZh41NeM5c
fGtIdhcImfsNnV+QAKqm9rINo+rR8POUMNeTPTDDQeSI+uM4MGqtSBc5UYny
w+Zb3fx7IYxfyKnuWgzoBd/SvBdWjI/lPotO9+2DWc8aD5X9ioSlQZJ/373O
xReDXrsiD7FA9d2dteN3h4P41LK9Cj+S0fG1Z/i4OGqf4jrSz94HAy+5YhOP
zL4nn1nAsTv3PTD255x75jsA5vxz/A7jh4DxP9rE78MGEgeA8f+cuIt2JA5z
4y8n70FOHsTNfzh5J3LyUG7+qUPyfuTUAXJM/p/mbZ3UKPweNpvsWnv9SAsm
Rgtl3XXuBEe1TSLJRvlwf4/t/EjXRrwwc6KRtVUXjGva154vnQfWsqYSG9bV
YsC6dZam8j3w5uMtlfmqObDioW0pP6sMS/+evxQZ0gvNPoaWlv2ZcPj2x+Ik
iw+4sGeKyLOIPohUnDegKZzOXPHvgn2fnp5iwVJid+Y9cO3POfdcOzPnn+N3
wIP4IWD8Tx/x+0wcAMb/c+IuCJA4DEz8PUzyHlxG8iBu/hNA8k7k5KHc/FOO
5P3IqQO4+T+n7kJOHSbH1F9b16TJLdApg7aGV6WrfFtxq6OGotPmdji+XuJu
y54yuL1A5/Tkic1YzZuy4Z52J9z4Bke/vSmFiR8+FQgLf8K5y7aOs7zVBXP5
Lp1ZZ1UCjarr1kk7VOJ5U49bVbt6YH/aaruVTUXMFX3fSB8vC++FQ8TuzHvg
2l+cnHvmO+Cef47f4dqZ8T8cvw8WJA4A4/85cZeJw8DEX07ew+RBwOQ/GiTv
xOskD+Xmn5y8Hzl1ADf/59RdyKnDuPUXp+7FEFIHyzH1b9hox3PTE2rg+pUP
v9K3t+ERgSHvkYoWGO11SMCuuwam9e8Z0a9oxjij7M0Thdoh8M6QDO+zGtgx
53n1qC8NOCfeyjJKpRN4b0g3GxtWM1dUHhV9YNONLsbuzHvg2p9z7iGUfAfc
88/xO4wf4vofjt/n2pnx/0dJ3GXiMDDxl5P3MHkQMPkPJ+9k8lBg8s9wkvfj
IlIHcPN/Tt2FnDqMW39x6l7k1MHc+pfTd8BnpA8hx/QfKk8sqdy6qBFine81
zj7WhltO1YqetW+CqDUTjvrrNIIi7HJbJdSCr6W3KSSktsB3z9KQPVqNzBW9
UobXpE1ph13E7sx74Nqfc+6Z74B7/jl+h/FDXP/D8ftMHOD6f07c5dqZib+c
vIfJg4DJfzh5J5OHApN/cvJ+kCZ1ADD5P6fuQk4dxq2/OHUvcupgbv3L6Tug
HelDcPsPnL4PqpA+kBzT/yl2KZCwedAMD01FZ44e24bTZpR/0fz5Ca5bH75r
1tfMXHHPrPiz782bGLsz74Frf865Z74D7vnn+B04QfwQ1nD8zz3i98GBxAGu
/+fEXRAmcZgbfzl5D9fOTP7DyTuZPBSY/HMVyfshltQB0MnJ/zl1F+STOgyY
+msLqXuRUwdz699B0ndATh+C23/g9H3QgPSBuP0fTt8Nv5A+nBzTf0ubmVHt
YdTKXNF8k0D48n21jN2Z98C1P+fcQwX5Drjnn+N3GD/E9T8cv8/EAa7/58Rd
Jg5z4y8n7wE+kgdx8x9O3sm1M5N/cvJ+pg4AJv/n1F1MHQZM/cVL6l4IJnUw
MPVvMOk7IKcPwe0/cPo+yOkDcfs/nL4bcvpw3P4bp++JnD6oHNP/fL3CVfej
pz+u7Vkyam1nBZipHSqOr+oFydVL1iWeC8DQDY83yUpVQ+yr4R05Gr3w63Vf
7/w51swVj13d9EDlDwtOV82UkBqxg9WtJ2cl6Z5NWST0JLWBuv/S5Kiay4cW
cCdXLF54buzdgU/g/dT6U4F5C4hqqZXUZbai6KyURS9n1ANnH8jZF3c/IWQf
yNnX/+wnwq57Cs/tFINHHxSrxWvg+WHTjQ3re2EV2YecKtkXMvvh/Dzm53N/
Lufv42+ynhyzTsrfdKOJ3s64Z0XY8NS0arBwuKw6TaEXKkdvDt1zxpi5Ytul
iKHbVJ7s+1zF8MGyVuaK/slp/dem1wPn72MSWY+7TvKPlSzfn85Y+CvYxflL
Dew9dmTGqtG9MCozoTP1g4ac/A+jsEJvE/Q5G7U7klp/hekxh2eerZCUpqY8
YVQr8r3t/ym0sg6GeeQ/sc7XYnJZcPjvM7fl9PkEntZ09wDnv1M4/x+Y+7vJ
uszPSWHW56zL/Bzu+pz9IWe/3H1OWHxx3Tv3aCwLz+mI/loMj+8cfW7v3gfG
BbnRd9NupmzvaNZ4MVIKS146x766QJ3z+V9LjPmicPfDk1s0pT7ADLkAt2EB
FtwxW14+ptUwxU3v7+G9Lh9BsUJnvNkoFoR8elJw9EAE9v91y+pryIbk3Oui
s3SoOt1nut7BcoMULxNW68a4HFj/OrFruQFVh+5UuqbIE4Y5tp8XFPOngZm3
zd7EABZkHMmY3OutlzJpg6TlCuNUKI5/6PU6kQVfVKrE7HeF4CJ+U9M4vzj4
FrX31aFiFmj+nNIzOuRKyrrVn0qNJKJBUDZvvTmV5y/n13itYBCAa29NM7pW
EQor0/yPnO9iQWSToYb3t4sp/B1bx4bK+4DQ5ZuzckdYEMrp5/OyvcMt2Z+c
emrLnH7LBQ6+WPZI2ixUyA18drl/PTnIgpp/+tKGskxd1vPavP9A6umUG8Nf
7+VecsfSruAVAr9ZoO6Y3NL30BmfX+u/sdPJEXelek9VoZ6PPhUyu3Cpcorx
g6k9tXcD0C2ovfEstX57le/GQmVbvFh/PGZ2rhfqft0e40vt02CO6RrpJTtT
jvc4fYk//gZfTF0y3/IrtX8l++OHjzzEMXlx4ycN++HfzmrD5iG6TuzvXdk/
kHRVSrKVniPcv17FrjeffWUN8GeuTWGdFz36VN0flW3WmEhSz1de3J2+cclO
Ofu6nq0J1PpXvn2aR69vpdr9++CRh7C/4zzQ6wduRfb6H57knP2wVFnOX2vE
tI7af9Phm+z9z9i2cuIHZVtoWJy2SJjaP3/vHPb++xdvMV6Velrulbrentsp
7rjvjdmCP5QdTq68f4CyDxgrXkrZRdln73Qrtn2Ge78E1ZmmYVjijKeOw1lw
7NCpRBFp6vxUuMVpTkjF7l95v46+S4PRMbUGn65R9WBzecrBMckokNjll+ad
CDapE+eOcWfBOUGlnBvtCRjWLTW2wCIaMopcdfSpczWyPiEt6l0sRnUcuch/
LhSeFJ4dx1PKgub5c6Ymm0Vh44JJZX0K3rBlplfwjRYWiPCY7bDYF47H0qqM
3HfbglLyhc16fVSe+U//XFuWqd/X7W2UuODoi9G7/YI2P7DAIOdVj25R9ePh
yAn5YSJuaL2uJRYWP8d3WnwXUn9Sfu91QbfzXEuc4LH4lsAqV1Rm3TxdS9lB
7EPLmZ/7ICVOSURxUp0bSvzN01tFnSvhQYlBp7mWMGFPawL9/JOnj9nPCxdU
fHwr4gZza0/LbKPWH0xbyF4/SKgjTMvRF6SudKzbQu1n6K82ez9/N5b7S2zK
wniVzVHbHd7Ak19ii0qNKfuE2AULqmTg0ICdtWpGAGxapjH5pwsLJLtmyV83
TMPtosf3dRr5wLhGzxyhtyy4W+Oyq1AY8d7ytqIRTXe42jNpvnoqC/Yaj9oy
aVciWvGfvOjW5QBypbPP//1InduffPWh2nH4a2PUWRxvATyx47OXUXWf60EN
sZAnlP2PjzurUW4I2776JI7qZIHsP/1zJVmmfxIauKid914AvskZMNpw+BpO
C8q5epg6h8Mlwnj2qCcGfat5d7b2Djp7hYj+puwQufj1o5Hjtij+NNlaO98Y
HQ9M/5ZBxZ0nC7VaSnJ2pLg/2ZZ29bMJuiltyw+j/ECG8KflQ8dtYUjEK4F+
/pXfBvbzYTV8jmeOekJx395LGtT6MR+/stf/vO2kErUfeKkVYbaJ2s+MiHW6
9H4eG7ta0HaOkd9hL+/wBnnWl4rSdh4fl2BD21lNvidIPSMAM7/OmUTbuSJT
TYK2sxu8ieky8kHxLAG2neeI/J1N27lozcjFP5rumP2ofx5t5/kLeAVpOx8J
E29+2eWAbqmybDv/XXozibZzvFCWVvp4CzxkIM+2s/LjjeNpO1tpyIlolhui
74lPbDuP/ad/rpTE9K9UCk5n0XYOvFrnsPnwNYC4WradFdsOONJ29uIfvU2z
9g5oWwSz7eC4M/c4bWfXLJG0S/nG4PloFNtu9qqj82g722rJzNH7bALC+1ay
7dyzhffPIGVnCfU/PfTzQdVL2M/79226SNs5a6EBi17fNPYLe/0LWo5StJ2N
lZy9tlD72YZ72HYu3uNxgPYba++73X4+nIVuF0ZF037DyPitJu039AMdUo+9
S8PGsW66tN/Yn1e4gvYbzmJjqtK9E1Hz1pAw7TdCtc/vov3Gsx1Huim/gV/k
v2vTfmN3xNVDtN9ozGv0EzgXimvnPWP7jcCg5aFJlN8wSYlwYil4Y0+PeAjt
N6bFFPWbU37joZNsxcvdtnhl3BDbb4T+0z/XTmL6hyVHbuVT3ymevmoWLvPA
Ahwy1dnf6RgBr92035gqvsiF+q6hLHVEi/6uI/dv06b9xr5FnvbTVrlC3rbd
bD9Q7iSQPkL5jfjww7cm17nB7RFLtt94GuB1nfYbSwvVS+nnf9UcYT+fsOqq
Iu03Tpe6i2yn1p86T5jtN94tfniA9hv8frkystR+6iVc2fupUNk8MYHKK1Ze
360S87UYpfgGzem8Ym18c8ZDKn+wWjdmkMof8HDfZgc6fwiE4UplKk+Ii7il
ymrIRlGtpDl0nrB6T1TiPiofaFVa5EDlA7ixUns3nQ+InJ/tb0vF/V3PQxbF
+8XhiayEl3TcH+WVqraXiu8VJ3Ol9SpCMUe7kx3fx5z1uS1KxesNGanr3wi5
4brs+d/oeJ3I6Z+T+G6YFM7p30ahknsvFZdn3dYdpuIyvPyax447Nj22xgVU
/F3F27SEil+wLHYhO34du3HO6xAVZyMubXWi4iBc0jNlx8HaMbr9U6l4Wrrq
+2cqnkJ6XK4xHU9HeyftOUDFTQ3Lz+/p5/mzdNjPL9AUOvqeio8m+/c70utn
ho9E0+s3nhEYQ+0HPNQ7t8tT+3HfFcXeD1O3hOUWb1+2vwrX5uv5N7r9T598
39LZ8VT+hkFJVwPp/I25vw2LG6g8DR83a/w1HfU/67wcY3hkU1wObhB1aKPz
MeZ+nkx5JZV34Sq/4Vd03sXcDznYuu6WRDRGHatYR+dXzP3906LUqDwKAwx2
sfMonn/+3EoiV27/nKdWaydP3iV3SMmxYedFzH3JsDOnqfwBFMSfs/MH5r6w
c+p9Kg+BzmN+7DyEue+Z53Kb7p8/nbn7f/fPefCJUD79fJKM+j/Pr3Dd/4Ne
37JQ7J/1N5/ufJ9P7Ud3nwR7P+Zp/oOCexLAdvTTuiXR9Xi6fHhk9Moe2Lg/
7adIfxy4FHUrvMupwmWdhV9mnKLsb6FRILA1FipGW2xwKS1FKXkN0cuKfZB9
sFtg6xYqH826E/BqQiGqBgpkNPGw4EFR8X2TnxHwKrrKQWVCFq7Ldx47+x6V
V9cMC0uJhoHVm+vZc8oScJfKdZHhbBYUfOT7fpQ/GHyS1C9Nvh6AXb3Tt2f3
UN/dP/1z4ySmf84a/pWsq+QJwr+X1w2+9Abh8wknaX/4vGn77Dl1z0HBTvSG
4Yq3cHlXyW8Bym5i4o1KUGUKRS0592orIkGvvy749GcWaBV6qxUMScuFTfWI
a58VDXt7LV4nUe+dT3I4dWuVKX5bl/yGfl4h4Db7+cFxXYeE657juKs6m29Q
6395vpm9vlSXwY+rSp5o+fAc3zC1H7vyPez9jPwJ8hOyy4fniwILtL414kHJ
ya+FDnfBUI2WWJZtHrxOWWSpmViHd0cCuro/dcNmV9XfsbNyQeFRy5oipUq0
dfJt95XqhampvayLktmwauKcDQ4NxXj7R7LyV+k++Kh+bbREWwaM0ruROEc+
Dx/v294kNdwHH15O/WF+NA1OytTyhskixsqH7M+9yYLjV08YJCxJhrpvEjx6
90IxRoW353syFWf/6Z+bJjH984AlEwKXOkbAX4uYv/l3X8ORb/xFem3U/Xkz
1iy9GgBKl6ds078YCfJzFF6sa2bBi+UKlp90nKFm+G+n2e9YuDhD4BHWsWBV
0G3BzsmKcingrbHFNB5GGQs1q9SwIPz2orw6HWdMOJW52Jx6/tWsWBP6+VES
G5XErwZgsnRjHL2+d2C1E72+6QncRO0HlaR/XSyg9nMjayZ7P3Nbx+6XO1QG
0rGZ9YJnm7HSZNOdq+Kd8Mxo/CzPmlKYUjstKdq7ARfuk3/o+eszpBzcfXoJ
TyksLRodHMBfg2MmvZZJ8e0G44nRGzuSi8F8o+74RzvKUFKsfr7RuF74NNZX
ZsLcIhA8p/xw3Z8C9Nj2dMPEuX2QV2F1rftYATTxT5q/Z3Y6alm8W6Le2Adz
q37arf6bAyrx41g9HuHoE9etslSNBU7/9M+fJDH9c13186bFS5NBWd+z4c/e
IFh9KEfKl8pzOiZ6JF+8GQVfhe6+KAqPAfEPV/ZiPgsurbgal2jkCwdahTc/
mJcI2l31gz/es2BZRry+8tETcl6Jbxw6u5Ng/1tIs6buSwcv3fHOyBfdyoof
0s+LyxSzn38ZJMdHrY8b6ucsLqbWzw+NZK8faHn0fdHSZJQwPvuERyEIlNLn
rqH34z/ROFX+cw0c+/42JF68BZ98ePlzX0kbtBvkzpYLrQF5t3l7pWMacTby
iiR/7IDo1OPY3VkNNle6oqNZtTht28mKCbGfwZJ3fHeSbRUkV4i6/ZhYgVlD
1cFVl7phWZG64iHPCnhyNN4u6s9H/H7uzFjTqh4weWd2yGFJGWgqrs9C6UwU
7vM9yv+tF2JfHumMli2GMTtfyIdmRmL77JIZWu/6YPc//XO7JKZ/Pq5qt5vn
hiyYOH9L2cyhUFB/cFbwugkL3r4bfVJcOwlaL3/csqQnHvo8V/du82fBGlON
4Z6bofB+0jfeG+sRFunUfl4SS+Uto2WUGgU05L5rZu+9658KF99Xami9Y4H1
dumqrpuhmDjpmzL9/Mhvky76+a4y1X1LtJMwXuZZA71+rutQH73+l8FTgtR+
cIa/TdIsaj/SazcJ0/vJH+/cxzrXCHzO8iKWGi0oMTRtod79FtD5fXHmhsuN
EKgfE5o3qwmrZbfuKDNug31P+17dX9YIPi37ZU7212HS5hGr6RYdMFMw51iS
YAMk1tp0XVxeiTfyzC7uvfkZ3o2P2zp7ej3E7I+N2ydQjHLt3p+913XDo3N7
rX1218CY1eFjElqysNdK3m51UA94OP/OOJJbASkWOU8WOEdj2gN5+eH8Xhj4
p39ul8T0z7cYiKgetiuAYPm8e9ay4dC7cfI74wUs2BTSNJIikwFjzuOexOlJ
oLrrlMcUfRacGPlpkKMcBRYG5+CjZxooV8i5qbuxwPKVfd2xdRflxu3dZCVT
mg4ZV05odFN289lry5utHIXaaYd16ecTUsVe0s+/b98iT62PT9KWj0qi1v/+
N8KHXv9Qdm6Ikl0BSlnz29lQ+zk9ti6N3k/65ojr2c3NYPvUszxlXQuq/rWU
itvTBMmqDwQFp7eA7+CdlRf4m3D20XYjlU0tgO0WO/0GmmH6BZdu/1X1+EZT
ItYK2sD5DSgJ3WmGnjQnQ2X/Sty6yf6ThGIHiKcYQtzTJvgQ5ii9400xzh7D
8zZ1J3X+F459JyjSCCZqUUcfj8/BO8O6n55P6oZvuc9fzDtTB6XPRdMmjIrF
3yIqw5use2DNP/1zuySmf+7cJ3ytQbYESltsJLPqImC/nY71I+c+0FE2fnEG
c6Fu/cQHN+ciNAf0iz5dyoJSlQs7t/+OB43rna6VrzJA66CTlI8RFU9Dqu4p
TdaV01aeNy/lZyZUnjfKlrBnQVatzEX4HY8ZZ2U/0s/HD+qso58vdsoJU8dc
LHr++5ARtb7nhfnL6PUnPLAeRe0Hkw+MqGdT+4HaD270fub39Lx6N9AKMc+K
1j1Oa0anz8+qOh59AiX1SSoHd7fB5a6BatnkRvTtWTbvukATjMy6/HTS4TZ4
fuXuJemqOtyQfEJw0ugWmP+gMO3vr1bQcVNa9eVlJcb4386unt4GUY8WSW1a
3QrX/L542TcWo0jUi9+ZyzugTplH73tZM3h7+j8K8M/BnSjl803qMzgEzTDp
/NQIca4WbeYjsTiRtSBt5sRuyP6nf26XxPTP8UFim5V6BZySO8E/dCQKJmjw
PVBv7oWfn0sfrHhTCGKWdcL8PGmgrR3x9V52H2wIPf+1XxJhH6/deH2HLNj9
0o31RZEFV+3f3HPJN5ALhXOBL0RzoHRFyOdNt1nwVbrTp08SUXh0/y76+RVe
Gwbo53exZl1Y/qYQK/VW2dLr765fyHOfWr93+dmUfrFIXJbuvESjtASOfNb4
Ota4D7YuW1Uk2x6CJ/sOdzeuLoJR4xy29Xf2gdzzx++PJvthaltT6s6MfKi0
tO7m30XVCxVry2W+vsRH51+smcmbBUcx4rKPNVXv54i4oq4DjszIPjRgmgKz
Gvwfb81kgY5XUaOCmClG8+/2C9WNgri3C1MHO1gQnHBt5r7j1/DywVdKn+V9
4LFao0s8lSeX/tM/vMXtH668mGCm4eSIaj8/+J6hrtVBM8t5qLxU0N/q1hRq
/ZWqZ+Is273xxcje6y7UOiefpTtaq1/AGNkth1wzAvDELdPxi6n8av04x4tq
bRogKpYrebUsGC99DAlM+E7lA9cENl8RM4SabeutQp4F47MJfZuaqPvpRaPT
/2rchLw3t63q1fyxMK/EeypVp+j7RLhY2aTikjXqK935c8GF/6xJM3Wet6T+
fmPrkIQXBO08by3PgtI59UvUVFkgIy1sVHUwHn3jjdZMbEyDEyCoqGJJfUc/
CqPdVKLR+YHFwDHXJHDZ3xbgF0nV426z+bWjw1FvrQWqisWAy8m9uSYlLFD6
06X24n0wPtw37U2DSghcuv1RTYDKM99V81960+CHqlYHJ0cKucGJdrse8wEq
n/+n/2bI7b/JfzN6WUbVJ+oelyNXPLBA3oIFvVspuymMrPGmObTE8PXzaH5q
KCmXzS9NfmCJo7Qe48EryWGnszzwbblmTR9V/0qNLdbxaTsBrqOE7tyg7A+u
v6J+Uuv03VK8I6xhDs1BVvpxkj5oLzRgoELd//Rn0aC5JlVPFu3y8VD2xCBl
6QWR1P3ps85V7KTqaxn5rOw71PvVMXvqX0GtH6Bh6jeckInvfjmOylsbBY+r
BwUfU3VB+VTZu19vpKPDsRkxRr8iYeprk8fWjiyw2FhzPlU+FZ98Ca3/8DAC
/GV/hW4Mpp4fKzxFVDkJFa0f9Ql9fwPf3znGOCELduzM39a+Ix7z2sSEVqgH
gM7ejXHWlJ33s3LhnGo0Drwfd0/Z1RNqeqcJLqHyyUvJfay3r8LRzzam32y3
LWT8DCzL7P0vv6rN7b+p+rdbWpT7446JAtuED1/DX63pE/Kpc+ief+WrldEr
fN+wRlapwwS/eYme3E9zwln9heN/WuFas8ubxlLXBSbZJrfo/tuV8f1ju/fA
x6f7Jtl32mOnpVh0CnX/lNUltZ+3rGGCuMTs6S8cMXFi9qIA6rsQaio7HT/k
Dl8Crm141WGPcy4kx4dT9tRYw3rWudkPmp9HBZ2m3vufOol6Aao++tFyxL9y
SxYO+e59ecLDD9WmS6emWbCgUyHYz+l0Bt6+59Vp2eCARdI1n456sSBy4nGj
o0ZpOJh5Ksj351UscS/8dDiKOp/eYxbZzEVUdB+9MfGlIRS5ROVJZLCgKUOw
ZGhXIirfYK3uzTYBu+tRATOLWWB2Y/mjKu04DHHhuTJW0ASmHFOV1qTqiJiP
gQvo/tuz9ePZfc4296D/q/8my/Tfhs8X5dP9N+fEenb/7WtMJbv/lu6fvuT2
UU+caHhUNq9THyqiPZfQ59nwT9yHTSds0cO89HiA1gVwOLf9xai/LNisYqcY
Y7czxVzZaz91lfvLmXekyVzS3nDCFqaFrzjhoXUBv8tcZT//SVZm7K2jnjA2
TP1zVqc+LrPrZa/Pv7R9H91/O1gcU7GReu/6atLs/pvN2/3N8yel40Gd0Ns6
+RmIH3+uDttH5dWOk3/rfU9F5Ntavk0zCZNvFMSXmrJAUiJ3UEsX8eioB/MW
a0bh6tgL6w9S5/mRyY7BgcgkvC40ZfK90kA0nDYQGpTOgqHm7lW8KQkoc3fE
NuHHS5y9ZEBNqpQ6b/JGR+wdY3HvsriTdX+e4bCpK2t7Awsmjtrm7rwhCp3e
1sublxuixK19dwooO7/9p/+mxO2/FdmZxlDnB8fxixyhzg/c3ijEPj8W8Yf/
UucNb/M+iKTOG0SqP2GfN+VSVYnft6wxKFl08owXjlRebM4+n03JiX0ruvdg
zk7JXQ6d9jB55kAUfZ6Xk3MPj8l3AMz5nzcYaWFp9Ap+e4g4HekwgcIl6uzv
ZUqtcYF5uT+E3M0XWkC9932rd02kv6/JXWt9fznHopHl95DG3iI0fXn30pTE
PgjQV71XTNnBxjBQ/VRBHtZAvc3+TSzo/r76TNvUWHQCt7MuVem4t7b7QRd1
/m9LZXz+MSMGg1qcH0UJvsOejBe/LiRQ+cwUizsLQ6LQ5+OzLyIx4Vg7cn1k
VwULklufOA9UR6D16/QPmOuD83sOxFq0s8Cl6Yzk0J4w/JE8OXrKHlu0qU/Z
kcxiAf7Tf9Pm9t9WVbrupvwhdsfGClH+ENwC09j+UGqOexflP/HC6twcyn/C
4olr2P6zYFvrwTka5hirea+c8rdQPRLF9re710TEhLWdQOG9irNutnuD+lsf
tn/WjZ13ikfrMeTJssTVszzArHIh258nEb/PxAFg/P/ok0fiS6k4rXnv0jVJ
6r3fGXnEjhdFqUYTnKeZo/TVhZN6tCpxVULb/PO5vXB6gvYie+3naKh0KB+u
lOD2ezbvbH37QOGkh6BCuTtWJNXb7M58jyM5y1TLqDprqq+erriNFwavPpAm
WZiBW8qsk3hdWfDCS15fSsAHfz78HZ4l/g63BdhajC5iQQTL87zXJR9Umrt2
OO3YW/S6lnNJsYeyT1lz6+JX3ujMmp28cbYbtjy5t+7+ENPXYvpuhtz+W5qO
8aKmY9dQ4/TqP4svu0NzU3YynVesFX4y6ZfGTVyaZWxAxX24FNjHjvuKu/4u
uSxmiOP4RKqpPAHujA1n5wl6LH+xs20aePSHex6VV0CswVJ2XqE/abuKufoF
8MrZt8AtIwBYIn3j6DwkOM/cZ6KYKXy36vSzot6L74tGAzpvuUjyG9hI8h1g
8pynIqI5J/7GQHY334LTI3X4+rSk8MoLPSBmfOPUPP8I0J0pdu+VXiXmrX9p
XhXRC9sPOq4LLw6GIxf1E6bNLsHJYz8qCfj3wZqD0VruPL7Q9vWBZtnpfBRa
oq3oRvmfYgdn+cYrLjA2MNb4bGIaio7fNiHoLZUXiecX7C+0hCdLM/W9u6Lx
QesWvs4Wyn+GTB13odkQFldI7Bbe7YMvTMbbh1L7L/mn/3aL23+zJu8DlpH3
A8x7mXh7QZnLR0twTI620JryBsKn7RMV/soCCffI75EZV4FffbV6j0EELH5j
PLqNer/fmwuDr328iOJwtHPKpwiQMZ7581c3C+quKN9tKLyDhml1xv784TBb
XsEujPq+fNQ6lmwpuY81a62uJLkGgghP/oYjVF5Usd52k1SzISqs6z6hS733
9Pde6d/p7+5I784zRbmg4nJg19ewRkxWCbQSd+4CwxpJx+0zs+HCjEnzl7+t
xQVP71QkHe4BzUWmYjPHZYB6/QF1rbpy/DTdcYJ6ZC+4ubsUTY1A8Dh5rWOG
XBFuwpoVXpF90Nb8dJTZzQSYvl+mr25DNuKK/vw7pyh/GG9o+yw6Ck5EmD2b
Z035mbsKUucSWZDjNO7I+oNvoGJFSrzJ9QBc2D2s/IPK92b/038z5vbf+m09
tYc7wuD93cCgrLuvQdgtwrCa8uccfwTviH8Cxi9NumZnPlnUBsLOfuY/6R4D
1We0jzQ1scBkpszWqjdUXDdXsEs4EAvB9ryF7xtZcD5g8YrMbAcsR0Uhk83R
0Gzo+5CvjQVyXtpHJ4l7YMTczAPZu8MgYsFvn8VUXvQ2kmVs2OGD5SczL7ZT
711n8v2rtlQcidpWhyPXS0FzRrXG8Y3NuHG4ZnOMQSe4fBaYXjerBMxe/rj+
rfMTVh6ZFbjNrAs+HRdbqX+iCDpHP/qoN1iF6a4LBRcd6gE3lQWs6y4FoHRw
e5h1Xwniz7Db6vG90GOxLihHKheOSDdPWX48H8sMlk6qTeiDpz5Lh+swA6TF
AxsyuxDVv8jwr1djQebH8JHjAgirGg55+d4LReWbBz3exrLA8Z/+mym3/7b3
a+XGUtlEULT2zzfYGwRnkxf0GOSwYGRN7KaFUeHg1Gc1Y++SGEA5kVMPqXxy
B4nH8IPEZ2DiMsvsq7Jdij46Gs1ZJx3/Dh5t+9YnSd3vXKy+TSzSCyPivjh5
qMXDkBnrry4VXy7I2Y4W+RGK6et1/4z/Hgl1UmN01OtYUH9bMPHkwyhc4N8h
VHH/Nag0u/4aoN7Xvss3ZmxYUAOhZvYJ/jNacP6OjvvPRNvh+VVzPuCrhh7N
BueTjxpx8E3Qo1jNTriuuevWNeVKMIjwXrhmay3e3G1jsdCkC6Q2N3hNEiqH
NeSKMxX6Z05Q6gHZ52est10pgXVzoi4tb/uAmUo2PWcp+8+eXdhSxfcR5rvK
XlhwIR1LJu43XhHdByZDK6TPzswD7csLU0I8wlH+7fylzoeouvWf/tsTbv+t
SWKD/M/5maB+N6/WeiAUXOd6RHx6RtVHgiFLZm1JgN+uTl8KzsfD+94ymRCq
bprbJKazJdwf7rsq+zZXJcPyCSMHx6Wy4KcbOx9FRZKfcvNSw/e5p8dCEM5e
1P287HYSdDxY5r6Iuq8sXO1Q6xeL+laNP2NlYqFbr/R4KbVO0ObjznYnEGcM
tkrmKAZB48wNovviqXixWDFCcFIjZDsm+Gw624I2M3kj9ue0QPz0Ft+nag1w
wvPMSq1xTdgQ5RzuLdQOr/4IXOoerIfe+vqbQh51OHW0w3yR852gJ3UZsaQW
6uq9+vrcKvDGdYcXOx51Mecemsh3wD3/dVvyNky1KYewhaVjH9zORL6aX/IK
lP/n7fJ8XVVSDAXfD5flZ0TiaCOn2h9+ff/hV/+n/7ZVT1G84Mx7UHtQ83ni
lnDwPHdbynUN9V5m8JhOuJEG5eeWzFhmmwgiTW8maz1mQV4Cz/tuys8uUvj+
NP17KtReSF9tFsCCw06t+w5fM8KK74dPtySlwaqXB4+XhlP5KqnHkFOfceuy
PzMfef/8gThOW16xRT8BJH92ZI12purQNJsNitrZyKM9dtKOP6FwyLloprgh
lQ9UT32u79IM/HFJnd1yLajwJenvWasmCHshUsJj0AxhYUpb8+Y0ocVpO62z
lP3HJBuLhH1rggvrJ2QFrqzHNUt3neCb1w6b3j4qyRvfBIev6/LsM6zE85Fn
bp2+3AljxRaIxRxsgI279TYGKhSjYvMmK6+nXYzfByMSB7j+/+lSjZhtmpXw
e+eC8+edotHDdfhKQmjvf/jV/+m/nSh8VfPwZTGVZ8wLUqiJgA0SYzb/ftsH
FwLvCdiWZMPwe93ex54p8Pbix6Iv21iweL5+/IwzMbAnJ3jDrYF0eL/Obmv4
ExYEvnwuw7v+Dg6qbn1zpyMDtLy6R696SdUvLiYWYV9jce2p8uXpe9JBKCJN
O9qS5nzY/QjcSvoT3L7E4pGxcy+XfcBZZe0mwtvDQX289yn9KSyYk1t0wSih
FXxeij9+V9qMgVOsPt//9QlwirL49PRWGDD/uCusphFFTwr4HXveBNOXDxSu
v9MK7lYrplVNrcd9HlE3citawHaxzyiNrBawF40SfhVdiYq6Tmt617RDUIiL
pPyzZviqcv+7bW4xqhimWhg+7oTi2UHHjLIaQcFgnuy1pTn48lfGRFvvLsgi
eQ88I3kQ+nHyn6z/T/9te6J+f0RiOaTl7l2meSgKMj5ZHTjP0weWG2LX+vgW
QOrp3ukdWalw+q7kcElHHxxA166wrYlgvO+SaTkrE0bJz6kzPUfF2YFFD3Z0
3kMn3RWr3Kdkg6L9zoB9ZixoeNujYN2XhFiauWLx9kzI5z9n732eBVaZYcox
7/MxZ/Q3b/3nCNu7M6vvTWSB+Kv1cr+9zFEkfXF93p1KmGYdPHd7Zi989Ok/
fn/OVbAwi9uvLuaOtZNrxadT+V75vYUae648Z66obO/um0zlJ7c7TmVWL2th
rqj5mE9n1dgmWEz6esgifT5Q5vT3nji4zMsvKseY83c7Zc5GgSdvRs75X73w
4brZTHnNCuzMX5s17U4UuMu2urY3UnmjQcHWZedvpTj3WgQc2FcF2n+mPJji
3gvvSH8WJ5J+Lchx+rRt5O9jIVmPu44E6ZvjYdJH5/bPp5C5BX4jcwzu/EKc
zI0whMyRuPOj/WRuh5w5Hnd+Z07mpriWzFG589O1ZG7N6AF5mPm1K+EGsJlw
BMjwA5MIt4GJhONAht+4RbgZ5HA0yPAzzwm3xHBMXH5pJeHGIIRwZFx+7B7h
9kCVcHxcfu8D6YNjGemLc/vh5aRvi3tIH5fbvzUj8wn8QOYV3DlFLJkPYR+Z
F3HnROvIfA49yLyOO6dLIvNRHE3mpdw56Wgyn8YRMq/mzqmXET6Aa0+GEzAm
fAYuJrwGMpzGKcLHYCLhZZDhZNIJn4RBhFdChlMqIHwYRBFejMuJiRA+D+YR
Xo/L6dUTbhJmEY6Sy0/6Es4Sigh3mcLwlulkDoHvyVyCO4+YTfrmOEz66Nz+
+UUyH8JAMi/izonekfkcOpF5HXdO507moyhH5qXcOSlnPo2xZF7NnVNz+AAc
T3gBLieQQvgMrp0ZTuMs4WNwEuFlkOFkxAmfhDaEV0KGU5IkfBgOEl4MGU5s
gPB5UEB4PS6nN57wkbCI8JJcTpLDs4Ij4Vu5XKsd4V+hlvCwKQwHq0PmQPhY
Lveu0mTdFGYexJlboP3GefQcI4WZX3Dmcyio6V17bN3FFGZO94PMR7Hzs86h
RgGNFGZO6kvm0/g+/Ime8tETKcycGgkfgFXey2d2TlZMYTiBCMJnoOAH/dMF
Q9IpDKfhRfgYrp0ZTobDJ+GpMR6sqZlr5RhOKYHwYdjo2J86sg/kGE7MjvB5
eObk4tySnB1yDKfnQvhIOCFq1kzfZzjJeMKnQk2+o/pPah2GU/1KOGMQ/CpF
c8dyDG/M4ZKpuLaa5pRlGT75HJnDYT6ZyyEzj1MkcyNcQeZIyMyPOPNRPEzm
pcjMST+Q+TSKk3k1MnPqQ4QPwPOEF0CGE6gjfAZaEV4DGU6jmPAxKEJ4GWQ4
GRHCJ3HtzHBKkYQPw72EF+NyYoqEz8NAwutxOT03wkeiOeEluZzkEsKnwmvC
qwLDqU4ifDAIEl4YGE54POG/wYvw4MBw4CqEF4dLhB+XY7jxT2QOihfJXBSb
OPPQJWRuhz/IHA+Z+d0EMp/G9WRejcycupPwARhIeAFkOIEfhM/AVsJrIMNp
HCV8DPoSXgYZTuYA4ZPQjvBKyHBKqwkfxrUzw4mtIXwePiW8HpfTm0b4SOQh
vCSXk/QjfCruJrwql1MNI3wwfCW8MDCcsD3hs0GR8NrAcNo6hMuHRsLpA8Pn
mxGOHyII1y/H8PzVZA6NTmQujcw8mqkDpf6jfz9H5qmYTOarOJEzV+Xl5H+M
jn6EkweGE54ANxG+ABmugFn/+3909IKE88DRhPtAhvdg6v9d/9HXqxL+Bi8R
HgcZDod53vE/uvuxT9hcFPoRTgoZPorp48z+jx5/AeHVsJvwa8hwa0x/rew/
Ov12whFyz8O/PCHT92T+9IMo4TsxgvCeXM6T2FMvKY6j62f60lqEu8WPhMPl
8rdkvbNJwf/R+8cTHhqPEz6ay0WT5/cmjf7P7wFIIpw6BBFuHRhenfO8rPR/
fj9AEtEPwGqiJwBGR8DZjyzPf35vwEuiMwFVojsBRm9CnteTrfjP7xN4SPQq
8JnoV+QY3QqHl5Vlfs8Ao4vJIxwGfCFcBv7h8BhvCTcA9oQj4PIDsYSPgVeE
l8F0DifzZwebT4IYwitxOaXDhA8DEcKLcTmxYsLngTLh9bicngvhIyGf8JJc
TnIX4VO5vCfDqa4kfDDwEV4YGE74OuGzQYDw2sBw2uaEj4cjhJcHhpOvJvoE
dCF6BdjO0SkoEH0IziF6Ea5OJJ/oiHAz0RVx9UTjiR4JI4g+SY7RJd0nHAw8
JVwMl4d5SbgNqCUcB5ff4CF8EhgTXonLKZ0jfBjDi+EcDif2ifB5DK/H5fSU
CR8JBYSX5HKSZoRPBSPCq3I51QDCB3PtzHDCHwmfDbyE1waG035I+HgIILw8
MJx8FNEnwC+iVwBGp/Cd6EMwmOhFuDqRT0Sfg01Er8PV6UgS3RcuIzowrv5r
FdGJ4TmiG5Nj9GL5hENiuCQuj3SFcDMQSTganMvhZ6IIH8bwYggcTsyc8HkM
r4cDHE5PgPCRDC/J5SR/X2PzqQyvyuVU3QgfDPcJL8zlhHMIn821M8Npbyd8
PMPLA8PJ1xF9AsgTvQIwOoVDRB8C84heBBidiCnR56A80etwdTphRB+Fw0Qv
xdVJiRI9HrKIPo+ry5tI9HvI0fPJlXB0fJ8JB8ZwYVwe7ALhlhiOicsvJRA+
j+H18CaH00skfCTDS2I2h5N8TPhUeEh4VVzF4VQlCR8MUwgvzOWEBQifDZmE
1+Zy2i6Ej+fameHkm4k+AaSIXgEYnYIl0YdACNGLAKMTKSD6HJhN9DrA6HRu
EH0U3iJ6Ka5O6g3Rp6EG0atxdWqZRCeJm4hukquXfEl0lcjRWcox+koBwuFB
KuHy8C2Hx3Mg3BgME46My495Ez4SFAgvickcTtKa8KkMr4rTOZyqOOGDIZnw
wjiWwwnvIXw2SBNeG+04nHY54eMZXh5Xczh5IPoErp1NOTqFGKIPAX+iFwFG
J+JE9Dmwj+h1gNHpuBJ9FKOXAkYnJUf0aShB9GpcndpUog/Ei0QvyNUJsoh+
FTl6Vq6O1YXoXZGjf5VjdK8+hIOEFMJFojCHh+RwewzHh34cfi+A8KkMr4o1
HE51F+GDoY3wwijM4YQnEz6b4bVxEYfT9iN8PAwSXh7vcTh5Z6JPYPQKXJ2C
AtGHcO3M6ESeEn0OrCF6HWB0OteIPgpuEr0UMDopVaJPY/RqwOjUOPpA5OgF
uTrBLqLPRI5ek6vTlCe6Yvw7j60z5uqLtxEdMpoQXbIco0e2IRwqpBEulcuj
cjhgyCNcMJcH5nDYDJfN5bE5HDzMI1w8l4d3JDoEGCa6BK4ewYboQOAJ0YVw
9SBviQ6Ha09Gj7OC6KCgnOiigNFDrSI6NCghujRg9GjRRAcIJkQXCIwe8B3R
YeIfosvk6jE5Oljk6GK5ethSouvG8UTnzdV3vyD9TeT0O+WYPmdE/61x0tvC
cfXxlkGt8g+g/ePdIs0pLJg/5WOuyq9QvB+UM0pJJxuksiV3zzVkQar40pbL
+4Nw0Tv1pE4VhJYFzS3y8VR9t3CD+fz7rzFIEHb9fRgFIb0qLT8aWeB4hk/T
65U3XtMVqWnp8AGncZuO0PPQ1Ry+8dx/+MYvfApKK6l82/j0rHulVB605ngK
m7vYbZiqP5/Kq/N/qw+Z03zZLXE295K8eM83SSp/Nu9e84jvXgDGKnpdofNn
i8pDZopUnlyy9NSy/s1+qBkxp5rmdjw9pn64SOXD9U3+omoibvhi5V4/mjN5
SPrRwOfL7k9z+9JFkdeKnuon4LeGcN6lgwgB76xX8DqzYERt0f2rMrF4e/lJ
/qzXsXBjhY1lMeW3NRbLjG/9Fonpk7+XDfwIhYb3EsNqdZQ9u7sM3u4Ow8eu
G1VsxD1g+NBVd3pe/P/jD3/1G/ood5jgxxfy12lubvKt+Wz+J7DL42R4pz7c
EOGdY3zUE1vviy2mn38aMVXAusMe7h1f+aRgyB3lv76IpXkknejMWabKnhDt
ZWvuremIxyMiFtH8jJzMl89Fav5wtVA3cv+5mzikVRZE8x6reuzsP95OwpNn
f8RT1QUMak1ZTc8HbyZeOvBKLR4bKgYHbkZ6QabhQCU9n11RMcbaZHM0tuou
X9uf7QD9db+N6Pl4z/EDDlpaF6C26U/zrhO22HPWx4nmx/gqZk8d9cIR3vV8
MhC5bY1rnTTEaD5qq9aX028kfUDKdU7OZg1zzNfeY0TzPLb9S774PguGcebT
TJ+JGWKxTu9Wmj9ZoFeluDX+HS5csNxwA+qDbKVGHT1Hrl8/1SrpQCweCxdX
3vb2KmgPKmTRc/wTNgsOPu20h1e+/KO7uveg8bJVMTR/ddJCW0+/3Rsm/HAI
Gmo7gcP8UrE0L3TibOjApbJguNEmvf9Cmwa2Dj4KpvmWMZUJqOYegz/E+GeN
E7XB0Lljd9P8gHOUZKZqlgfwda+N5NV6DD8iA9h80b0T6mKulJ/csqdws636
BWjv8WVzudpFr75ZUj/XwyncmV/MFAyaprE5XuJFrJP+79+DZ5n0f/8evCdJ
//fvwXuS9H//HjzTpDn/5+/BM06q/E99za77jA2Tov9TF5PndZMC/8/fd3cu
ie///H13e5P+W88yde5/61amnq3+T32qyeGF1v2HF+LU77K8PJ3/1KcZnjsm
CTlFQ5iFHu8OzUqUMT75l55XJrvajr2YEQn6CSKZ9SXFWFB6e9qAXx/cMB2/
7TBVb8J4ozC9mXlosEt6Jj2vFwpUXbGQqjevHHhseEcAUW/w/hOal1grXWAm
TdWbUo0rt14++AYF5I6doHkVh5rjRUNU/ThZd0la7x7q3xuy5SDNv2UedFp5
h6ofU+aNHvd8QxQknRr/mOYPXdKdNqlS9ePcobsjQVT9eFLYMoWuH113N029
T9WPEguvBL19FQ4rB7PLaf62qkt4rydVP343HisR0eAHdYu+9NL8s0Lwxbs0
5/ygO1p714lrsFe3xJfmzMVaJyVvvJ0JZV/nnZtnU44qqRbO9Nz8b+yOUbla
6VCTFLh88uiPWLJxkiPNLSz5ZPd8UxfC2UG5dTNSM/DtOF4Jmhvp+SXm8uHZ
O7j27G97XXQUnnl76DrN7cQ5peQ3/XkGmRen+T5zjAX+QLtfNG+pVcS60DPT
BI9aT35STtVrk/hHttO8a1qQr9FSV0+saq0v0FCNhouqogtp3nj3yQlyHioh
OPjY9cjb98HwUDzLhOa9XXh+L7yhG4XGTm3G5xabQoWXguxQBwtu/9KPKWv9
AE77f7VoXClB/eCNghrxvdDU0Tqu6Fg+FFrG7F64OheTxh+4SPMw2n4GywM2
ZMPyR6Ffpxsl4J1BuTN3T7Hg4nCkt1u2CSpa1SV8o+qdvozJSTSvq/Hq3uUK
tQA8Euj2omNHPKQdfN5P89KdLUen9i2KQblLiXLW0eHw5qHfq0fUff8Zjb6H
TVPwolzmkJSeA+xX482BTBboHpF8dqWvBFLaLQZyXQrQ8LmLL83tmI/ZZzOy
tQjm73GE1AjEbX1GgTQ3FfLU5vWdb2/QQ0xsyWLlJDAWzdv0AlnQ+z584lWX
JOx9+SumVYXKK27qrg2IpN7LvstHdXiyMO1jpdf37y+hnvdUR6A1C4pffDh1
vK4crGs7nquOy0ABj9v9apG9MKRQV2DYkIYh79fqrT0UD5daFExOW7JA5PLh
5u3p+bhYfLbNNvSDLV8i9ObuYsHA5MCVmquLsHO6izlvZwhIxkX+/tPZB+Fk
zoqcuSt33lrKmedyrniUM891Jr/vA76T3/+RwvzeD87cnZnDc+fv0UQPA/OI
Poari+HMlZGHzJm58+VdrDWChy6746rChokVzYbwdopXDs25hVWLdkx0QvRt
/SXqn58Pn7ofTXo6kQV+D4pC410D0XNRylbzkvuw5srzTTQvJ/NLvMmq3Rux
OCRtspgpProfxOYVl1WkGGzfnonTT0tLyPckAW+NQkHgecoPSB0OLtqTji6i
TpI3vsQCq/6vYRxlzwg3yxx//nC8/Og+fCm8A6uvPbSlOb32qqvfaZ3GlBkH
/lioX0BzuynsuFCuf2aLWpYHXl2YrfhX8zGWRhPdwdakrYXGU7LR6te1zfM/
3oPxY56vUDSj1ncv1dTsyMCGqAh8KHYHXrNmzJV6SfnDj6tMqpOofLvh9dZa
HSNQbIpLobmU26ODp/J/isD+K3y/7n68CHxHbw3RPOHO3w8dLpcF442TB8bp
tGmAtvufIDre7XJ+NdmAskNg/I0fY9pPwLYl5TF0fNQU4bOw7LRHO5+sUVN7
9sCbCB52PFWaFvbYl5WJWsu/TXsil4jeegf4aK5g14EHAYoD6RiedeV76JkY
lHy7djvNdez4YWsR/D0VNQd7NCQEwtFhv+5dmqtJVIoKKK5KRjzsPEU13B8d
3DbformmWrXuryyDCIyefmLF+4yr+LvP6VdrD5XnrJsMfs+CMWPNKH0rMUOQ
vRjGzhNO+TelUnkFnoqIcpfRMAdVxTHsvKLty6RRfC8c8ZBE8fZ5t61B4cVC
dh7C/+iHva7WBTT4q7h3zwlbePzkJjtvEedw2sb/4bRrbGPyo7NS8ZPcq6oS
3wLUf/igrrijDxJrfa+LeqbgwW436+iSbOS1fu5H8y0ZzvkWzTaJGBvWt1zk
RhpmSJqfp/mi3LJWIf/z8Tj6hu/aBVsSUHHBRQea72Kp3K3ftCQGvds3H1wY
FY7SgaPMaL6O93bD92tT3qBTbUn8m4+WuF4wdibNkXY4DxZReR2e3Dvwc8+5
m7BYvp+d153J3i1L5YE4b+KEO1QeCD8vBrPzQL7zc62pvBHNFwat+DDkDjFd
Guy80X7C89CoTn206X+62eSoJ+j6lIvReWbmOiuFwx0mYHnvb/0zo1ew8luD
Cp2X5hzzfTznUBS2Fa10T0gsR4mSsIBzPH3wZ/Rt4y/VEdgd893H7GUxRkpk
raH5nznKayJRJhynXfh69+OZ9zggufYVzV+tFp13YtFAKIZHlDsNzc9E95ZY
qYZnLHiWO+vs2r1BeEK4wipPNhGdT5ptu55DfUdDUXLBd1+j8Y0x6t0dYah2
ao0TzX/eiP99ayrlB+Z8enDF6fg1Kn5/TqPzhF98f+dR+T/mzWq0PS3iBgEH
jdn5/80LsZJUvYAxY/uVqHoBrCeOYdcLBx7rhq2m6o5MtbmjRt+j6t3XwK4v
FseOcROi6g63ksxYi3J/6JV4zda5qE/Z57iMqjvifm45S8VhiF56ml2/PP7/
8MxT5PM8/lDPPYlRNd/SYoj38wU9aK7Ya5L/z8ClOTBdXNDIMKsR1YXGxVp7
d4HB/4fLdVWun2veFQ37ZF349anzkDX3yRaaW96YvpWKg2+hbc3U4sRLPnDO
x/UAzY23+GU8yc4thvqgN/dlnjXj0iXv4gwed4Jd27eQWoViGPz29JP7wQaU
iTd75fm0C6bHxrIOJqZBZ+HboLarLjjfa6UhzUvHatjqfBR/ByVaVzqvCfiA
4uDvHTSvrvXMvU4kJhzeS3lErgmJgnEGViW0XqCs409TY3Ql2Fz7uetgVgta
mpfmda9ph6VCV519DCshqzjKMXR8E2Z+mOWqerkTTGTG2a9wr4C6ZCy0LanF
85ZShjQfmPLMdEPm6XwwE9WOVeL1RcEPevE0133VcaXV6sIMGNA/IOhg4wUC
kau0aa4+f9SRx0GC72DxVLGiuTNjwDRfMJbWNVgafr50ujQQVH4ID46LSoKo
mK1PaF2Jk9WLT7P566F60k/V+Xda0bC6rj2nogVylwlsmShRD4/tz123+NaE
y19c1KT5urGbUpv1POpA+lRflONgPU7qzCuj+caQ2QFWGltrIWDuNdn1ypW4
9L6W6CKTLuicHJc2eXYJeBRFL7hVEox25c/UaF79pVKj6c7M92CSaGx8s8Id
hG9v3knrBayf29SZV6WDRtHoOSv5Y6HuquJ5Wq9RcTruVcv5KPCRlFn6QhdB
p2vaDFovMzF5qUtc/1XQ+vxCQ90oDRrGJNjTeqXwsBP2OTWN0LB0quKftFZU
dNiZR/NsMuptr/rnNEGtC8jW6jejNm+upkZOC6jKW6najGuCKWf0a1eoNWBn
6CQnX6F2EPWe7W/0qBEOXbru2TGqGhPmCzrEa3bC3PTjIlM+f4K2OesqA2eV
4Bmfwq7tZl3w/+o483go+6+Py5Ju2SqtkpIlUkTiF3WskaWQJaFsZblVItGN
koSQJdGGTJmxZd+Z6WsNKdmissTYE4OoJPX7jtfM8zx3z33/e73mdb2u61xn
eZ/z/cxx0c3QjHfrhJRml+fOpFx0uNuOl67bN5hVNtvv2gqSe7elzjjfAUHx
UKOoJ5g/458dV3jZACfUYr333SmCDbmqJvqKNFAs5pZItSdDurfOZPxsBXD9
yHFoD8R9mZ1Nr0vXbbhXm+D21KoaOFtWJND/t2UrleSYt5iHiidGTQc9q4BL
+93qsBjc921N37kMBgDuj908cY+K0sNObrAL6wcvD/7rR20GYFDjiNMXrj6U
fetspgG2w7dgkk/ZmgGYVT6XPCP8Hul0y6+KFB6G2ScGobb7qDBXb/60xqMN
zaOcjGL3Udg0vKgyl90HAVPHMsWa6xEldTPXjrsfmfEPMQxdHzMP9FAaewdP
d4Ja3mqh4TVBcNJDxtWhfgJ4E0S76yeaIYRSusHuXhF8TUgI5iufBElxNs2f
DdUglsrRYbSyClKcyHdzsf9bmQ7v2vswGWzWE4iflWtBn/P5I/oeWppHWMtq
hXwkORou21taA6/Xcjy+4kuDqbW2lzP469GnQu5WiKiAdrfHfZ0S/193d5qh
u1PW5/3Y5ZODOpzJa+43NMGv76pFPxYn4Vex7tmFH5kopqN+qFu6HhQ0xNMP
nKSBwPvb6xo/pCOu79daf3FXwce3G9nLHmNe5RzcpJOWglw5dcWfc5RCl073
le+vaSAfPmxkZJuM2kdYv0pez4Jl9nok2kfcBxmLtlnzEtD4ZCHpZtxDcNTg
OfUXrmty//I/Wdlz10Q9y28iWWI7wcycgNrPDIin4Lwqx6srwRrvjWjVNXwa
I0SklPjn3hP4PuERlWqnhtTg9auRWR7fFHR1evFP+nm9aZO3f9NaP7hitN0s
aR0JnU/eHiuFf6/atdXw+bcwSCjaNulZREALlhUTJvj+e2pObP7ZX4oKLKxO
HQ6qgBbCLh2haOyfBwx7E7YWI7Ma24ni6BLQyZZvCS6hwSZzykCccQFymZyg
rJjPgWNvAvz422lwc1FXKtonF12PG4HXycnAEaieJDdMg5dS8pdED2SiNBOX
Cd2k22CnI811aJoG+ow5Uulvc6T48ZCe/Y9vIPPmvFa90XjUuHGDqDa+PrTs
x3TakDaMtFSrRZo8Qm9+5j+SxNe1t+wf9kkMAfaTj0+WkhJQeJTC8nlcHz9w
8SNK71346rgPWnrvIu4xdaFwfN1IWeaqaxEBOBeix6nfwlA0wXmabod920fi
YjgoSOrGaXuHwTQIE206R9cJ9Ai1rjqI+y53vRcO+k0EyFCs32OPeeb+TXbe
M9RCVBP/MGtfZCzcHhyPlu3DfGvQGJ6uk4dSNSWWm1peB8v+t55F2B88Zzb+
1JlSg4uS3O0a5pHopGmLIBfmtCCDX72HlSJgIrtU1kopAqUcPH5MEXPacmHO
uxmkBPAUcmyJTAxBE60XVtDfy4ZvIPTBOhJYTL7aMrjWD3nXvblH/767b5Tn
ymmVozNN7kUyj1xgtUir/HHcD6ptIx1b6VyMLB8ENJzLsgZuWVu3NNzPUlg/
HykPyUcyIyeETV9rA020eb8Q5pC7lsRqFcyRh4Yma7Kn1JDgBZXN9Oc8Twpf
FYa5ykBOsLVlSBup55ck0e3/iSdagxtzxtXD/Bs0h9RQu+qBs3Q/3GJyR8J7
VRGS393lY/Y2Gt1ffJSrhu0TJ/50RM0mD+3o/JEbYuOP3CwMZx9g+1SEPdPR
H40HlXPUDJXHN8CdOrad/t3ZpHLvqo8QgTNO0Jgz3hv85jOX/P+TyGmdXw8z
0UWHhlQWkWh0lZa5QxT71Vkb7jpTcwL45qYLXSq/CaYBBhIp/2dOlfWPe6hC
yYd/20O1jDGPYpzzIOb5DvM6cw/Vvr/toQok1//jHip/cvo/7qHyJuv+toeK
Ob/qZuybQn/Th5wjS/+2b2oZY37F3Dc19rd9UzrkxH/cN6Wj8uy3fVPLGPMr
5r6pMIaOlDm/UvyX+RVzD9V5ho73yg7f2v7GAkDF5LP8Qm/RGoGFdbzBExCj
3R1Tp58PPLcqVnxQbUPvZ6Y0VrlOwp6B9dZJt3KhYrvYC+2tr9Bxx2gr/bWY
z/kCdUuVsiG9v/nAcdsaJHjm/XEe3H/NdRBrg3gzIIlnYqiArRQVWUbM673C
fUSiIIQWkUB6tV73rSISaohx7e7GfWs5xdx6YVs0TJ4NYV14mAkLGRa76H6y
KO1fe83GH9xMM8RVbfLgu2rMN7ofKrB2Jrq/1kbU4ZeJZSH50Ln9igo9LhyX
/7kJxzP6KRV/Ecc3HAnmu0SP675Kbx+tpNvIpOZGrsSBTBDYw7qCnt9kDY9c
8Ip7iGTk2uWceQlQ4DtmRc//luunHUxLagCstJZznOhAvArU9oqQCUjftiri
B3s13Cr3aH3M34Jahkj2HJcnIfTBi4zEPyphmJJsReKtRy/TSPb122kQ8EbN
eHMOBbjafU7x5FDQjr3FywVw3j7y6ql+KVspxD1IasB2QjZDueN0+8hSed+d
eBsN+yIHPL1WFcGtfFoePR59+93Jw5nW6HysoRvOE6BNkF7KD+OaZ2KEImNR
+NpfRU7UQogO646g5zfxh3/dSU9ORk4z/W0JPrkQI6McT8/zTz5e5PwYkIXe
xCVM3rRNBvkxDUSvg/JF3U48Jk3Q8VBlVE+rDbkVEkPeREzAMWMTaV2XRmg3
13ba6dKIvktLvtp5dRIoinJfEW89yFiS9KP+qESZGvPJdfh93031pzrY1gCL
vet0hlI2ytUiDnFjf5idC6UOJrggVjGH7/Ja5cAh5S9Lz3vuQloUniYC8lAP
Jel4lYLPxm9y9LwtES10FX3LQbJx7fPIuADc3r3Kodcvs95WNiuOUkRsSL00
lJYC62zLzRdwfQf/LRrWWm1gUTVbOX+sCS1abPnahp/f3sOxu5S/BSSTSobG
2auRxLBGMyv+Xvbq/XUOW19B1KPAqNu3cpHDhrUNutifI1loDdSBNFRVZspO
4qAAUWlzLL2+KER1ifFFl6AZEeKpqa3F0Lvx0ngIrrMOwu2PQrmr0Im55oRf
fenwUunDTgrmELs//TZvPtEB400cC3olNahyl3EfGfuPgCatY1a1DQqrz20t
089HROXuGR4cX/6qqtTOGxXI1Upc045aCitX7yoSxn5y+E7zpKh0PVK3uMxZ
8jMTnt1z7tHE/HP8+BlHUaG38NJM6UNPYwF67T7Dw4Xj1yTi3XlqfRPanFVd
muGbA37NI8bLf07CXoaeP6DZMMKQxVuFqec/zbIjXcsCoVMvRH58q2kAv2qn
WMONNJBk6NV5391dJs9yUYWpV5f2anxK555jTrZqHpiDXlbMLfGP8kGzmZj2
arTqRfYtAf0y8L84J/OfC9gfKnnff+OrQopT5sQxciGoH1elbo+iAWOPHkps
NFi9hsVJhZnfDl4MOEXnJ9PRL05smKemhPYs1ZEVxolFBpgzkvwUVOnc0eOc
u1R3yImaxqBai87Xix1mi7SCg93Ju/UjaDAqNfPqjHU1Wv/561ev9S4gnvTE
J51AA6VgvyQjr0rEeayy+kvEBSCOH8vTx/0L4W96ZkMVZh62Tht6j+smsglX
GTHBHNft+8qVbgeZoB6NcMw3/Nujqicx71iYuS7VWYv3SjKAueGQ0bREO+aI
YJW1S3XZn1h91Lm/Gp2Ktvoce6EU7X9dfDPIA+c3safT1B1VSMzgq26/WAF6
orZRxwv3EdkT9pUyLhVouOkLV2NaFtrcmKAbkkkD3ZOQvsqAgkZ+cFSHrCQh
bxHSzkDcVwoxdMLv5PqKuFkMyUydcEO42AfMIehnVq0z5hCQuvpgiUO+dLs4
PcUcdoV7iC0ac9lQuNwStyR8DmnTw3yzQVtT7CTmHS4xoSXOqRUTtD2LOUOc
NQkOYe6o2Zq+xEVS/zK/0pe6L1ERiFBlFeeY4pkGdHtOpuKqEObP/p6ukU9k
lNKgZy92rgYRhdkn2m1p0LpiC4fswTJUfJabTTIdoeerexPux9LAb4HPt92v
GEFtRr/10WK0d1llmzqu14En4uQv5RQgtbFvvdyUbKR+VT3y9BvMyQwdr0ny
VoUDLE5kZv19ez7JD/MkCiLlSWKehO71nks8+U5dgOsZ5k73cuVQzJ9g8FF8
iT+/kos2+GGeG/i1XLYM852p7hcOun3C7FwHnmOuihdfezEKc1Y9wXGJb6lv
ui4oYR66XHBbFfspyBI+LPmnElva3K3VeUiEtzy8jtKKtIM07K5fn4QBI/fZ
yfwcVPJ1mwD1chMSmP8+6oa5hSfgh4fj5SzUdpT1+GRXHbIuecJBxPYZcRYM
jHXIQKbhPEPTqBKVWMcRlhFx3l4wEnaQT0WXOnTtOH1KUO2mQht1nFd7vmxx
DJpMRiukXWPk4jLRHel7lh7j+D4MXava4UPbNFgukpm61uabYfuG8u8gn32S
AnP5dyBUWDCehJ+f8gUiajF/P3CJ+YT7EeBqbVzqRwbvnmvE/QvKUjiTjvsX
aLUcvUP3KyebMX43zJcsCSrhvJg3zXdFLPU7BZJiB38+9IY1gnGdOL7hYdWk
PD2u69mUdNwx/ymimGBzzIOaxLClfMKca9X+NtfSYugtuY3Xi0ZiLmPymIhX
xDXPDXUgp2oxk+TWhzbF6ZXxdf77XCuVoSeU4tget4i5j8l7dfyabxXjMiE5
xXLvnclksJxONaDbzTLaZFS6uAUKjW6IkPv60aaelYXF7GMQl7Gq7KRiC2zi
/5pjFd2LZidGwm9Wf/wfHZ0LVZOymzWQzORM/uGnNuw+JWByxCjDTz4VnqoG
m9G/l4i6wksOSjbwanq+9sspgPkfwQF0f04yW+kZntEJeWViiYpNVFTzOENs
O+cIQPJ15yNGncCV9yA+Sq8Pjb2zn7L/PAo7v+x51uzdAe1RLD167F3I2k71
KuHZR7jP0Jtx9pJ4U9hCyEy9GY1yeH4YVQJxOWGg2CEDfMmdQ3S/+s+RiaBD
R4thq4u09KBfMdybHh+jx10MbxaP40oSfOr5kLLRgALDLyLE6PmHFrqb0CnV
A0LETMXXWgNoWZ5SjdT8IHA9v8abwd0Dnz6Qpdupfchk7uahjvlhWNBSfuhi
3Q0XE2kc56270X03pYwdtFGYtcsZUWXvgosPutVavDuQmiTvjmT8/Iw9syBh
9i30BWsUmcn5YfbCW9q66mDhSMjLmMtZ8Gh1rRgJx4uv7r6gwTQET9a3a+sf
LAORu7HGD3A+MTw5elo5LQv4ngTtVHapgPHH7F70vCqiaWMYFHMBsaaZIROv
SrC/URhOrwsC+8tmdFb0w6Mus6NTlgOo3VjgmelnKmR3G9pfE+yH/VxH43wF
+5GBrwnx5fQgzESwJLRQ+yB2pJvnMXcPuqc0ydKF37dOdh05SK8P7KoTebSN
OtGhpH5BV/y9RAwvZ+pE94K4p2qphWIL+mn5clUU9h/Gvl1YufyecBR+X2a/
0+FafbXwchN4xGf6ryzIgbZYLycPbAf9sZoG6tkaqLcXfLJ2ggxvR2jzHdgO
hEP2xgpiBVD1ly3H/I4qmBN/K++N60v8rV9/8O51QX26l0iu1tXAHYmk6PVR
2JLjXBelEEW4bHgzyFcFO/ldfm3D9fovxtzmr9/mNsb+AR2fLQcg+ltuqvqK
ftQbf+WFObZPVIS7eJPWALh9l+hrkOpBvyY8gmWxP3z27F+QaaJCEZ/mNf+M
TqRb2Oshjf052OmcRU5fP+T/CFgvWtyCFsau51Ti+Gp7JOh9160PtvJJLbps
qEPeyns2ruv833nXLca8i8TID4z9xdBU522RsCyKzOwfpcNcsnMorcD5azcx
fXUetNTyEYJwHiZeu7I4fLoByisTcmcDERx9LsF9Hdcp8uLhxSdupXCm15UQ
2F8NrkfMAkNwvd6p3rly56gVeiJyTFtLtRbMXu94r4d549LUEU6qQRl6dSJK
92x7NQy54QYY888YgXq2urYBeZG8DcuOI1D+slZPB/NVC+Mc8+1v55j/BQDU
/6A=
     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2}]], "Output",
 CellChangeTimes->{{3.8062590823037868`*^9, 3.8062590981303883`*^9}, 
   3.8062591758524275`*^9, 3.80625923597591*^9, 3.8062594837336607`*^9, 
   3.8062598372447433`*^9, 3.806260097497178*^9, 3.8062602689138536`*^9, 
   3.8062607220794234`*^9, 3.8062607798769646`*^9, 3.8062608368125277`*^9, 
   3.8062613176603985`*^9, 3.8062615864156184`*^9, 3.8062616166148567`*^9, 
   3.80626193846017*^9, 3.806262929080475*^9, 3.806263056092271*^9, 
   3.8062632264069753`*^9, 3.806293192531146*^9, {3.8062932875496683`*^9, 
   3.806293314471966*^9}, 3.806294637966442*^9, 3.806295198773814*^9, 
   3.8062953425930624`*^9, 3.8062954381165714`*^9, 3.806295660268776*^9, 
   3.8062958165037003`*^9, 3.8062960602323427`*^9, 3.806296308199875*^9, 
   3.8062965249092236`*^9, 3.806296575238909*^9, 3.806296738092661*^9, 
   3.806296833346176*^9, 3.806297026742131*^9, 3.80629782687426*^9, 
   3.806298381844784*^9, 3.806298706676035*^9, 3.806298772494319*^9, 
   3.8062990540669746`*^9, 3.8064204982945185`*^9, 3.8064209368437247`*^9, 
   3.806421038144055*^9, 3.806421353855109*^9, 3.8064215021916313`*^9, 
   3.8064218542299924`*^9, 3.8064219396031685`*^9, 3.806422347249019*^9, 
   3.8064226001876774`*^9, 3.8064227229673443`*^9, 3.806422931664608*^9, 
   3.8064230663851457`*^9, 3.8064232383076167`*^9, 3.806423535464188*^9, 
   3.8064244686592984`*^9, 3.8064245333883944`*^9, 3.806424636757181*^9, 
   3.8064249167708683`*^9, 3.8064250414645543`*^9, 3.8064268261470747`*^9, 
   3.806426918806096*^9, 3.806427208869408*^9, 3.8064281277844543`*^9, 
   3.8064630641685715`*^9, 3.806463474405262*^9, 3.8064636109600744`*^9, 
   3.806463665161723*^9, 3.8064644045669317`*^9, 3.8064645771711707`*^9, 
   3.8064708509402885`*^9, 3.806472353676381*^9, 3.8064726221063857`*^9, 
   3.806473773297595*^9, 3.806474947241291*^9, 3.8064752040589037`*^9, 
   3.806476761558728*^9, 3.806477121066829*^9, 3.806484255149258*^9, 
   3.8064845612268324`*^9, 3.806484985092987*^9, 3.8064854962690134`*^9, 
   3.806486160981949*^9, 3.8066717412328653`*^9, 3.80667180468855*^9, 
   3.8066826810541344`*^9, 3.8066829252444158`*^9, 3.8067169571438203`*^9, 
   3.8067172252458334`*^9, 3.8067179467246037`*^9, 3.8067194944947805`*^9, 
   3.8067196457291946`*^9, 3.8067611816049814`*^9, 3.806820147544272*^9, 
   3.8068204491660433`*^9, 3.807293763067728*^9, 3.8072939061262474`*^9, 
   3.807294871513759*^9, 3.8072951097259617`*^9, 3.807297157682315*^9, 
   3.8073210915331397`*^9, 3.80732323328399*^9, 3.8073245309906073`*^9, 
   3.8073248385602283`*^9, 3.807345830802204*^9, 3.8075803864434385`*^9, 
   3.807580468257147*^9, 3.8075806339629855`*^9, 3.807580678774136*^9, 
   3.8075809354930363`*^9, 3.8075812038093295`*^9, 3.807581320048287*^9, 
   3.8075813775999346`*^9, 3.80758146423903*^9, 3.807581549127282*^9, 
   3.8075815806572886`*^9, 3.80758197001503*^9, 3.8075820518548403`*^9, 
   3.80758212135834*^9, 3.807582210418275*^9, 3.8075823856336403`*^9, 
   3.807582544310808*^9, 3.807582655651515*^9, 3.807582801673309*^9, 
   3.807582952555792*^9, 3.8075830819757385`*^9, 3.8075831396827393`*^9, 
   3.807583351712691*^9, 3.8075834169995265`*^9, 3.8075834852780714`*^9, 
   3.8075835583190174`*^9, {3.80758370356993*^9, 3.807583719498537*^9}, 
   3.807583802906995*^9, 3.807583867011763*^9, 3.8075839748087587`*^9, {
   3.807584041692263*^9, 3.807584061761818*^9}, {3.807584142417838*^9, 
   3.8075841616043186`*^9}, {3.80758431361432*^9, 3.80758433347383*^9}, 
   3.8075844122307515`*^9, 3.807584710881852*^9, 3.8075847878181515`*^9, {
   3.8075848188327503`*^9, 3.807584848186865*^9}, 3.807584940044697*^9, 
   3.8075850293461995`*^9, 3.8075851397366233`*^9, 3.8075853610442142`*^9, 
   3.8075854414340563`*^9, 3.8075872665406756`*^9, 3.807587837725031*^9, 
   3.8075879415974426`*^9, 3.8075880149843636`*^9, 3.8075881212692966`*^9, 
   3.8075882507989025`*^9, 3.807688729312798*^9, 3.807688774587732*^9, 
   3.8076899504692745`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"N5 = \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[Eta]"}], ")"}], " ", "\[Eta]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[Xi]", "2"]}], ")"}]}]}],
  SequenceForm[
  "N5 = ", Rational[-1, 
     2] (-1 + $CellContext`\[Eta]) $CellContext`\[Eta] (-1 + $CellContext`\
\[Xi]^2)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.8062590823057947`*^9, 3.806259097973392*^9}, 
   3.806259175696431*^9, 3.806259235818915*^9, 3.8062594835796647`*^9, 
   3.806259837088747*^9, 3.806260097339182*^9, 3.8062602687588577`*^9, 
   3.806260721922427*^9, 3.806260779722968*^9, 3.806260836658532*^9, 
   3.8062613175034027`*^9, 3.8062615862506227`*^9, 3.806261616459861*^9, 
   3.8062619382921762`*^9, 3.8062629289174805`*^9, 3.806263055915275*^9, 
   3.8062632262409806`*^9, 3.8062931923931503`*^9, {3.806293287398672*^9, 
   3.80629331432297*^9}, 3.8062946378074465`*^9, 3.806295198613818*^9, 
   3.806295342435067*^9, 3.806295437953574*^9, 3.80629566011378*^9, 
   3.8062958163467045`*^9, 3.8062960600773478`*^9, 3.8062963080458784`*^9, 
   3.8062965247542257`*^9, 3.8062965750749135`*^9, 3.8062967379346647`*^9, 
   3.80629683319018*^9, 3.806297026586136*^9, 3.8062978267092657`*^9, 
   3.8062983816677885`*^9, 3.806298706519038*^9, 3.8062987723383217`*^9, 
   3.8062990539069767`*^9, 3.8064204980627546`*^9, 3.8064209366744537`*^9, 
   3.806421037896655*^9, 3.8064213537014556`*^9, 3.8064215020288677`*^9, 
   3.806421854082852*^9, 3.806421939465147*^9, 3.8064223470867105`*^9, 
   3.8064226000405397`*^9, 3.8064227228136964`*^9, 3.80642293151746*^9, 
   3.806423066237996*^9, 3.806423238144845*^9, 3.8064235353105392`*^9, 
   3.806424468405384*^9, 3.8064245332407374`*^9, 3.8064246366001854`*^9, 
   3.806424916616871*^9, 3.806425041332559*^9, 3.8064268259520807`*^9, 
   3.8064269186331015`*^9, 3.806427208709411*^9, 3.80642812760346*^9, 
   3.8064630639345775`*^9, 3.8064634742472663`*^9, 3.8064636107950788`*^9, 
   3.806463664980728*^9, 3.8064644043976526`*^9, 3.80646457698627*^9, 
   3.806470850690292*^9, 3.806472353520133*^9, 3.806472621950137*^9, 
   3.806473773141345*^9, 3.806474947085039*^9, 3.8064752039026546`*^9, 
   3.8064767614024787`*^9, 3.806477120910578*^9, 3.8064842549002633`*^9, 
   3.8064845610688353`*^9, 3.8064849849319906`*^9, 3.8064854960870185`*^9, 
   3.8064861608239517`*^9, 3.806671740998494*^9, 3.806671804532303*^9, 
   3.8066826808041406`*^9, 3.8066829250504217`*^9, 3.806716956923764*^9, 
   3.8067172250921783`*^9, 3.8067179465618305`*^9, 3.8067194943217845`*^9, 
   3.806719645560199*^9, 3.806761181351988*^9, 3.8068201473682756`*^9, 
   3.806820448998047*^9, 3.8072937628997307`*^9, 3.8072939059642496`*^9, 
   3.807294871351761*^9, 3.8072951095419683`*^9, 3.8072971575153203`*^9, 
   3.807321091379052*^9, 3.8073232331147118`*^9, 3.807324530812215*^9, 
   3.8073248383974667`*^9, 3.807345830590127*^9, 3.807580386193572*^9, 
   3.807580468103498*^9, 3.8075806338093395`*^9, 3.807580678627002*^9, 
   3.807580935339381*^9, 3.807581203655674*^9, 3.8075813198791003`*^9, 
   3.807581377446286*^9, 3.8075814640853834`*^9, 3.807581548973415*^9, 
   3.8075815804945197`*^9, 3.8075819698678913`*^9, 3.8075820517011924`*^9, 
   3.807582121220319*^9, 3.8075822102646217`*^9, 3.807582385486492*^9, 
   3.8075825442417965`*^9, 3.807582655582506*^9, 3.8075828016042333`*^9, 
   3.8075829525023985`*^9, 3.8075830819067245`*^9, 3.8075831396137285`*^9, 
   3.8075833516426926`*^9, 3.807583416927528*^9, 3.8075834852050734`*^9, 
   3.8075835582480187`*^9, {3.8075837035019307`*^9, 3.807583719427539*^9}, 
   3.807583802836999*^9, 3.807583866939765*^9, 3.8075839747357597`*^9, {
   3.8075840416212654`*^9, 3.8075840616927977`*^9}, {3.8075841423332024`*^9, 
   3.807584161521321*^9}, {3.807584313544323*^9, 3.807584333401832*^9}, 
   3.807584412152753*^9, 3.8075847108037214`*^9, 3.807584787749139*^9, {
   3.8075848187481155`*^9, 3.8075848481178546`*^9}, 3.807584939975685*^9, 
   3.8075850292615614`*^9, 3.807585139667612*^9, 3.8075853609595833`*^9, 
   3.807585441355931*^9, 3.8075872664560413`*^9, 3.807587837656022*^9, 
   3.8075879415284233`*^9, 3.8075880149153547`*^9, 3.807588121201116*^9, 
   3.807588250729895*^9, 3.8076887292188005`*^9, 3.807688774501734*^9, 
   3.807689950477275*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx12LFqFFEUxvFBS0ufICDiW0xtYeMjCEnlYqO1g29ha2klCGkvXHyC0y42
t0gjRrCzikHmXJn/d75ACPvLyeTOf2+ys3Px6s3LywfLsvy5/3x4/3nx/cXX
u7tfLb8u+8fV2y8fr08/xD8/erydzjfit5/eXT15PsQv/x3nbObDeBfPD/i2
z6+1h/i+HjM/xPfzFd/7iO+Pnbfsys707EzPzvTsXM+H8S7OdbFz7SGenev5
IZ6d6dmZnp2Nt+zH86HnY3p2pmfnej6Md3H+fnauPcSzcz0/xLMzPTvTs7Px
lp3YmZ4/T8/H9Oxcz4fxLs7fw861h3h2rueHeHamZ2d6djbesgc707MzPY9L
z8f1fBjv4jweO9ce4tm5nh/i2ZmenenZ2XjL82Zn+nE/h9nPYfYz58N4F+fP
sXPtIX7cz5wf4sf9HGY/h9nP4i3Pr+7cTeduOnfTmfNhvIvz+3VneogfO3N+
iB87d9O5m87iPJ/NvN5v5vUp1ylu/v43PN9w6bst5iM71x7i2bmeH+LZmZ6d
6dnZeMN6N+zn6djP07Gfp2M/Yz6Md/Fjj/9dsZ/hIY79jPkhjv08Hft5OvYz
veH5R+cwncN0DtOZ82G8i7Nf3Zke4vj/bDqH6Rymc5jO4g1/TxuuN6QzHdcb
0rmeD+NdnJ3YufYQx/WGdKbjekM603G9YfbzMPt5mP08zH4eZj9zPox3cfZg
59pDHNfPZj8Ps5+H2c/D7Gfxhv/3G94PSmd6dqbj/aB0rr2L87zZufYQx/tB
6UzH+0HpTMf7QemM18/ZmY77G9KZjvsb0rn2Ls7zY+faQxz3N6QzHfc3pDMd
9zekM65HZmc67tdJZzru10nn2rs4z4Odaw9x3K+TznTcr5POdNyvm/7t2fun
5+ufLb+yP31/vMLn9Tkdx18xL47jc512/XwfgHlZD59HrH8e//eHm9en823L
r/AVvmF+ha/w2dkdn+vPObd+Hh/zfH5l/ViPrJ/9/wIy5IXs
    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Thickness[0.005], 
      Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151,
        166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
       180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 
       235, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246},
       VertexColors->None]}},
    VertexColors->CompressedData["
1:eJxTTMoPSmVkYGD4CcSzZoLAS/tRepQepUfpUXqUHqWHHg0ATRigpw==
     "],
    VertexNormals->CompressedData["
1:eJztzrEJgGAMROGHTuIk7uAIgrUr3Mi2dtr6Q1A7HxhI8wXuMszrtHTAfm5P
Ndv4cY/ckXjkjsQjdyQeuSPxyB2JR+5IPFLP9fx5j9yReOSOxCN3JB65I/HI
HYlH7kg8ckfikXozj73KqXrbnDuvcqrep3++7f3zi/wD2n+tbg==
     "]], GraphicsComplex3DBox[CompressedData["
1:eJx1nXlczdkbx+3ZfpM1O9nC2LLvjiH7vped7JR9hAYTY5mxRmVfIqFQIkn6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    "], {{
      {GrayLevel[0], Opacity[0.3], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXf8V9Mfx++5535FQ8lIg6bRnrJCpMieZUdGGQ3bz6rsSkNRoZDRsEqL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           "]], Polygon3DBox[CompressedData["
1:eJw1mnPgo0fbhfPMZGvb7db2W7x9a9u2bXeLrW3btm17a9u29V1Xz3x/zOa5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           "]], Polygon3DBox[CompressedData["
1:eJwt13nclWMaAODvO+dQaUWFSpYSLUpRKBVtVCpatadNtJl2kmZKC1Fo12Jo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           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Thickness[0.005], Line3DBox[CompressedData["
1:eJwt0jkvRFEYBuBjxr5HREQs8QNoiVCLUClE6CQiFDQi1CLUCloNv4DWEv4A
xox1hk5h3xrrczOK9z7fyb33nO+ce5tHpvonc0IIi/IrUf0pt7IfC6GSh2zi
NVv5yC7+sI9l8RCG2cBGmVB3cI49XOIgVznGDc5wiws8YF5uCA/R+ho45re8
y5Fxgsc8YYJJnjDFJE+Z4hlPI+Vcfc4LXvCSl7ziFdNMM8MMr7ltP0+MGd9E
+5MPWdPjEZe5z3lucprrHOUKB+LZc+zmLNvZJuPqOg6xhL38slYn79kS9cJG
xp3DXch+iIroOXmTeuPyaB6WsZalrGEJq1nMKhZxz3yvLJRd9QvL3StgKfNZ
zLzoGVo25FN7IZdeCTsuz///xR+EmEfP
        "],
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{707, 1024, 480, 706, 1129, 929, 708, 1130, 930, 709, 1131, 
        931, 710, 1132, 932, 711, 1133, 933, 712, 695, 1031, 1329, 713, 1025, 
        1134, 934, 714, 1135, 935, 715, 1136, 936, 716, 1137, 937, 717, 1138, 
        938, 718, 1139, 939, 719, 1330, 1026, 940, 1027},
        VertexColors->None], 
       Line3DBox[{721, 1032, 1225, 720, 494, 722, 1140, 941, 723, 1141, 942, 
        724, 1142, 943, 725, 1143, 944, 726, 1144, 1033, 1226, 727, 1034, 
        1227, 728, 1145, 945, 729, 1146, 946, 730, 1147, 947, 731, 1148, 948, 
        732, 1149, 949, 733, 1150, 950, 734},
        VertexColors->None], 
       Line3DBox[{736, 1035, 1228, 735, 1036, 1229, 737, 510, 738, 1151, 951, 
        739, 1152, 952, 740, 1153, 953, 741, 1154, 1037, 1230, 742, 1038, 
        1231, 743, 1039, 1232, 744, 518, 745, 1155, 954, 746, 1156, 955, 747, 
        1157, 956, 748, 1324, 1015, 957, 749},
        VertexColors->None], 
       Line3DBox[{751, 1016, 1017, 1325, 750, 1040, 1233, 752, 1041, 1234, 
        753, 525, 754, 1158, 958, 755, 1159, 959, 756, 1160, 1042, 1235, 757, 
        1043, 1236, 758, 1044, 1237, 759, 1045, 1238, 760, 533, 761, 1161, 
        960, 762, 1162, 961, 763, 1326, 1018, 1019, 764},
        VertexColors->None], 
       Line3DBox[{766, 1020, 1021, 1327, 765, 1046, 1239, 767, 1047, 1240, 
        768, 1048, 1241, 769, 540, 770, 1163, 962, 771, 1164, 1049, 1242, 772,
         1050, 1243, 773, 1051, 1244, 774, 1052, 1245, 775, 1053, 1246, 776, 
        1054, 1247, 777, 1165, 963, 778, 1328, 1022, 1023, 779},
        VertexColors->None], 
       Line3DBox[{781, 1055, 1248, 780, 1056, 1249, 782, 1057, 1250, 783, 
        1058, 1251, 784, 1059, 1252, 785, 555, 786, 1166, 1060, 1253, 787, 
        1061, 1254, 788, 1062, 1255, 789, 1063, 1256, 790, 1064, 1257, 791, 
        1065, 1258, 792, 563, 793, 1167, 964, 794},
        VertexColors->None], 
       Line3DBox[{798, 1168, 965, 796, 1169, 966, 800, 1170, 967, 802, 1171, 
        968, 804, 1172, 969, 806, 1173, 970, 808, 1174, 572, 810, 1175, 971, 
        812, 1176, 972, 814, 1177, 973, 816, 1178, 974, 818, 1179, 975, 820, 
        1180, 976, 822, 1182, 978, 824},
        VertexColors->None], 
       Line3DBox[{823, 977, 1181, 821, 1271, 1077, 819, 1270, 1076, 817, 1269,
         1075, 815, 1268, 1074, 813, 1267, 1073, 811, 1266, 1072, 809, 1265, 
        571, 807, 1264, 1071, 805, 1263, 1070, 803, 1262, 1069, 801, 1261, 
        1068, 799, 1260, 1067, 795, 1259, 1066, 797},
        VertexColors->None], 
       Line3DBox[{826, 1078, 1272, 825, 1183, 979, 827, 1184, 980, 828, 1185, 
        981, 829, 1186, 982, 830, 1187, 983, 831, 1188, 1079, 1273, 832, 588, 
        833, 1189, 984, 834, 1190, 985, 835, 1191, 986, 836, 1192, 987, 837, 
        1193, 988, 838, 1194, 989, 839},
        VertexColors->None], 
       Line3DBox[{841, 1080, 1274, 840, 1081, 1275, 842, 1195, 990, 843, 1196,
         991, 844, 1197, 992, 845, 1198, 993, 846, 1199, 1082, 1276, 847, 
        1083, 1277, 848, 604, 849, 1200, 994, 850, 1201, 995, 851, 1202, 996, 
        852, 1203, 997, 853, 1204, 998, 854},
        VertexColors->None], 
       Line3DBox[{856, 1084, 1278, 855, 1085, 1279, 857, 612, 858, 1205, 999, 
        859, 1206, 1000, 860, 1207, 1001, 861, 1208, 1086, 1280, 862, 1087, 
        1281, 863, 1088, 1282, 864, 620, 865, 1209, 1002, 866, 1210, 1003, 
        867, 1211, 1004, 868, 1212, 1005, 869},
        VertexColors->None], 
       Line3DBox[{871, 1089, 1283, 870, 1090, 1284, 872, 1091, 1285, 873, 628,
         874, 1213, 1006, 875, 1214, 1007, 876, 1215, 1092, 1286, 877, 1093, 
        1287, 878, 1094, 1288, 879, 1095, 1289, 880, 636, 881, 1216, 1008, 
        882, 1217, 1009, 883, 1218, 1010, 884},
        VertexColors->None], 
       Line3DBox[{886, 1096, 1290, 885, 1097, 1291, 887, 1098, 1292, 888, 
        1099, 1293, 889, 644, 890, 1219, 1011, 891, 1220, 1100, 1294, 892, 
        1101, 1295, 893, 1102, 1296, 894, 1103, 1297, 895, 1104, 1298, 896, 
        652, 897, 1221, 1012, 898, 1222, 1013, 899},
        VertexColors->None], 
       Line3DBox[{901, 1105, 1299, 900, 1106, 1300, 902, 1107, 1301, 903, 
        1108, 1302, 904, 1109, 1303, 905, 660, 906, 1223, 1110, 1304, 907, 
        1111, 1305, 908, 1112, 1306, 909, 1113, 1307, 910, 1114, 1308, 911, 
        1115, 1309, 912, 668, 913, 1224, 1014, 914},
        VertexColors->None], 
       Line3DBox[{928, 1030, 700, 927, 1323, 1127, 926, 1322, 1126, 925, 1321,
         1125, 924, 1320, 1124, 923, 1319, 1123, 922, 1318, 1122, 921, 1317, 
        1316, 1121, 920, 1315, 1120, 919, 1314, 1119, 918, 1313, 1118, 917, 
        1312, 1117, 916, 1311, 1116, 915, 1128, 1310, 1028, 1029},
        VertexColors->None]}, 
      {GrayLevel[0.5], Thickness[0.005], 
       Line3DBox[{260, 481, 1129, 261, 494, 287, 1229, 509, 302, 1233, 523, 
        317, 1239, 537, 332, 1249, 551, 347, 1260, 566, 1169, 362, 581, 1183, 
        377, 1275, 596, 392, 1279, 611, 407, 1284, 626, 422, 1291, 641, 437, 
        1300, 656, 452, 1311, 671, 467},
        VertexColors->None], 
       Line3DBox[{262, 482, 1130, 263, 495, 1140, 288, 510, 303, 1234, 524, 
        318, 1240, 538, 333, 1250, 552, 348, 1261, 567, 1170, 363, 582, 1184, 
        378, 597, 1195, 393, 612, 408, 1285, 627, 423, 1292, 642, 438, 1301, 
        657, 453, 1312, 672, 468},
        VertexColors->None], 
       Line3DBox[{264, 483, 1131, 265, 496, 1141, 289, 511, 1151, 304, 525, 
        319, 1241, 539, 334, 1251, 553, 349, 1262, 568, 1171, 364, 583, 1185, 
        379, 598, 1196, 394, 613, 1205, 409, 628, 424, 1293, 643, 439, 1302, 
        658, 454, 1313, 673, 469},
        VertexColors->None], 
       Line3DBox[{266, 484, 1132, 267, 497, 1142, 290, 512, 1152, 305, 526, 
        1158, 320, 540, 335, 1252, 554, 350, 1263, 569, 1172, 365, 584, 1186, 
        380, 599, 1197, 395, 614, 1206, 410, 629, 1213, 425, 644, 440, 1303, 
        659, 455, 1314, 674, 470},
        VertexColors->None], 
       Line3DBox[{268, 485, 1133, 269, 498, 1143, 291, 513, 1153, 306, 527, 
        1159, 321, 541, 1163, 336, 555, 351, 1264, 570, 1173, 366, 585, 1187, 
        381, 600, 1198, 396, 615, 1207, 411, 630, 1214, 426, 645, 1219, 441, 
        660, 456, 1315, 675, 471},
        VertexColors->None], 
       Line3DBox[{270, 693, 695, 271, 499, 1144, 292, 514, 1154, 307, 528, 
        1160, 322, 542, 1164, 337, 556, 1166, 352, 571, 1174, 367, 586, 1188, 
        382, 601, 1199, 397, 616, 1208, 412, 631, 1215, 427, 646, 1220, 442, 
        661, 1223, 457, 1316, 676, 472},
        VertexColors->None], 
       Line3DBox[{274, 488, 1135, 275, 502, 1145, 295, 1232, 517, 310, 1237, 
        531, 325, 1244, 545, 340, 1255, 559, 355, 1267, 574, 1176, 370, 589, 
        1189, 385, 604, 400, 1282, 619, 415, 1288, 634, 430, 1296, 649, 445, 
        1306, 664, 460, 1319, 679, 475},
        VertexColors->None], 
       Line3DBox[{276, 489, 1136, 277, 503, 1146, 296, 518, 311, 1238, 532, 
        326, 1245, 546, 341, 1256, 560, 356, 1268, 575, 1177, 371, 590, 1190, 
        386, 605, 1200, 401, 620, 416, 1289, 635, 431, 1297, 650, 446, 1307, 
        665, 461, 1320, 680, 476},
        VertexColors->None], 
       Line3DBox[{278, 490, 1137, 279, 504, 1147, 297, 519, 1155, 312, 533, 
        327, 1246, 547, 342, 1257, 561, 357, 1269, 576, 1178, 372, 591, 1191, 
        387, 606, 1201, 402, 621, 1209, 417, 636, 432, 1298, 651, 447, 1308, 
        666, 462, 1321, 681, 477},
        VertexColors->None], 
       Line3DBox[{280, 491, 1138, 281, 505, 1148, 298, 520, 1156, 313, 534, 
        1161, 328, 1247, 548, 343, 1258, 562, 358, 1270, 577, 1179, 373, 592, 
        1192, 388, 607, 1202, 403, 622, 1210, 418, 637, 1216, 433, 652, 448, 
        1309, 667, 463, 1322, 682, 478},
        VertexColors->None], 
       Line3DBox[{282, 492, 1139, 283, 506, 1149, 299, 521, 1157, 314, 535, 
        1162, 329, 549, 1165, 344, 563, 359, 1271, 578, 1180, 374, 593, 1193, 
        389, 608, 1203, 404, 623, 1211, 419, 638, 1217, 434, 653, 1221, 449, 
        668, 464, 1323, 683, 479},
        VertexColors->None], 
       Line3DBox[{284, 697, 1330, 698, 285, 507, 1150, 300, 684, 1324, 685, 
        315, 687, 1326, 688, 330, 690, 1328, 691, 345, 564, 1167, 360, 579, 
        1181, 1182, 375, 594, 1194, 390, 609, 1204, 405, 624, 1212, 420, 639, 
        1218, 435, 654, 1222, 450, 669, 1224, 465, 700, 701, 702},
        VertexColors->None], 
       Line3DBox[{466, 670, 699, 1310, 451, 655, 1299, 436, 640, 1290, 421, 
        625, 1283, 406, 610, 1278, 391, 595, 1274, 376, 580, 1272, 361, 1168, 
        565, 1259, 346, 550, 1248, 331, 536, 1327, 689, 316, 522, 1325, 686, 
        301, 508, 1228, 286, 493, 1225, 259, 480, 692, 703},
        VertexColors->None], 
       Line3DBox[{473, 677, 1317, 458, 662, 1304, 443, 647, 1294, 428, 632, 
        1286, 413, 617, 1280, 398, 602, 1276, 383, 587, 1273, 368, 572, 1265, 
        353, 557, 1253, 338, 543, 1242, 323, 529, 1235, 308, 515, 1230, 293, 
        500, 1226, 272, 486, 1329, 694, 704},
        VertexColors->None], 
       Line3DBox[{474, 678, 1318, 459, 663, 1305, 444, 648, 1295, 429, 633, 
        1287, 414, 618, 1281, 399, 603, 1277, 384, 588, 369, 1175, 573, 1266, 
        354, 558, 1254, 339, 544, 1243, 324, 530, 1236, 309, 516, 1231, 294, 
        501, 1227, 273, 1134, 487, 696, 705},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzFWnk0l923lylESvIioogow5shUbaKUIbeIqWBDGkwlFQSJQ0iIilz5iFD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     "],
    VertexNormals->CompressedData["
1:eJx0fHk4VVH3vyZSNFEpU6hEiJQU3YUiMiRDCSVUUolEA6VBRaZCQsgQMs8y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     "]]},
  Axes->{False, False, False},
  AxesLabel->{None, None, None},
  AxesOrigin->{0, 0, 0},
  AxesStyle->Directive[
    GrayLevel[0]],
  Background->GrayLevel[1],
  BaseStyle->{FontFamily -> "Calibri", FontSize -> 30, FontWeight -> Bold},
  BoxRatios->{1, 1, 0.4},
  BoxStyle->Directive[{
     GrayLevel[0], 
     Thickness[0.003]}],
  Boxed->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{600, Automatic},
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.3, -2.4, 2}]], "Output",
 CellChangeTimes->{{3.8062590823037868`*^9, 3.8062590981303883`*^9}, 
   3.8062591758524275`*^9, 3.80625923597591*^9, 3.8062594837336607`*^9, 
   3.8062598372447433`*^9, 3.806260097497178*^9, 3.8062602689138536`*^9, 
   3.8062607220794234`*^9, 3.8062607798769646`*^9, 3.8062608368125277`*^9, 
   3.8062613176603985`*^9, 3.8062615864156184`*^9, 3.8062616166148567`*^9, 
   3.80626193846017*^9, 3.806262929080475*^9, 3.806263056092271*^9, 
   3.8062632264069753`*^9, 3.806293192531146*^9, {3.8062932875496683`*^9, 
   3.806293314471966*^9}, 3.806294637966442*^9, 3.806295198773814*^9, 
   3.8062953425930624`*^9, 3.8062954381165714`*^9, 3.806295660268776*^9, 
   3.8062958165037003`*^9, 3.8062960602323427`*^9, 3.806296308199875*^9, 
   3.8062965249092236`*^9, 3.806296575238909*^9, 3.806296738092661*^9, 
   3.806296833346176*^9, 3.806297026742131*^9, 3.80629782687426*^9, 
   3.806298381844784*^9, 3.806298706676035*^9, 3.806298772494319*^9, 
   3.8062990540669746`*^9, 3.8064204982945185`*^9, 3.8064209368437247`*^9, 
   3.806421038144055*^9, 3.806421353855109*^9, 3.8064215021916313`*^9, 
   3.8064218542299924`*^9, 3.8064219396031685`*^9, 3.806422347249019*^9, 
   3.8064226001876774`*^9, 3.8064227229673443`*^9, 3.806422931664608*^9, 
   3.8064230663851457`*^9, 3.8064232383076167`*^9, 3.806423535464188*^9, 
   3.8064244686592984`*^9, 3.8064245333883944`*^9, 3.806424636757181*^9, 
   3.8064249167708683`*^9, 3.8064250414645543`*^9, 3.8064268261470747`*^9, 
   3.806426918806096*^9, 3.806427208869408*^9, 3.8064281277844543`*^9, 
   3.8064630641685715`*^9, 3.806463474405262*^9, 3.8064636109600744`*^9, 
   3.806463665161723*^9, 3.8064644045669317`*^9, 3.8064645771711707`*^9, 
   3.8064708509402885`*^9, 3.806472353676381*^9, 3.8064726221063857`*^9, 
   3.806473773297595*^9, 3.806474947241291*^9, 3.8064752040589037`*^9, 
   3.806476761558728*^9, 3.806477121066829*^9, 3.806484255149258*^9, 
   3.8064845612268324`*^9, 3.806484985092987*^9, 3.8064854962690134`*^9, 
   3.806486160981949*^9, 3.8066717412328653`*^9, 3.80667180468855*^9, 
   3.8066826810541344`*^9, 3.8066829252444158`*^9, 3.8067169571438203`*^9, 
   3.8067172252458334`*^9, 3.8067179467246037`*^9, 3.8067194944947805`*^9, 
   3.8067196457291946`*^9, 3.8067611816049814`*^9, 3.806820147544272*^9, 
   3.8068204491660433`*^9, 3.807293763067728*^9, 3.8072939061262474`*^9, 
   3.807294871513759*^9, 3.8072951097259617`*^9, 3.807297157682315*^9, 
   3.8073210915331397`*^9, 3.80732323328399*^9, 3.8073245309906073`*^9, 
   3.8073248385602283`*^9, 3.807345830802204*^9, 3.8075803864434385`*^9, 
   3.807580468257147*^9, 3.8075806339629855`*^9, 3.807580678774136*^9, 
   3.8075809354930363`*^9, 3.8075812038093295`*^9, 3.807581320048287*^9, 
   3.8075813775999346`*^9, 3.80758146423903*^9, 3.807581549127282*^9, 
   3.8075815806572886`*^9, 3.80758197001503*^9, 3.8075820518548403`*^9, 
   3.80758212135834*^9, 3.807582210418275*^9, 3.8075823856336403`*^9, 
   3.807582544310808*^9, 3.807582655651515*^9, 3.807582801673309*^9, 
   3.807582952555792*^9, 3.8075830819757385`*^9, 3.8075831396827393`*^9, 
   3.807583351712691*^9, 3.8075834169995265`*^9, 3.8075834852780714`*^9, 
   3.8075835583190174`*^9, {3.80758370356993*^9, 3.807583719498537*^9}, 
   3.807583802906995*^9, 3.807583867011763*^9, 3.8075839748087587`*^9, {
   3.807584041692263*^9, 3.807584061761818*^9}, {3.807584142417838*^9, 
   3.8075841616043186`*^9}, {3.80758431361432*^9, 3.80758433347383*^9}, 
   3.8075844122307515`*^9, 3.807584710881852*^9, 3.8075847878181515`*^9, {
   3.8075848188327503`*^9, 3.807584848186865*^9}, 3.807584940044697*^9, 
   3.8075850293461995`*^9, 3.8075851397366233`*^9, 3.8075853610442142`*^9, 
   3.8075854414340563`*^9, 3.8075872665406756`*^9, 3.807587837725031*^9, 
   3.8075879415974426`*^9, 3.8075880149843636`*^9, 3.8075881212692966`*^9, 
   3.8075882507989025`*^9, 3.807688729312798*^9, 3.807688774587732*^9, 
   3.807689950520274*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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